/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.common;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;

public class Alert
extends JDialog
implements KeyListener {
    private JLabel m_icon = null;
    private JTextArea m_text = null;
    private JButton m_ok = null;
    private JPanel iconPanel = null;

    public Alert(Frame frame, String string, String string2, String string3) {
        super(frame, string, true);
        if (string2 == null || string2.equalsIgnoreCase("")) {
            string2 = "&OK";
        }
        if (frame.getWidth() > 400 || frame.getWidth() < 150) {
            this.setSize(new Dimension(400, 120));
        } else {
            this.setSize(new Dimension(frame.getWidth(), 120));
        }
        this.setDefaultCloseOperation(2);
        UIDefaults uIDefaults = UIManager.getDefaults();
        Container container = this.getContentPane();
        container.setBackground(uIDefaults.getColor(LookAndFeel.DARK_LOOK));
        Color color = container.getBackground();
        this.setBackground(color);
        container.setLayout(new BorderLayout());
        this.setResizable(false);
        this.addKeyListener(this);
        this.m_icon = new JLabel(new ImageIcon(uIDefaults.getImage("Alert.errorImage")));
        this.m_icon.setOpaque(false);
        this.m_icon.setEnabled(true);
        this.iconPanel = new JPanel();
        this.iconPanel.setBackground(color);
        this.iconPanel.setLayout(new FlowLayout(1, 20, 10));
        this.iconPanel.add(this.m_icon);
        this.m_text = new JTextArea(string3);
        this.m_text.setBackground(color);
        this.m_text.setMargin(new Insets(20, 10, 10, 10));
        this.m_text.setDisabledTextColor(new Color(0, 0, 0));
        this.m_text.setEnabled(false);
        this.m_text.setEditable(false);
        this.m_text.setLineWrap(true);
        this.m_text.setWrapStyleWord(true);
        this.m_text.setSize(this.getWidth() - 82, this.getHeight() - 50);
        this.setSize(this.getWidth(), (int)this.m_text.getPreferredSize().getHeight() + 70);
        this.centerIcon();
        this.m_ok = new JButton(string2);
        this.m_ok.setMnemonic(79);
        this.m_ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Alert.this.m_ok_actionPerformed(actionEvent);
            }
        });
        this.m_ok.addKeyListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.m_ok);
        this.getContentPane().add("West", this.iconPanel);
        this.getContentPane().add("South", jPanel);
        this.getContentPane().add("Center", this.m_text);
        this.centerAlert(frame);
        this.setVisible(true);
    }

    private void m_ok_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void centerAlert(Window window) {
        double d = window.getLocationOnScreen().getX() + (double)(window.getWidth() / 2) - (double)(this.getWidth() / 2);
        double d2 = window.getLocationOnScreen().getY() + (double)(window.getHeight() / 2) - (double)(this.getHeight() / 2);
        d = d > 0.0 ? d : 0.0;
        d2 = d2 > 0.0 ? d2 : 0.0;
        this.setLocation((int)d, (int)d2);
    }

    private void centerIcon() {
        ((FlowLayout)this.iconPanel.getLayout()).setHgap(20);
        double d = this.m_icon.getPreferredSize().getHeight();
        int n = 10;
        if ((double)this.getHeight() > d + 80.0) {
            n = (this.getHeight() - (int)d - 60) / 2;
        }
        ((FlowLayout)this.iconPanel.getLayout()).setVgap(n);
    }

    @Override
    public void dispose() {
        this.removeKeyListener(this);
        this.m_ok.removeKeyListener(this);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 27 || keyEvent.getKeyCode() == 79) {
            this.setVisible(false);
        } else if (keyEvent.getComponent().equals(this.m_ok) && keyEvent.getKeyCode() == 10) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }
}

