/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.clientInfo;

import java.security.AccessControlException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;

public class GetClientInfo
extends VBeanCommon {
    static final ID WUI_HOSTNAME = ID.registerProperty("WUI_HOSTNAME");
    static final ID WUI_CLIENT_DATE = ID.registerProperty("WUI_CLIENT_DATE");
    static final ID WUI_CLIENT_TZ = ID.registerProperty("WUI_CLIENT_TZ");
    static final ID WUI_CLIENT_JAVA_VERSION = ID.registerProperty("WUI_CLIENT_JAVA_VERSION");
    static final ID WUI_SYSTEM_PROPERTY = ID.registerProperty("WUI_SYSTEM_PROPERTY");
    private String m_property = null;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil GetClientInfo Utility");
        this.setBeanShortName("WUI");
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUI_HOSTNAME) {
            this.getPropertyLogBefore(string);
            object = this.getHostname();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUI_CLIENT_DATE) {
            this.getPropertyLogBefore(string);
            object = this.getDate();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUI_CLIENT_JAVA_VERSION) {
            this.getPropertyLogBefore(string);
            object = this.getSystemProperty("java.version");
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUI_CLIENT_TZ) {
            this.getPropertyLogBefore(string);
            object = this.getSystemProperty("user.timezone");
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUI_SYSTEM_PROPERTY) {
            this.getPropertyLogBefore(string);
            object = this.getSystemProperty(this.m_property);
            this.m_property = null;
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUI_SYSTEM_PROPERTY) {
            this.setPropertyLogBefore(string, object);
            if (this.checkPLSQLString(object)) {
                this.m_property = (String)object;
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                bl = false;
            }
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    private String getSystemProperty(String string) {
        this.log((byte)1, "getSystemProperty()", "Getting property: " + string);
        String string2 = null;
        if (string != null && string != "") {
            try {
                string2 = System.getProperty(string);
            }
            catch (AccessControlException accessControlException) {
                this.error(306, "getSystemProperty()", this.getTranslatedMessage("ERROR306"));
                string2 = new String("");
            }
        }
        if (string2 == null) {
            this.error(304, "getSystemProperty()", this.getTranslatedMessage("ERROR304", string, null, null));
            string2 = new String("");
        }
        return string2;
    }

    private String getHostname() {
        String string = null;
        if (this.getLocalHost() != null) {
            string = this.getLocalHost().getHostName();
            this.log((byte)1, "getHostName()", string);
        } else {
            this.error(301, "getHostName()", "Could not obtain Host Name");
            string = new String("");
        }
        return string;
    }

    public String getDate() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy M d HH:mm:ss");
        simpleDateFormat.setCalendar(Calendar.getInstance());
        return simpleDateFormat.format(simpleDateFormat.getCalendar().getTime());
    }
}

