/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.util.StringTokenizer;
import oracle.forms.webutil.cApi.CApiFunctions;

public class CParameter {
    public static final int C_VOID = 30;
    public static final int C_CHAR = 31;
    public static final int C_SHORT = 32;
    public static final int C_INT = 33;
    public static final int C_LONG = 34;
    public static final int C_FLOAT = 35;
    public static final int C_DOUBLE = 36;
    public static final int C_PTR = 94;
    public static final int C_CHAR_PTR = 95;
    public static final int C_SHORT_PTR = 96;
    public static final int C_INT_PTR = 97;
    public static final int C_LONG_PTR = 98;
    public static final int C_FLOAT_PTR = 99;
    public static final int C_DOUBLE_PTR = 100;
    public static final int C_IN = 50;
    public static final int C_INOUT = 51;
    public static final int C_OUT = 52;
    private int m_Type;
    private int m_InOut;
    private String m_Value = null;
    private int m_MaxLen;
    private CApiFunctions m_bean = null;

    public CParameter(CApiFunctions cApiFunctions) {
        this.m_bean = cApiFunctions;
    }

    public static boolean isValidType(int n) {
        return n >= 30 && n <= 36 || n >= 94 && n <= 100;
    }

    public boolean isOutOnly() {
        return this.m_InOut == 52;
    }

    public boolean isOut() {
        return this.m_InOut != 50;
    }

    public String getValue() {
        return this.m_Value;
    }

    public void setValue(String string) {
        if (this.m_Type == 95 && this.m_Value != null && this.m_Value.length() > this.m_MaxLen) {
            this.m_bean.error(915, "CParameter.setValue()", this.m_bean.getTranslatedMessage("ERROR915", null, null, null));
        }
        this.m_Value = string;
    }

    public void setType(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 30 && n <= 100 && (n <= 36 || n >= 94)) {
                this.m_Type = n;
            } else {
                this.m_bean.error(916, "CParameter.setType()", this.m_bean.getTranslatedMessage("ERROR916", string, null, null));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_bean.error(916, "CParameter.setType()", this.m_bean.getTranslatedMessage("ERROR916", string, null, null));
        }
    }

    public void setInOut(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n >= 50 && n <= 52) {
                this.m_InOut = n;
            } else {
                this.m_bean.error(937, "CParameter.setInOut()", this.m_bean.getTranslatedMessage("ERROR937", string, null, null));
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.m_bean.error(937, "CParameter.setInOut()", this.m_bean.getTranslatedMessage("ERROR937", string, null, null));
        }
    }

    public int getMaxLen() {
        return this.m_MaxLen;
    }

    public void setMaxLen(String string) {
        try {
            int n = Integer.parseInt(string);
            if (n > 32768 || n < 0) {
                throw new NumberFormatException();
            }
            this.m_MaxLen = n;
        }
        catch (NumberFormatException numberFormatException) {
            this.m_bean.error(938, "CParameter.setMaxLen()", this.m_bean.getTranslatedMessage("ERROR938", string, null, null));
        }
    }

    public int getType() {
        return this.m_Type;
    }

    public boolean setProperties(StringTokenizer stringTokenizer, boolean bl) {
        boolean bl2 = true;
        try {
            if (bl) {
                this.setType(stringTokenizer.nextToken());
                this.setInOut(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                this.setMaxLen(stringTokenizer.nextToken());
            } else if (this.getType() == 95) {
                this.setMaxLen("32768");
            } else {
                this.setMaxLen("0");
            }
        }
        catch (Exception exception) {
            bl2 = false;
            this.m_bean.error(922, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR922", null, null, null));
        }
        try {
            if (stringTokenizer.hasMoreTokens()) {
                this.setValue(stringTokenizer.nextToken());
            } else if (!this.isOutOnly()) {
                bl2 = false;
                this.m_bean.error(923, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR923"));
            } else {
                this.setValue("0");
            }
        }
        catch (Exception exception) {
            bl2 = false;
            this.m_bean.error(922, "CParameter.setProperties()", this.m_bean.getTranslatedMessage("ERROR922", exception.toString(), null, null));
        }
        return bl2;
    }

    public static void main(String[] stringArray) {
        CParameter cParameter = new CParameter(null);
        StringTokenizer stringTokenizer = new StringTokenizer("33|51|100|abc");
        cParameter.setProperties(stringTokenizer, false);
        stringTokenizer = new StringTokenizer("|100|xyzxyz");
        cParameter.setProperties(stringTokenizer, false);
    }
}

