/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.util.Vector;
import oracle.forms.webutil.cApi.CApiFunctions;
import oracle.forms.webutil.cApi.CMalloc;
import oracle.forms.webutil.cApi.CParameter;

public class CParamList {
    static final int C_BYTE_LEN = 1;
    static final int C_DOUBLE_LEN = 8;
    static final int C_FLOAT_LEN = 4;
    static final int C_INT_LEN = 4;
    static final int C_LONG_LEN = 4;
    static final int C_SHORT_LEN = 2;
    static final int C_PTR_LEN = 4;
    static final byte SENTINEL = 85;
    private CApiFunctions m_bean = null;
    private Vector m_plist;

    public CParamList(CApiFunctions cApiFunctions) {
        this.m_bean = cApiFunctions;
        this.m_plist = new Vector();
    }

    public int numParams() {
        return this.m_plist.size();
    }

    public CParameter selectParameter(int n) {
        return (CParameter)this.m_plist.elementAt(n);
    }

    public int addParameter(CParameter cParameter) {
        int n = -1;
        try {
            this.m_plist.add(cParameter);
            n = this.m_plist.size() - 1;
        }
        catch (Exception exception) {
            this.m_bean.error(939, "CParamList.addParamater()", this.m_bean.getTranslatedMessage("ERROR939", null, null, null));
        }
        return n;
    }

    public Object[] toArray() {
        Vector<Object> vector = new Vector<Object>();
        int n = this.m_plist.size();
        CMalloc cMalloc = null;
        block15: for (int i = 0; i < n; ++i) {
            CParameter cParameter = (CParameter)this.m_plist.get(i);
            String string = cParameter.getValue();
            if (cParameter.isOutOnly() && string == null) {
                string = "0";
            }
            switch (cParameter.getType()) {
                case 32: {
                    short s = Short.parseShort(string);
                    vector.add(s);
                    continue block15;
                }
                case 31: {
                    char c = cParameter.getValue().charAt(0);
                    vector.add(Character.valueOf(c));
                    continue block15;
                }
                case 33: {
                    int n2 = Integer.parseInt(string);
                    vector.add(n2);
                    continue block15;
                }
                case 34: {
                    long l = Long.parseLong(string);
                    vector.add(l);
                    continue block15;
                }
                case 35: {
                    float f = Float.parseFloat(string);
                    vector.add(Float.valueOf(f));
                    continue block15;
                }
                case 36: {
                    double d = Double.parseDouble(string);
                    vector.add(d);
                    continue block15;
                }
                case 94: {
                    long l = Long.parseLong(string);
                    vector.add(l);
                    continue block15;
                }
                case 95: {
                    int n3 = cParameter.getMaxLen();
                    if (string.length() > n3) {
                        this.m_bean.error(915, "CParamList.toArray()", this.m_bean.getTranslatedMessage("ERROR915", "", null, null));
                    }
                    cMalloc = new CMalloc(n3 + 1 + 1);
                    cMalloc.setString(0, string);
                    cMalloc.setByte(n3 + 1, (byte)85);
                    vector.add(cMalloc);
                    continue block15;
                }
                case 96: {
                    cMalloc = new CMalloc(2);
                    cMalloc.setShort(0, Short.parseShort(string));
                    vector.add(cMalloc);
                    continue block15;
                }
                case 97: {
                    cMalloc = new CMalloc(4);
                    cMalloc.setInt(0, Integer.parseInt(string));
                    vector.add(cMalloc);
                    continue block15;
                }
                case 98: {
                    cMalloc = new CMalloc(4);
                    cMalloc.setLong(0, Long.parseLong(string));
                    vector.add(cMalloc);
                    continue block15;
                }
                case 99: {
                    cMalloc = new CMalloc(4);
                    cMalloc.setFloat(0, Float.parseFloat(string));
                    vector.add(cMalloc);
                    continue block15;
                }
                case 100: {
                    cMalloc = new CMalloc(8);
                    cMalloc.setDouble(0, Double.parseDouble(string));
                    vector.add(cMalloc);
                    continue block15;
                }
                default: {
                    this.m_bean.error(916, "CParamList.toArray()", this.m_bean.getTranslatedMessage("ERROR916", "" + cParameter.getType(), null, null));
                }
            }
        }
        return vector.toArray();
    }

    public boolean fromArray(Object[] objectArray) {
        boolean bl = true;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        int n = this.m_plist.size();
        CMalloc cMalloc = null;
        if (n != objectArray.length) {
            this.m_bean.error(940, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR940", null, null, null));
        }
        if (n == 0) {
            return true;
        }
        block9: for (int i = 0; i < n; ++i) {
            CParameter cParameter = (CParameter)this.m_plist.get(i);
            if (!cParameter.isOut()) continue;
            switch (cParameter.getType()) {
                case 95: {
                    byte by;
                    int n2 = cParameter.getMaxLen();
                    if (!(objectArray[i] instanceof CMalloc)) {
                        this.m_bean.error(912, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR912", "", null, null));
                        bl = false;
                    }
                    if ((by = (cMalloc = (CMalloc)objectArray[i]).getByte(n2 + 1)) != 85) {
                        this.m_bean.error(913, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR913", "", null, null));
                        bl = false;
                    }
                    cParameter.setValue(cMalloc.getString(0));
                    cMalloc.free();
                    continue block9;
                }
                case 94: {
                    this.m_bean.error(917, "CParamList.fromArray()", this.m_bean.getTranslatedMessage("ERROR917", "", null, null));
                    continue block9;
                }
                case 96: {
                    cMalloc = (CMalloc)objectArray[i];
                    cParameter.setValue("" + cMalloc.getShort(0));
                    cMalloc.free();
                    continue block9;
                }
                case 97: {
                    cMalloc = (CMalloc)objectArray[i];
                    cParameter.setValue("" + cMalloc.getInt(0));
                    cMalloc.free();
                    continue block9;
                }
                case 98: {
                    cMalloc = (CMalloc)objectArray[i];
                    cParameter.setValue("" + cMalloc.getLong(0));
                    cMalloc.free();
                    continue block9;
                }
                case 99: {
                    cMalloc = (CMalloc)objectArray[i];
                    cParameter.setValue("" + cMalloc.getFloat(0));
                    cMalloc.free();
                    continue block9;
                }
                case 100: {
                    cMalloc = (CMalloc)objectArray[i];
                    cParameter.setValue("" + cMalloc.getDouble(0));
                    cMalloc.free();
                    continue block9;
                }
                default: {
                    this.m_bean.error(914, "CApiFunctions.fetchOutParams()", this.m_bean.getTranslatedMessage("ERROR914", "", null, null));
                    bl = false;
                }
            }
        }
        return bl;
    }
}

