/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import oracle.forms.webutil.cApi.CPtr;

public class CMalloc
extends CPtr {
    private int size;

    public CMalloc(int n) {
        this.size = n;
        this.peer = CMalloc.malloc(n);
        if (this.peer == 0L) {
            throw new OutOfMemoryError();
        }
    }

    public void free() {
        CMalloc.free(this.peer);
        this.peer = 0L;
    }

    @Override
    public void copyIn(int n, byte[] byArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 1);
        super.copyIn(n, byArray, n2, n3);
    }

    @Override
    public void copyIn(int n, short[] sArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 2);
        super.copyIn(n, sArray, n2, n3);
    }

    @Override
    public void copyIn(int n, char[] cArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 2);
        super.copyIn(n, cArray, n2, n3);
    }

    @Override
    public void copyIn(int n, int[] nArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 4);
        super.copyIn(n, nArray, n2, n3);
    }

    @Override
    public void copyIn(int n, long[] lArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 8);
        super.copyIn(n, lArray, n2, n3);
    }

    @Override
    public void copyIn(int n, float[] fArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 4);
        super.copyIn(n, fArray, n2, n3);
    }

    @Override
    public void copyIn(int n, double[] dArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 8);
        super.copyIn(n, dArray, n2, n3);
    }

    @Override
    public void copyOut(int n, byte[] byArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 1);
        super.copyOut(n, byArray, n2, n3);
    }

    @Override
    public void copyOut(int n, short[] sArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 2);
        super.copyOut(n, sArray, n2, n3);
    }

    @Override
    public void copyOut(int n, char[] cArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 2);
        super.copyOut(n, cArray, n2, n3);
    }

    @Override
    public void copyOut(int n, int[] nArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 4);
        super.copyOut(n, nArray, n2, n3);
    }

    @Override
    public void copyOut(int n, long[] lArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 8);
        super.copyOut(n, lArray, n2, n3);
    }

    @Override
    public void copyOut(int n, float[] fArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 4);
        super.copyOut(n, fArray, n2, n3);
    }

    @Override
    public void copyOut(int n, double[] dArray, int n2, int n3) {
        this.boundsCheck(n, n3 * 8);
        super.copyOut(n, dArray, n2, n3);
    }

    @Override
    public byte getByte(int n) {
        this.boundsCheck(n, 1);
        return super.getByte(n);
    }

    @Override
    public short getShort(int n) {
        this.boundsCheck(n, 2);
        return super.getShort(n);
    }

    @Override
    public int getInt(int n) {
        this.boundsCheck(n, 4);
        return super.getInt(n);
    }

    @Override
    public long getLong(int n) {
        this.boundsCheck(n, 8);
        return super.getLong(n);
    }

    @Override
    public float getFloat(int n) {
        this.boundsCheck(n, 4);
        return super.getFloat(n);
    }

    @Override
    public double getDouble(int n) {
        this.boundsCheck(n, 8);
        return super.getDouble(n);
    }

    @Override
    public CPtr getCPtr(int n) {
        this.boundsCheck(n, SIZE);
        return super.getCPtr(n);
    }

    @Override
    public String getString(int n) {
        this.boundsCheck(n, 0);
        return super.getString(n);
    }

    @Override
    public void setByte(int n, byte by) {
        this.boundsCheck(n, 1);
        super.setByte(n, by);
    }

    @Override
    public void setShort(int n, short s) {
        this.boundsCheck(n, 2);
        super.setShort(n, s);
    }

    @Override
    public void setInt(int n, int n2) {
        this.boundsCheck(n, 4);
        super.setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) {
        this.boundsCheck(n, 8);
        super.setLong(n, l);
    }

    @Override
    public void setFloat(int n, float f) {
        this.boundsCheck(n, 4);
        super.setFloat(n, f);
    }

    @Override
    public void setDouble(int n, double d) {
        this.boundsCheck(n, 8);
        super.setDouble(n, d);
    }

    @Override
    public void setCPtr(int n, CPtr cPtr) {
        this.boundsCheck(n, SIZE);
        super.setCPtr(n, cPtr);
    }

    @Override
    public void setString(int n, String string) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        this.boundsCheck(n, n2 + 1);
        super.copyIn(n, byArray, 0, n2);
        super.setByte(n + n2, (byte)0);
    }

    private static native long malloc(int var0);

    private static native void free(long var0);

    private CMalloc() {
    }

    private void boundsCheck(int n, int n2) {
        if (n < 0 || n + n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
    }
}

