/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.cApi;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.forms.properties.ID;
import oracle.forms.webutil.cApi.CFunc;
import oracle.forms.webutil.cApi.CParamList;
import oracle.forms.webutil.cApi.CParameter;
import oracle.forms.webutil.cApi.CPtr;
import oracle.forms.webutil.common.VBeanCommon;

public class CApiFunctions
extends VBeanCommon {
    static final ID WUL_REGISTER_FUNCTION = ID.registerProperty("WUL_REGISTER_FUNCTION");
    static final ID WUL_DEREGISTER_FUNCTION = ID.registerProperty("WUL_DEREGISTER_FUNCTION");
    static final ID WUL_CREATE_PARAMLIST = ID.registerProperty("WUL_CREATE_PARAMLIST");
    static final ID WUL_DESTROY_PARAMLIST = ID.registerProperty("WUL_DESTROY_PARAMLIST");
    static final ID WUL_ADD_PARAMETER = ID.registerProperty("WUL_ADD_PARAMETER");
    static final ID WUL_INVOKE = ID.registerProperty("WUL_INVOKE");
    static final ID WUL_FUNCTION_SPEC = ID.registerProperty("WUL_FUNCTION_SPEC");
    static final ID WUL_PARAM_PROPERTIES = ID.registerProperty("WUL_PARAM_PROPERTIES");
    static final ID WUL_PARAM_VALUE = ID.registerProperty("WUL_PARAM_VALUE");
    static final ID WUL_INVOKE_SPEC = ID.registerProperty("WUL_INVOKE_SPEC");
    static final ID WUL_INVOKEONCE_SPEC = ID.registerProperty("WUL_INVOKEONCE_SPEC");
    private int m_argID = -1;
    private Object m_obj = null;
    private String m_libName = "";
    private String m_funcName = "";
    private CFunc m_cfunc = null;
    private int m_returnType = -1;
    private String m_returnValue = "";
    private CParamList m_paramList = null;
    private int m_paramListHnd = -1;
    private String m_paramValue = "";
    private CParameter m_cpar = null;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil C API Functions");
        this.setBeanShortName("WUL");
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUL_CREATE_PARAMLIST) {
            this.getPropertyLogBefore(string);
            object = "" + this.create_paramlist();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUL_ADD_PARAMETER) {
            this.getPropertyLogBefore(string);
            object = "" + this.add_parameter();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUL_REGISTER_FUNCTION) {
            this.getPropertyLogBefore(string);
            object = this.register_function();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUL_INVOKE) {
            this.getPropertyLogBefore(string);
            object = this.invokeCApi();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUL_PARAM_VALUE) {
            this.getPropertyLogBefore(string);
            object = this.fetch_paramval();
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUL_PARAM_PROPERTIES) {
            this.setPropertyLogBefore(string, object);
            if (this.checkPLSQLString(object)) {
                this.setParamProperties((String)object);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                bl = false;
            }
        } else if (iD == WUL_INVOKE_SPEC) {
            this.setPropertyLogBefore(string, object);
            if (this.checkPLSQLString(object)) {
                bl = this.set_invokespec((String)object);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                bl = false;
            }
        } else if (iD == WUL_INVOKEONCE_SPEC) {
            this.setPropertyLogBefore(string, object);
            if (this.checkPLSQLString(object)) {
                bl = this.set_invokeoncespec((String)object);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                bl = false;
            }
        } else if (iD == WUL_FUNCTION_SPEC) {
            this.setPropertyLogBefore(string, object);
            if (this.checkPLSQLString((String)object)) {
                bl = this.set_funcSpec((String)object);
            } else {
                this.error(303, "setProperty()", this.getTranslatedMessage("ERROR303"));
                bl = false;
            }
        } else if (iD == WUL_DESTROY_PARAMLIST) {
            this.setPropertyLogBefore(string, object);
            bl = this.destroy_paramlist(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUL_DEREGISTER_FUNCTION) {
            this.setPropertyLogBefore(string, object);
            bl = this.deregister_function(this.defaultNullPropertyValue(object, null));
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    private boolean set_funcSpec(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        return this.parse_funcSpec(stringTokenizer);
    }

    private boolean parse_funcSpec(StringTokenizer stringTokenizer) {
        boolean bl = false;
        try {
            this.m_libName = stringTokenizer.nextToken();
            this.m_funcName = stringTokenizer.nextToken();
            bl = true;
        }
        catch (Exception exception) {
            this.error(924, "CApiFunctions.parse_funcspec()", this.getTranslatedMessage("ERROR924", "", null, null));
        }
        return bl;
    }

    private boolean parse_funcHnd(StringTokenizer stringTokenizer) {
        boolean bl = false;
        String string = "";
        try {
            string = stringTokenizer.nextToken();
            if (this.setHandle(string)) {
                if (this.m_obj instanceof CFunc) {
                    this.m_cfunc = (CFunc)this.m_obj;
                    bl = true;
                } else {
                    this.error(925, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR925", "CFunc", null, null));
                }
            } else {
                this.error(926, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR926", string, null, null));
            }
        }
        catch (Exception exception) {
            this.error(927, "CApiFunctions.parse_funcHnd()", this.getTranslatedMessage("ERROR927", "funcHnd", null, null));
        }
        return bl;
    }

    private boolean parse_paramListHnd(StringTokenizer stringTokenizer) {
        boolean bl = false;
        String string = "";
        try {
            string = stringTokenizer.nextToken();
            if (string.equalsIgnoreCase("(null)")) {
                this.m_paramListHnd = -1;
                this.m_paramList = null;
                bl = true;
            } else if (this.setHandle(string)) {
                this.m_paramListHnd = this.m_argID;
                if (this.m_obj instanceof CParamList) {
                    this.m_paramList = (CParamList)this.m_obj;
                    bl = true;
                } else {
                    this.error(925, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR925", "paramListHnd", null, null));
                }
            } else {
                this.error(926, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR926", string, null, null));
            }
        }
        catch (Exception exception) {
            this.error(927, "CApiFunctions.parse_paramListHnd()", this.getTranslatedMessage("ERROR927", "paramListHnd", null, null));
        }
        return bl;
    }

    private boolean parse_returnType(StringTokenizer stringTokenizer) {
        boolean bl = true;
        String string = "";
        try {
            string = stringTokenizer.nextToken();
            this.m_returnType = Integer.parseInt(string);
            if (!CParameter.isValidType(this.m_returnType)) {
                bl = false;
                this.m_returnType = -1;
                this.error(911, "CApiFunctions.parse_returnType()", this.getTranslatedMessage("ERROR911", string, null, null));
            }
        }
        catch (Exception exception) {
            bl = false;
            this.error(927, "CApiFunctions.parse_returnType()", this.getTranslatedMessage("ERROR927", "returnType", null, null));
        }
        return bl;
    }

    private boolean set_invokespec(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        bl = this.parse_funcHnd(stringTokenizer) && this.parse_paramListHnd(stringTokenizer) && this.parse_returnType(stringTokenizer);
        return bl;
    }

    private boolean set_invokeoncespec(String string) {
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl2 = bl = this.parse_funcSpec(stringTokenizer) && this.parse_paramListHnd(stringTokenizer) && this.parse_returnType(stringTokenizer);
        if (bl) {
            try {
                this.m_cfunc = new CFunc(this.m_libName, this.m_funcName);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                bl = false;
                this.error(928, "CApiFunctions.set_invokeoncespec()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
            catch (Exception exception) {
                bl = false;
                this.error(928, "CApiFunctions.set_invokeoncespec()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
        }
        return bl;
    }

    private int create_paramlist() {
        try {
            this.m_paramList = new CParamList(this);
            this.m_paramListHnd = this.storeInObjectCache(this.m_paramList);
        }
        catch (Exception exception) {
            this.error(901, "CApiFunctions.create_paramlist()", this.getTranslatedMessage("ERROR901", exception.toString(), null, null));
            this.m_paramListHnd = -1;
            this.m_paramList = null;
        }
        return this.m_paramListHnd;
    }

    private boolean destroy_paramlist(String string) {
        boolean bl = false;
        if (this.setHandle(string)) {
            if (this.m_obj instanceof CParamList) {
                try {
                    this.eraseFromObjectCache(this.m_argID);
                    bl = true;
                }
                catch (Exception exception) {
                    this.error(902, "CApiFunctions.destroy_paramlist()", this.getTranslatedMessage("ERROR902", exception.toString(), null, null));
                }
            } else {
                this.error(12, "CApiFunctions.destroy_paramlist()", this.getTranslatedMessage("ERROR012", "CParamList", null, null));
            }
        }
        this.m_argID = -1;
        this.m_obj = null;
        this.m_paramListHnd = -1;
        this.m_paramList = null;
        return bl;
    }

    private boolean setParamProperties(String string) {
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        boolean bl2 = false;
        String string2 = stringTokenizer.nextToken();
        if (string2.compareTo("B") == 0) {
            bl2 = true;
        } else if (string2.compareTo("R") == 0 || string2.compareTo("F") == 0) {
            bl2 = false;
        } else {
            this.error(929, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR929", string2, null, null));
            return false;
        }
        if (bl2) {
            this.m_cpar = new CParameter(this);
        }
        try {
            String string3 = stringTokenizer.nextToken();
            if (this.select_paramlist(string3)) {
                String string4;
                if (!bl2 && !this.select_parameter(string4 = stringTokenizer.nextToken())) {
                    this.error(930, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR930", string3, string4, null));
                }
                if (string2.compareTo("B") == 0 || string2.compareTo("R") == 0) {
                    bl = this.m_cpar.setProperties(stringTokenizer, bl2);
                }
            } else {
                this.error(931, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR931", string3, null, null));
            }
        }
        catch (Exception exception) {
            this.error(932, "CApiFunctions.setParamProperties()", this.getTranslatedMessage("ERROR932", exception.toString(), null, null));
        }
        return bl;
    }

    private String add_parameter() {
        String string = null;
        if (this.m_paramList != null) {
            try {
                string = "" + this.m_paramList.addParameter(this.m_cpar);
            }
            catch (Exception exception) {
                this.error(903, "CApiFunctions.add_parameter()", this.getTranslatedMessage("ERROR903", exception.toString(), null, null));
                string = null;
            }
        } else {
            this.error(933, "CApiFunctions.add_parameter()", this.getTranslatedMessage("ERROR933", "", null, null));
        }
        return string;
    }

    private String fetch_paramval() {
        String string = null;
        if (this.m_cpar != null) {
            try {
                string = this.m_cpar.getValue();
            }
            catch (Exception exception) {
                this.error(907, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR907", exception.toString(), null, null));
            }
        } else {
            this.error(934, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR934", "", null, null));
        }
        return string;
    }

    private boolean select_paramlist(String string) {
        boolean bl = false;
        if (this.setHandle(string)) {
            this.m_paramListHnd = this.m_argID;
            if (this.m_obj instanceof CParamList) {
                this.m_paramList = (CParamList)this.m_obj;
                bl = true;
            } else {
                this.error(925, "CApiFunctions.select_paramlist()", this.getTranslatedMessage("ERROR925", "CParamList", null, null));
            }
        } else {
            this.error(926, "CApiFunctions.fetch_paramval()", this.getTranslatedMessage("ERROR926", string, null, null));
        }
        return bl;
    }

    private boolean select_parameter(String string) {
        boolean bl = false;
        int n = -1;
        try {
            n = Integer.parseInt(string);
            if (this.m_paramList == null || n < 0 || n > this.m_paramList.numParams() - 1) {
                this.error(935, "CApiFunctions.select_parameter()", this.getTranslatedMessage("ERROR935", "", null, null));
            } else {
                this.m_cpar = this.m_paramList.selectParameter(n);
                bl = true;
            }
        }
        catch (Exception exception) {
            this.error(932, "CApiFunctions.select_parameter()", this.getTranslatedMessage("ERROR932", exception.toString(), null, null));
        }
        return bl;
    }

    private Object register_function() {
        String string = null;
        if (this.m_libName == "" || this.m_libName == null || this.m_funcName == "" || this.m_funcName == null) {
            this.error(936, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR936", this.m_libName, this.m_funcName, null));
        } else {
            File file = new File(this.m_libName);
            if (!file.isAbsolute()) {
                this.m_libName = new File(CApiFunctions.getSyslibPath(), this.m_libName).getPath();
            }
            try {
                this.m_cfunc = new CFunc(this.m_libName, this.m_funcName);
                string = "" + this.storeInObjectCache(this.m_cfunc);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                this.error(928, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR928", this.m_libName, this.m_funcName, null));
            }
            catch (Exception exception) {
                this.error(908, "CApiFunctions.register_function()", this.getTranslatedMessage("ERROR908", this.m_libName + ':' + this.m_funcName, null, null));
            }
        }
        return string;
    }

    private boolean deregister_function(String string) {
        boolean bl = false;
        if (this.setHandle(string)) {
            if (this.m_obj instanceof CFunc) {
                try {
                    this.eraseFromObjectCache(this.m_argID);
                    this.m_argID = -1;
                    this.m_obj = null;
                    bl = true;
                }
                catch (Exception exception) {
                    this.error(909, "CApiFunctions.deregister_function()", this.getTranslatedMessage("ERROR909", exception.toString(), null, null));
                    bl = false;
                }
            } else {
                this.error(12, "CApiFunctions.deregister_function()", this.getTranslatedMessage("ERROR012", "String", null, null));
                bl = false;
            }
        }
        return bl;
    }

    private String invokeCApi() {
        boolean bl = false;
        Object[] objectArray = null;
        try {
            int n = 0;
            float f = 0.0f;
            double d = 0.0;
            CPtr cPtr = null;
            this.m_returnValue = "";
            objectArray = this.m_paramList != null ? this.m_paramList.toArray() : new Vector().toArray();
            switch (this.m_returnType) {
                case 30: {
                    this.m_cfunc.callVoid(objectArray);
                    this.m_returnValue = "";
                    break;
                }
                case 33: {
                    n = this.m_cfunc.callInt(objectArray);
                    this.m_returnValue = "" + n;
                    break;
                }
                case 35: {
                    f = this.m_cfunc.callFloat(objectArray);
                    this.m_returnValue = "" + f;
                    break;
                }
                case 36: {
                    d = this.m_cfunc.callDouble(objectArray);
                    this.m_returnValue = "" + d;
                    break;
                }
                case 95: {
                    cPtr = this.m_cfunc.callCPtr(objectArray);
                    this.m_returnValue = cPtr.getString(0);
                    break;
                }
                case 94: {
                    cPtr = this.m_cfunc.callCPtr(objectArray);
                    this.m_returnValue = "" + cPtr;
                    break;
                }
                default: {
                    this.error(911, "CApiFunctions.invokeCApi()", this.getTranslatedMessage("ERROR911", "", "" + this.m_returnType, null));
                }
            }
            if (this.m_paramList != null) {
                bl = this.m_paramList.fromArray(objectArray);
            }
        }
        catch (Exception exception) {
            this.error(910, "CApiFunctions.invokeCApi()", this.getTranslatedMessage("ERROR910", exception.toString(), null, null));
            bl = false;
        }
        return this.m_returnValue;
    }

    private boolean setHandle(String string) {
        boolean bl = false;
        int n = -1;
        try {
            n = Integer.parseInt(string);
            if (n < 0) {
                throw new NumberFormatException();
            }
            Object object = this.getFromObjectCache(n);
            this.m_argID = n;
            this.m_obj = object;
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            this.error(904, "CApiFunctions.setHandle()", this.getTranslatedMessage("ERROR904", string, null, null));
        }
        catch (NullPointerException nullPointerException) {
            this.error(905, "CApiFunctions.setHandle()", this.getTranslatedMessage("ERROR905", string, null, null));
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        CApiFunctions cApiFunctions = new CApiFunctions();
        String string = null;
        Object var3_3 = null;
        String string2 = null;
        String string3 = null;
        String string4 = "hello world";
        int n = 0;
        Object var8_8 = null;
        string = (String)cApiFunctions.getProperty(WUL_CREATE_PARAMLIST);
        string4 = "qweaaaaaaaaaaaaaaaaaaaaaaaaaaaaxyz";
        cApiFunctions.setProperty(WUL_PARAM_PROPERTIES, "B|" + string + "|" + 95 + "|" + 51 + "|" + string4.length() + "|" + string4);
        string2 = (String)cApiFunctions.getProperty(WUL_ADD_PARAMETER);
        n = string4.length();
        cApiFunctions.setProperty(WUL_PARAM_PROPERTIES, "B|" + string + "|" + 97 + "|" + 51 + "|" + 0 + "|" + n);
        string3 = (String)cApiFunctions.getProperty(WUL_ADD_PARAMETER);
        cApiFunctions.setProperty(WUL_INVOKEONCE_SPEC, "testwebutil.dll|PopulateString|" + string + "|" + 33);
        string4 = (String)cApiFunctions.getProperty(WUL_INVOKE);
        cApiFunctions.setProperty(WUL_PARAM_PROPERTIES, "F|" + string + '|' + string2);
        string4 = (String)cApiFunctions.getProperty(WUL_PARAM_VALUE);
        cApiFunctions.setProperty(WUL_PARAM_PROPERTIES, "F|" + string + '|' + string3);
        n = Integer.parseInt((String)cApiFunctions.getProperty(WUL_PARAM_VALUE));
        cApiFunctions.setProperty(WUL_DESTROY_PARAMLIST, string);
        cApiFunctions.setProperty(WUL_INVOKEONCE_SPEC, "testwebutil.dll|fifteen|(null)|33");
        string4 = (String)cApiFunctions.getProperty(WUL_INVOKE);
    }

    @Override
    public void destroy() {
        super.destroy();
        System.gc();
    }
}

