/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.webutil.browser;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import oracle.forms.engine.Main;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.webutil.common.VBeanCommon;

public class BrowserFunctions
extends VBeanCommon {
    private static final ID WUB_SHOWMENUBAR = ID.registerProperty("WUB_SHOWMENUBAR");
    private static final ID WUB_SHOWSTATUSBAR = ID.registerProperty("WUB_SHOWSTATUSBAR");
    private static final ID WUB_SEPARATEFRAME_TITLE = ID.registerProperty("WUB_SEPARATEFRAME_TITLE");
    private static final ID WUB_SEPARATEFRAME_RESIZABLE = ID.registerProperty("WUB_SEPARATEFRAME_RESIZABLE");
    private static final ID WUB_SEPARATEFRAME_CENTER = ID.registerProperty("WUB_SEPARATEFRAME_CENTER");
    private static final ID WUB_SEPARATEFRAME_ICON = ID.registerProperty("WUB_SEPARATEFRAME_ICON");
    private static final ID WUB_BROWSER_MESSAGE = ID.registerProperty("WUB_BROWSER_MESSAGE");
    private static final ID WUB_SEPARATEFRAME_MODE = ID.registerProperty("WUB_SEPARATEFRAME_MODE");
    private static final ID WUB_APPLET_SIZE = ID.registerProperty("WUB_APPLET_SIZE");
    private static final ID WUB_APPLET_PARAMETER = ID.registerProperty("WUB_APPLET_PARAMETER");
    private boolean m_separateFrame = false;
    private boolean m_useCodeBase = false;
    private Main m_formsApplet = null;
    private String m_property = null;

    @Override
    public void setBeanInfo() {
        this.setBeanName("WebUtil Browser Functions");
        this.setBeanShortName("WUB");
    }

    @Override
    public void init(IHandler iHandler) {
        super.init(iHandler);
        this.m_separateFrame = iHandler.getApplet().useSeparateFrame();
        this.m_useCodeBase = "CODEBASE".equalsIgnoreCase(iHandler.getApplet().getParameter("ImageBase"));
        this.m_formsApplet = iHandler.getApplet();
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        this.setErrorCondition(0);
        String string = iD.getName();
        if (iD == WUB_SHOWMENUBAR) {
            this.setPropertyLogBefore(string, object);
            bl = this.showMenuBar(this.defaultNullPropertyValue(object, "TRUE"));
        } else if (iD == WUB_SHOWSTATUSBAR) {
            this.setPropertyLogBefore(string, object);
            bl = this.showStatusBar(this.defaultNullPropertyValue(object, "TRUE"));
        } else if (iD == WUB_SEPARATEFRAME_TITLE) {
            this.setPropertyLogBefore(string, object);
            bl = this.setSeparateFrameTitle(this.defaultNullPropertyValue(object, ""));
        } else if (iD == WUB_SEPARATEFRAME_RESIZABLE) {
            this.setPropertyLogBefore(string, object);
            bl = this.setSeparateFrameResizable(this.defaultNullPropertyValue(object, "TRUE"));
        } else if (iD == WUB_SEPARATEFRAME_CENTER) {
            this.setPropertyLogBefore(string, object);
            bl = this.centerSeparateFrame(this.defaultNullPropertyValue(object, "TRUE"));
        } else if (iD == WUB_SEPARATEFRAME_ICON) {
            this.setPropertyLogBefore(string, object);
            bl = this.setSeparateFrameIcon(this.defaultNullPropertyValue(object, null));
        } else if (iD == WUB_BROWSER_MESSAGE) {
            this.setPropertyLogBefore(string, object);
            this.message(this.safePrint(object));
        } else if (iD == WUB_APPLET_PARAMETER) {
            this.setPropertyLogBefore(string, object);
            this.m_property = this.defaultNullPropertyValue(object, null);
        } else {
            bl = super.setProperty(iD, object);
        }
        return bl;
    }

    @Override
    public Object getProperty(ID iD) {
        Object object = null;
        if (iD != WUC_CHECK_ERROR) {
            this.setErrorCondition(0);
        }
        String string = iD.getName();
        if (iD == WUB_SEPARATEFRAME_MODE) {
            this.getPropertyLogBefore(string);
            object = this.m_separateFrame ? "TRUE" : "FALSE";
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUB_APPLET_SIZE) {
            this.getPropertyLogBefore(string);
            object = this.getAppletSize();
            this.getPropertyLogAfter(string, object);
        } else if (iD == WUB_APPLET_PARAMETER) {
            this.getPropertyLogBefore(string);
            object = this.getAppletParam(this.m_property);
            this.m_property = null;
            this.getPropertyLogAfter(string, object);
        } else {
            object = super.getProperty(iD);
        }
        return object;
    }

    private boolean showMenuBar(String string) {
        boolean bl;
        boolean bl2 = bl = !"FALSE".equalsIgnoreCase(string);
        if (this.m_formsApplet.getMDIContainer().getDefaultMenuBar() != null) {
            this.m_formsApplet.getMDIContainer().getDefaultMenuBar().setVisible(bl);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.showMenuBar()", "No default menu bar found");
        }
        return true;
    }

    private boolean showStatusBar(String string) {
        boolean bl;
        boolean bl2 = bl = !"FALSE".equalsIgnoreCase(string);
        if (this.m_formsApplet.getMDIContainer().getDefaultStatusBar() != null) {
            this.m_formsApplet.getMDIContainer().getDefaultStatusBar().setVisible(bl);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.showMenuBar()", "No default status bar found");
        }
        return true;
    }

    private boolean setSeparateFrameTitle(String string) {
        if (this.m_separateFrame) {
            this.getFrame().setTitle(string);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.setSeparateFrameTitle()", "Not running in separateFrame - can't change frame title");
        }
        return true;
    }

    private boolean setSeparateFrameIcon(String string) {
        boolean bl = false;
        Image image = null;
        URL uRL = null;
        URL uRL2 = null;
        URL uRL3 = null;
        if (this.m_separateFrame) {
            if (string != null && !string.equals("")) {
                ImageIcon imageIcon;
                if (this.m_useCodeBase) {
                    if (this.isLogging()) {
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Searching Codebase for icon");
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "CODEBASE=" + this.m_formsApplet.getCodeBase().toString());
                    }
                    try {
                        uRL = new URL(this.m_formsApplet.getCodeBase(), string);
                        imageIcon = new ImageIcon(uRL);
                        if (imageIcon.getImageLoadStatus() == 4) {
                            image = null;
                        } else {
                            image = imageIcon.getImage();
                            uRL3 = uRL;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.error(600, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR600"));
                        return false;
                    }
                }
                if (image == null) {
                    if (this.isLogging()) {
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Searching DocumentBase for icon");
                        this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "DOCUMENTBASE=" + this.m_formsApplet.getDocumentBase().toString());
                    }
                    try {
                        uRL2 = new URL(this.m_formsApplet.getDocumentBase(), string);
                        imageIcon = new ImageIcon(uRL2);
                        if (imageIcon.getImageLoadStatus() == 4) {
                            image = null;
                        } else {
                            image = imageIcon.getImage();
                            uRL3 = uRL2;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.error(601, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR601"));
                        return false;
                    }
                }
                if (image != null) {
                    this.getFrame().setIconImage(image);
                    bl = true;
                    this.log((byte)1, "BrowserFunctions.setSeparateFrameIcon()", "Loaded icon image " + uRL3.toString());
                } else if (uRL != null && !uRL.equals(uRL2)) {
                    this.error(603, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR603", uRL.toString() + " or " + uRL2.toString(), null, null));
                } else {
                    this.error(603, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR603", uRL2.toString(), null, null));
                }
            } else {
                this.error(602, "BrowserFunctions.setSeparateFrameIcon()", this.getTranslatedMessage("ERROR602"));
            }
        } else {
            if (this.isLogging()) {
                this.log((byte)0, "BrowserFunctions.setSeparateFrameIcon()", "Not running in separateFrame - Icon not set");
            }
            bl = true;
        }
        return bl;
    }

    private boolean centerSeparateFrame(String string) {
        if (this.m_separateFrame) {
            int n = 0;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension2 = this.getFrame().getSize();
            if (dimension2.height > dimension.height) {
                dimension2.height = dimension.height;
            }
            if (dimension2.width > dimension.width) {
                dimension2.width = dimension.width;
            }
            this.getFrame().setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2 + n);
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.centerSeparateFrame()", "Not running in separateFrame - Center command ignored");
        }
        return true;
    }

    private boolean setSeparateFrameResizable(String string) {
        if (this.m_separateFrame) {
            this.getFrame().setResizable(!"FALSE".equalsIgnoreCase(string));
        } else if (this.isLogging()) {
            this.log((byte)0, "BrowserFunctions.setSeparateFrameResizable()", "Not running in separateFrame - can't change frame attributes");
        }
        return true;
    }

    private String getAppletSize() {
        return "" + this.m_formsApplet.getMDIContainer().getWidth() + "," + this.m_formsApplet.getMDIContainer().getHeight();
    }

    public String getAppletParam(String string) {
        String string2 = null;
        string2 = string != null ? this.m_formsApplet.getParameter(string) : new String("");
        return string2;
    }
}

