/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.mdi;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenu;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuEvent;
import oracle.ewt.lwAWT.lwMenu.LWPopupMenuListener;
import oracle.ewt.lwAWT.lwMenu.LWRadioButtonMenuItem;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.forms.engine.Runform;
import oracle.forms.ui.ExtendedFrame;

public class MDIWindowMenu
extends LWComponent
implements LWPopupMenuListener,
Comparator {
    private boolean _menuFlag;
    private Desktop _desktop;
    private Runform _dispatcher;
    private int _windowCount;

    public MDIWindowMenu(Desktop desktop, LWPopupMenu lWPopupMenu, Runform runform) {
        this._desktop = desktop;
        lWPopupMenu.addPopupMenuListener(this);
        this._dispatcher = runform;
    }

    @Override
    public void menuPoppingUp(LWPopupMenuEvent lWPopupMenuEvent) {
        this._addWindowItems((LWPopupMenu)lWPopupMenuEvent.getSource());
    }

    @Override
    public void menuPoppedUp(LWPopupMenuEvent lWPopupMenuEvent) {
    }

    @Override
    public void menuPoppedDown(LWPopupMenuEvent lWPopupMenuEvent) {
        this._removeWindowItems((LWPopupMenu)lWPopupMenuEvent.getSource());
    }

    private synchronized void _addWindowItems(LWPopupMenu lWPopupMenu) {
        if (this._menuFlag) {
            return;
        }
        this._menuFlag = true;
        this._windowCount = 0;
        int n = this._getComponentIndex();
        Enumeration enumeration = this._desktop.getWindows();
        int n2 = this._desktop.getWindowCount();
        Object[] objectArray = new Object[n2];
        int n3 = 0;
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow = (LWWindow)enumeration.nextElement();
            if (!lWWindow.isVisible() || !(lWWindow instanceof ExtendedFrame)) continue;
            objectArray[n3++] = lWWindow;
        }
        this._windowCount = n3;
        if (this._windowCount != 0) {
            if (n3 != 1) {
                Sort.qSort(objectArray, n3, this);
            }
            for (int i = 0; i < this._windowCount; ++i) {
                ExtendedFrame extendedFrame = (ExtendedFrame)objectArray[i];
                String string = extendedFrame.getTitle();
                char c = Character.forDigit(i + 1, 36);
                LWRadioButtonMenuItem lWRadioButtonMenuItem = new LWRadioButtonMenuItem(c + " " + string, extendedFrame.isActive());
                lWRadioButtonMenuItem.addActionListener(new Activater(extendedFrame));
                lWRadioButtonMenuItem.setMnemonicChar(c);
                if (this._dispatcher != null && this._dispatcher.getApplet().hasDarkLook() && this._dispatcher.getApplet().hasCustomColorScheme()) {
                    Color color = lWPopupMenu.getBackground();
                    if (color == null) {
                        color = UIManager.getLookAndFeel().getDefaults().getColor(LookAndFeel.MENU);
                    }
                    if (ColorUtils.getApproximateLuminance(color) <= this._dispatcher.getDarkLuminance()) {
                        lWRadioButtonMenuItem.setForeground(Color.white);
                    }
                }
                lWPopupMenu.add((Component)lWRadioButtonMenuItem, n++ + 1);
            }
        }
    }

    private void _removeWindowItems(LWPopupMenu lWPopupMenu) {
        int n = this._getComponentIndex();
        if (!this._menuFlag) {
            return;
        }
        this._menuFlag = false;
        for (int i = 0; i < this._windowCount; ++i) {
            lWPopupMenu.remove(n + 1);
        }
        this._windowCount = 0;
    }

    private int _getComponentIndex() {
        Container container = this.getParent();
        assert (container != null);
        int n = 0;
        Object object = container.getTreeLock();
        synchronized (object) {
            while (true) {
                if (container.getComponent(n) == this) {
                    return n;
                }
                ++n;
            }
        }
    }

    @Override
    public int compare(Object object, Object object2) {
        ExtendedFrame extendedFrame = (ExtendedFrame)object;
        ExtendedFrame extendedFrame2 = (ExtendedFrame)object2;
        if (extendedFrame.getWindowSequence() == extendedFrame2.getWindowSequence()) {
            return 0;
        }
        if (extendedFrame.getWindowSequence() < extendedFrame2.getWindowSequence()) {
            return -1;
        }
        return 0;
    }

    private class Activater
    implements ActionListener {
        private LWWindow _window;

        public Activater(LWWindow lWWindow) {
            this._window = lWWindow;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this._window.isMinimized()) {
                this._window.setMinimized(false);
            }
            this._window.setActive(true);
        }
    }
}

