/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.mdi;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.DesktopContainer;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;

public class MDIUtils {
    private MDIUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cascadeWindows(Desktop desktop, int n, int n2) {
        Rectangle rectangle = MDIUtils.getDesktopBounds(desktop);
        Component component = desktop.getDesktopComponent();
        DesktopContainer desktopContainer = (DesktopContainer)desktop.getDesktopComponent();
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width * 70 / 100;
        int n6 = rectangle.height * 60 / 100;
        Object object = component.getTreeLock();
        synchronized (object) {
            int n7 = desktop.getWindowCount();
            desktopContainer.freezeRepaints();
            for (int i = n7 - 1; i >= 0; --i) {
                LWWindow lWWindow = desktop.getWindow(i);
                if (lWWindow.getType() != WindowType.FRAME || !lWWindow.isVisible() || !lWWindow.isResizable()) continue;
                if (n3 > rectangle.x + rectangle.width || n4 > rectangle.y + rectangle.height) {
                    n3 = rectangle.x;
                    n4 = rectangle.y;
                }
                MDIUtils._restoreWindow(lWWindow);
                lWWindow.setBounds(n3, n4, n5, n6);
                n3 += n;
                n4 += n2;
            }
            desktopContainer.unfreezeRepaints();
        }
        component.validate();
    }

    public static void tileWindowsHorizontally(Desktop desktop) {
        int n = MDIUtils._getTileCount(desktop);
        int n2 = (int)Math.sqrt(n);
        DesktopContainer desktopContainer = (DesktopContainer)desktop.getDesktopComponent();
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = n / n2;
        int n4 = n - n2 * n3;
        Component component = desktop.getDesktopComponent();
        Rectangle rectangle = MDIUtils.getDesktopBounds(desktop);
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = desktop.getWindowCount();
        desktopContainer.freezeRepaints();
        for (int i = 0; i < n8; ++i) {
            LWWindow lWWindow = desktop.getWindow(i);
            if (!MDIUtils._canTile(lWWindow)) continue;
            if (n5 == n7) {
                n5 = 0;
                n7 = n2;
                if (++n6 >= n3 - n4) {
                    ++n7;
                }
            }
            int n9 = rectangle.x + rectangle.width / n7 * n5;
            int n10 = rectangle.width / n7;
            int n11 = rectangle.y + rectangle.height / n3 * n6;
            int n12 = rectangle.height / n3;
            MDIUtils._restoreWindow(lWWindow);
            lWWindow.setBounds(n9, n11, n10, n12);
            ++n5;
        }
        desktopContainer.unfreezeRepaints();
        component.validate();
    }

    public static void tileWindowsVertically(Desktop desktop) {
        int n = MDIUtils._getTileCount(desktop);
        int n2 = (int)Math.sqrt(n);
        DesktopContainer desktopContainer = (DesktopContainer)desktop.getDesktopComponent();
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = n / n2;
        int n4 = n - n2 * n3;
        Component component = desktop.getDesktopComponent();
        Rectangle rectangle = MDIUtils.getDesktopBounds(desktop);
        int n5 = 0;
        int n6 = 0;
        int n7 = n2;
        int n8 = desktop.getWindowCount();
        desktopContainer.freezeRepaints();
        for (int i = 0; i < n8; ++i) {
            LWWindow lWWindow = desktop.getWindow(i);
            if (!MDIUtils._canTile(lWWindow)) continue;
            if (n5 == n7) {
                n5 = 0;
                n7 = n2;
                if (++n6 >= n3 - n4) {
                    ++n7;
                }
            }
            int n9 = rectangle.x + rectangle.width / n3 * n6;
            int n10 = rectangle.width / n3;
            int n11 = rectangle.y + rectangle.height / n7 * n5;
            int n12 = rectangle.height / n7;
            MDIUtils._restoreWindow(lWWindow);
            lWWindow.setBounds(n9, n11, n10, n12);
            ++n5;
        }
        desktopContainer.unfreezeRepaints();
        component.validate();
    }

    public static Rectangle getDesktopBounds(Desktop desktop) {
        Component component = desktop.getDesktopComponent();
        Rectangle rectangle = component.getBounds();
        if (component instanceof Container) {
            Insets insets = ((Container)component).getInsets();
            rectangle.x = insets.left;
            rectangle.y = insets.top;
            rectangle.width -= insets.left + insets.right;
            rectangle.height -= insets.top + insets.bottom;
        } else {
            rectangle.y = 0;
            rectangle.x = 0;
        }
        return rectangle;
    }

    private static boolean _canTile(LWWindow lWWindow) {
        return lWWindow.getType() == WindowType.FRAME && lWWindow.isVisible() && lWWindow.isResizable();
    }

    private static int _getTileCount(Desktop desktop) {
        int n = 0;
        Enumeration enumeration = desktop.getWindows();
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow = (LWWindow)enumeration.nextElement();
            if (lWWindow.getType() != WindowType.FRAME || !lWWindow.isVisible()) continue;
            ++n;
        }
        return n;
    }

    private static void _restoreWindow(LWWindow lWWindow) {
        if (lWWindow.isMinimized()) {
            lWWindow.setMinimized(false);
        } else if (lWWindow.isMaximized()) {
            lWWindow.setMaximized(false);
        }
    }
}

