/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.mdi;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import oracle.ewt.EwtComponent;
import oracle.ewt.imageCanvas.ImageCanvas;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwWindow.Desktop;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.lwAWT.lwWindow.WindowType;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.forms.ui.mdi.ActivationTracker;

public class MDIContainer
extends LWComponent
implements ComponentListener,
PropertyChangeListener {
    private LWWindow _activeWindow;
    private Component _defaultMenuBar;
    private Component _defaultStatusBar;
    private Component _defaultHorizontalToolBar;
    private Component _defaultVerticalToolBar;
    private Component _defaultHorizontalClientToolBar;
    private Component _defaultVerticalClientToolBar;
    private LWComponent _northPane;
    private LWComponent _imagePane;
    private LWComponent _westPane;
    private Component _addedMenuBar;
    private Component _addedHorizontalToolBar;
    private Component _addedVerticalToolBar;
    private Component _addedHorizontalClientToolBar;
    private Component _addedVerticalClientToolBar;
    private Component _addedStatusBar;
    private Desktop _desktop;
    private Dimension _size;
    private EwtComponent _borderComp;
    private int _freezeCount;
    private Dimension _canvasSize = new Dimension(0, 0);
    private ScrollBox _box;
    private ImageCanvas _ic;
    private int _guiMode;
    private static final int NO_NORTHPANE_MASK = 1;

    public MDIContainer(Desktop desktop, int n, Image image) {
        this._guiMode = n;
        this._borderComp = new EwtComponent();
        this._borderComp.setLayout(new BorderLayout());
        this._box = new ScrollBox(desktop.getDesktopComponent(), 0, 0);
        this._box.setBorderPainter(null);
        this._northPane = new LWComponent();
        this._northPane.setLayout(new BorderLayout());
        this._imagePane = new LWComponent();
        this._imagePane.setLayout(new BorderLayout());
        this._westPane = new LWComponent();
        this._westPane.setLayout(new BorderLayout());
        this.setLayout(new BorderLayout());
        if (image != null) {
            this._ic = new ImageCanvas(image);
            this.addSynchronized(this._imagePane, "East", this._ic);
        }
        this.addSynchronized(this._borderComp, "Center", this._box);
        this.addSynchronized(this._northPane, "North", this._imagePane);
        this.addSynchronized(this, "Center", this._borderComp);
        this.addSynchronized(this, "North", this._northPane);
        this.addSynchronized(this, "West", this._westPane);
        ActivationTracker activationTracker = new ActivationTracker(desktop);
        activationTracker.addPropertyChangeListener(this);
        desktop.getDesktopComponent().addComponentListener(this);
        this._desktop = desktop;
    }

    public Component getDefaultMenuBar() {
        return this._defaultMenuBar;
    }

    public Component getDefaultStatusBar() {
        return this._defaultStatusBar;
    }

    public Component getDefaultHorizontalToolBar() {
        return this._defaultHorizontalToolBar;
    }

    public Component getDefaultHorizontalClientToolBar() {
        return this._defaultHorizontalClientToolBar;
    }

    public Component getDefaultVerticalToolBar() {
        return this._defaultVerticalToolBar;
    }

    public ScrollBox getMDIScrollBox() {
        return this._box;
    }

    public ImageCanvas getImageCanvas() {
        return this._ic;
    }

    public Component getDefaultVerticalClientToolBar() {
        return this._defaultVerticalClientToolBar;
    }

    public void setDefaultMenuBar(Component component) {
        if (component != this._defaultMenuBar) {
            Component component2 = this._defaultMenuBar;
            this._defaultMenuBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateMenuBar(null);
            }
        }
    }

    public void setDefaultStatusBar(Component component) {
        if (component != this._defaultStatusBar) {
            Component component2 = this._defaultStatusBar;
            this._defaultStatusBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateStatusBar(null);
            }
        }
    }

    public void setDefaultHorizontalToolBar(Component component) {
        if (component != this._defaultHorizontalToolBar) {
            Component component2 = this._defaultHorizontalToolBar;
            this._defaultHorizontalToolBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateHorizontalToolBar(null);
            }
        }
    }

    public void setDefaultHorizontalClientToolBar(Component component) {
        if (component != this._defaultHorizontalClientToolBar) {
            Component component2 = this._defaultHorizontalClientToolBar;
            this._defaultHorizontalClientToolBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateHorizontalClientToolBar(null);
            }
        }
    }

    public void setDefaultVerticalToolBar(Component component) {
        if (component != this._defaultVerticalToolBar) {
            Component component2 = this._defaultVerticalToolBar;
            this._defaultVerticalToolBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateVerticalToolBar(null);
            }
        }
    }

    public void setDefaultVerticalClientToolBar(Component component) {
        if (component != this._defaultVerticalClientToolBar) {
            Component component2 = this._defaultVerticalClientToolBar;
            this._defaultVerticalClientToolBar = component;
            if (this._getActiveWindow() == null) {
                this.__updateVerticalClientToolBar(null);
            }
        }
    }

    void __setActiveWindow(LWWindow lWWindow) {
        this._activeWindow = lWWindow;
    }

    void __updateMenuBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiMenuBar");
        if (component == null) {
            component = this.getDefaultMenuBar();
        }
        if (component != this._addedMenuBar) {
            if (this._addedMenuBar != null) {
                this.removeSynchronized(this._imagePane, this._addedMenuBar);
            }
            if (component != null) {
                this.addSynchronized(this._imagePane, "Center", component);
            }
            this._addedMenuBar = component;
        }
    }

    void __updateStatusBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiStatusBar");
        if (component == null) {
            component = this.getDefaultStatusBar();
        }
        if (component != this._addedStatusBar) {
            if (this._addedStatusBar != null) {
                this.removeSynchronized(this, this._addedStatusBar);
            }
            if (component != null) {
                this.addSynchronized(this, "South", component);
            }
            this._addedStatusBar = component;
        }
    }

    void __updateHorizontalToolBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiHorizontalToolBar");
        if (component == null) {
            component = this.getDefaultHorizontalToolBar();
        }
        if (component != this._addedHorizontalToolBar) {
            if (this._addedHorizontalToolBar != null) {
                this.removeSynchronized(this._northPane, this._addedHorizontalToolBar);
                this._addedHorizontalToolBar.removeComponentListener(this);
            }
            if (component != null) {
                this.addSynchronized(this._northPane, "Center", component);
                component.addComponentListener(this);
            }
            this._addedHorizontalToolBar = component;
        }
    }

    void __updateHorizontalClientToolBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiHorizontalClientToolBar");
        if (component == null) {
            component = this.getDefaultHorizontalClientToolBar();
        }
        if (component != this._addedHorizontalClientToolBar) {
            if (this._addedHorizontalClientToolBar != null) {
                this.removeSynchronized(this._northPane, this._addedHorizontalClientToolBar);
                this._addedHorizontalClientToolBar.removeComponentListener(this);
            }
            if (component != null) {
                this.addSynchronized(this._northPane, "South", component);
                component.addComponentListener(this);
            }
            this._addedHorizontalClientToolBar = component;
        }
    }

    void __updateVerticalToolBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiVerticalToolBar");
        if (component == null) {
            component = this.getDefaultVerticalToolBar();
        }
        if (component != this._addedVerticalToolBar) {
            if (this._addedVerticalToolBar != null) {
                this.removeSynchronized(this._westPane, this._addedVerticalToolBar);
                this._addedVerticalToolBar.removeComponentListener(this);
            }
            if (component != null) {
                this.addSynchronized(this._westPane, "West", component);
                component.addComponentListener(this);
            }
            this._addedVerticalToolBar = component;
        }
    }

    void __updateVerticalClientToolBar(LWWindow lWWindow) {
        Component component = (Component)this._getWindowProperty(lWWindow, "mdiVerticalClientToolBar");
        if (component == null) {
            component = this.getDefaultVerticalClientToolBar();
        }
        if (component != this._addedVerticalClientToolBar) {
            if (this._addedVerticalClientToolBar != null) {
                this.removeSynchronized(this._westPane, this._addedVerticalClientToolBar);
                this._addedVerticalClientToolBar.removeComponentListener(this);
            }
            if (component != null) {
                this.addSynchronized(this._westPane, "East", component);
                component.addComponentListener(this);
            }
            this._addedVerticalClientToolBar = component;
        }
    }

    private LWWindow _getActiveWindow() {
        return this._activeWindow;
    }

    private Object _getWindowProperty(LWWindow lWWindow, String string) {
        while (lWWindow != null) {
            Object object = lWWindow.getClientProperty(string);
            if (object != null) {
                return object;
            }
            lWWindow = lWWindow.getLeader();
        }
        return null;
    }

    public LWComponent _getContent() {
        return this._borderComp;
    }

    public void updateWindowProperties(LWWindow lWWindow) {
        if (this._getActiveWindow() == lWWindow) {
            this.__updateMenuBar(lWWindow);
            this.__updateHorizontalToolBar(lWWindow);
            this.__updateHorizontalClientToolBar(lWWindow);
            this.__updateVerticalToolBar(lWWindow);
            this.__updateVerticalClientToolBar(lWWindow);
            this.__updateStatusBar(lWWindow);
            if (this._freezeCount == 0) {
                this.validate();
            }
        }
    }

    public void suspendPainting() {
        if (this._freezeCount++ == 0 && this._desktop instanceof LWComponent) {
            ((LWComponent)((Object)this._desktop)).freezeRepaints();
            this._northPane.freezeRepaints();
            this._westPane.freezeRepaints();
        }
    }

    public void resumePainting() {
        if ((this._freezeCount == 0 || --this._freezeCount == 0) && this._desktop instanceof LWComponent) {
            ((LWComponent)((Object)this._desktop)).unfreezeRepaints();
            this._northPane.unfreezeRepaints();
            this._westPane.unfreezeRepaints();
            String string = System.getProperty("java.version");
            if (!string.startsWith("1.1")) {
                if (EventQueue.isDispatchThread()) {
                    this.validate();
                } else {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MDIContainer.this.validate();
                        }
                    });
                }
            } else {
                this.validate();
            }
        }
    }

    public boolean isPaintingSuspended() {
        return this._freezeCount != 0;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("activeWindow")) {
            LWWindow lWWindow = (LWWindow)propertyChangeEvent.getNewValue();
            Enumeration enumeration = this._desktop.getWindows();
            if (lWWindow == null) {
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    LWWindow lWWindow2 = (LWWindow)enumeration.nextElement();
                    if (lWWindow2.getType() != WindowType.FRAME || !lWWindow2.isVisible()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    return;
                }
            }
            this.__updateMenuBar(lWWindow);
            this.__updateHorizontalToolBar(lWWindow);
            this.__updateVerticalToolBar(lWWindow);
            this.__updateHorizontalClientToolBar(lWWindow);
            this.__updateVerticalClientToolBar(lWWindow);
            this.__updateStatusBar(lWWindow);
            if (this._freezeCount == 0) {
                this.validate();
            }
            this.__setActiveWindow(lWWindow);
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        if (this._freezeCount == 0) {
            this.validate();
        }
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this._freezeCount == 0) {
            this.validate();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        if (this._freezeCount == 0) {
            this.validate();
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Enumeration enumeration = this._desktop.getWindows();
        boolean bl = false;
        Dimension dimension = this.getSize();
        if (this._size == null) {
            this._size = this.getSize();
        }
        int n = dimension.width - this._size.width;
        this._size = dimension;
        while (enumeration.hasMoreElements()) {
            LWWindow lWWindow = (LWWindow)enumeration.nextElement();
            if (lWWindow.getActualReadingDirection() != 2) continue;
            Point point = lWWindow.getLocation();
            lWWindow.setLocation(point.x + n, point.y);
            bl = true;
        }
        if (bl && n != 0) {
            this._box.invalidate();
        }
        if (this._freezeCount == 0) {
            this.validate();
        }
    }

    @Override
    public void validate() {
        if (this.isGuiModeNorthPaneLess() && this._addedMenuBar == null) {
            this._imagePane.setVisible(false);
            if (this._addedHorizontalToolBar == null && this._addedHorizontalClientToolBar == null) {
                this._northPane.setVisible(false);
            } else {
                this._northPane.setVisible(true);
            }
        } else {
            this._imagePane.setVisible(true);
            this._northPane.setVisible(true);
        }
        super.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSynchronized(Container container, String string, Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            synchronized (toolkit) {
                container.add(string, component);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSynchronized(Container container, Component component) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            synchronized (toolkit) {
                container.remove(component);
            }
        }
    }

    public boolean isGuiModeNorthPaneLess() {
        return (this._guiMode & 1) != 0;
    }
}

