/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.delegates;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import oracle.ewt.lwAWT.LWComponent;
import oracle.forms.handler.TListItem;
import oracle.forms.properties.ID;
import oracle.forms.properties.PropertyInfo;
import oracle.forms.properties.PropertyMask;
import oracle.forms.ui.FormsToolTip;
import oracle.forms.ui.VTList;
import oracle.forms.ui.delegates.VComponentDelegate;

public class VTListDelegate
extends VComponentDelegate
implements MouseListener {
    private static PropertyInfo[] mNewProperties = new PropertyInfo[]{new PropertyInfo("COUNT", Integer.class, PropertyMask.GETTABLE), new PropertyInfo("DESELECT", Integer.class, PropertyMask.SETTABLE), new PropertyInfo("MAKEVISIBLE", Integer.class, PropertyMask.SETTABLE), new PropertyInfo("SELECT", Integer.class, PropertyMask.SETTABLE), new PropertyInfo("SELECTEDINDEX", Integer.class, PropertyMask.GETTABLE)};
    private static String[] mNewListeners = new String[]{"java.awt.event.ActionListener", "java.awt.event.ItemListener"};
    private MouseListener mMouseListener;

    public VTListDelegate(VTList vTList) {
        super(vTList);
    }

    public final VTList getVTList() {
        return (VTList)this.getComponent();
    }

    @Override
    public Object getProperty(ID iD) {
        switch (iD.toID()) {
            case 333: {
                return this.getVTList().getItemCount();
            }
            case 334: {
                return this.getVTList().getSelectedIndex();
            }
            case 511: {
                return VTListDelegate.concatenate((Object[])super.getProperty(ID.ALL_PROPERTIES), mNewProperties);
            }
            case 512: {
                return VTListDelegate.concatenate((Object[])super.getProperty(ID.ALL_LISTENERS), mNewListeners);
            }
        }
        return super.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        switch (iD.toID()) {
            case 335: {
                this.getVTList().select((Integer)object);
                break;
            }
            case 336: {
                this.getVTList().deselect((Integer)object);
                break;
            }
            case 337: {
                this.getVTList().makeVisible((Integer)object);
                break;
            }
            case 410: {
                int n = ((LWComponent)this.getComponent()).getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component component = ((LWComponent)this.getComponent()).getComponent(i);
                    if (component == null) continue;
                    ((LWComponent)component).setToolTipValue((FormsToolTip)object);
                    int n2 = ((LWComponent)component).getComponentCount();
                    for (int j = 0; j < n2; ++j) {
                        Component component2 = ((LWComponent)component).getComponent(i);
                        if (component2 == null) continue;
                        ((LWComponent)component2).setToolTipValue((FormsToolTip)object);
                    }
                }
                bl = super.setProperty(iD, object);
                break;
            }
            default: {
                bl = super.setProperty(iD, object);
            }
        }
        return bl;
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        if (clazz == ActionListener.class) {
            this.getVTList().addActionListener((ActionListener)eventListener);
            return;
        }
        if (clazz == ItemListener.class) {
            this.getVTList().addItemListener((ItemListener)eventListener);
            return;
        }
        if (clazz == MouseListener.class) {
            this.mMouseListener = (MouseListener)eventListener;
            this.addMListener(this.getComponent());
        }
        super.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        if (clazz == ActionListener.class) {
            this.getVTList().removeActionListener((ActionListener)eventListener);
            return;
        }
        if (clazz == ItemListener.class) {
            this.getVTList().removeItemListener((ItemListener)eventListener);
            return;
        }
        if (clazz == MouseListener.class) {
            this.mMouseListener = null;
            this.delMListener(this.getComponent());
        }
        super.removeListener(clazz, eventListener);
    }

    private void addMListener(Component component) {
        int n = ((LWComponent)component).getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = ((LWComponent)component).getComponent(i);
            if (component2 == null) continue;
            component2.addMouseListener(this);
            this.addMListener(component2);
        }
    }

    private void delMListener(Component component) {
        int n = ((LWComponent)component).getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component2 = ((LWComponent)component).getComponent(i);
            if (component2 == null) continue;
            component2.removeMouseListener(this);
            this.delMListener(component2);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mMouseListener != null) {
            int n = 0;
            int n2 = 0;
            for (Component component = mouseEvent.getComponent(); component != this.getComponent() && component != null; component = component.getParent()) {
                Point point = component.getLocation();
                n += point.x;
                n2 += point.y;
            }
            mouseEvent.translatePoint(n, n2);
            this.mMouseListener.mousePressed(mouseEvent);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mMouseListener != null) {
            int n = 0;
            int n2 = 0;
            for (Component component = mouseEvent.getComponent(); component != this.getComponent() && component != null; component = component.getParent()) {
                Point point = component.getLocation();
                n += point.x;
                n2 += point.y;
            }
            mouseEvent.translatePoint(n, n2);
            this.mMouseListener.mouseReleased(mouseEvent);
            mouseEvent.translatePoint(-n, -n2);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            ((TListItem)this.mHandler).mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            ((TListItem)this.mHandler).mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

