/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.delegates;

import java.awt.Component;
import java.util.EventListener;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.thread.Task;
import oracle.ewt.thread.TaskEvent;
import oracle.ewt.thread.TaskScheduler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.properties.PropertyInfo;
import oracle.forms.properties.PropertyMask;
import oracle.forms.ui.FormsBoundedRange;
import oracle.forms.ui.FormsGaugePainter;
import oracle.forms.ui.FormsProgressPainter;
import oracle.forms.ui.VGauge;
import oracle.forms.ui.VProgress;
import oracle.forms.ui.delegates.VComponentDelegate;

public class VProgressDelegate
extends VComponentDelegate {
    private BorderBevel mBorderBevel;
    private VGauge mGauge = null;
    private VProgress mProgress = null;
    private Byte mStyle = 1;
    private int mMin = 0;
    private int mMax = 0;
    private boolean mAnimated = false;
    private boolean mVertical = false;
    private static PropertyInfo[] mNewProperties = new PropertyInfo[]{new PropertyInfo("BORDER_BEVEL", BorderBevel.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("CAN_TAKE_FOCUS", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("VALUE", String.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("RANGE_UIMIN", Integer.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("RANGE_UIMAX", Integer.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("DISP_PERCENTAGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("PARTIAL_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("COLOR_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("METER_STYLE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("ROLLOVER_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("SB_HORIZONTAL", Boolean.class, PropertyMask.SETTABLE), new PropertyInfo("SWAP_COLORS", Boolean.class, PropertyMask.SETTABLE)};
    private static String[] mNewListeners = new String[0];
    static TaskScheduler sTaskScheduler = TaskScheduler.getDefaultTaskScheduler();
    private transient GaugeAnimator mAnimator;

    public VProgressDelegate(VProgress vProgress) {
        super(vProgress);
        this.mProgress = vProgress;
        this.mGauge = null;
    }

    public VProgressDelegate(VGauge vGauge) {
        super(vGauge);
        this.mGauge = vGauge;
        this.mProgress = null;
    }

    public final Component getVComponent() {
        if (this.mGauge != null) {
            return this.mGauge;
        }
        return this.mProgress;
    }

    public BoundedRangeModel getComponentModel() {
        if (this.mGauge != null) {
            return this.mGauge.getModel();
        }
        return this.mProgress.getModel();
    }

    public void setComponentModel(BoundedRangeModelImpl boundedRangeModelImpl) {
        if (this.mGauge != null) {
            this.mGauge.setModel(boundedRangeModelImpl);
        } else {
            this.mProgress.setModel(boundedRangeModelImpl);
        }
    }

    @Override
    public Object getProperty(ID iD) {
        switch (iD.toID()) {
            case 152: {
                return this.mBorderBevel;
            }
            case 589: {
                return this.mStyle;
            }
            case 131: {
                return this.getComponentModel().getValue();
            }
            case 202: {
                return VProgressDelegate.toBoolean(!this.getVComponent().isFocusable());
            }
            case 591: {
                return this.getComponentModel().getMinimum();
            }
            case 592: {
                return this.getComponentModel().getMaximum();
            }
            case 590: {
                return ((FormsBoundedRange)this.getComponentModel()).getDispPercentage();
            }
            case 511: {
                return VProgressDelegate.concatenate((Object[])super.getProperty(ID.ALL_PROPERTIES), mNewProperties);
            }
            case 512: {
                return VProgressDelegate.concatenate((Object[])super.getProperty(ID.ALL_LISTENERS), mNewListeners);
            }
        }
        return super.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        switch (iD.toID()) {
            case 152: {
                this.mBorderBevel = (BorderBevel)object;
                return true;
            }
            case 594: {
                this.mAnimated = (Integer)object != 0;
                return true;
            }
            case 131: {
                if (this.mAnimated) {
                    if (this.mAnimator == null) {
                        this.mAnimator = new GaugeAnimator();
                    } else {
                        this.mAnimator.cancel();
                    }
                    this.mAnimator.initValues(object);
                    this.mAnimator.start();
                    return true;
                }
                try {
                    Float f = Float.valueOf((String)object);
                    this.getComponentModel().setValue(Math.round(f.floatValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    this.getComponentModel().setValue(0);
                }
                break;
            }
            case 202: {
                this.getVComponent().setFocusable(!VProgressDelegate.toBoolean(object));
                return true;
            }
            case 589: {
                this.mStyle = (Byte)object;
                if (this.mGauge == null) {
                    return true;
                }
                if ((Byte)object == 2) {
                    this.mGauge.setPainter(FormsGaugePainter.getPainter(false, false));
                } else if ((Byte)object == 3) {
                    this.mGauge.setPainter(FormsGaugePainter.getPainter(true, false));
                }
                return true;
            }
            case 591: {
                if (this.mAnimator != null) {
                    this.mAnimator.cancel();
                }
                this.mMin = (Integer)object;
                break;
            }
            case 592: {
                int n = this.getComponentModel().getValue();
                boolean bl2 = ((FormsBoundedRange)this.getComponentModel()).getDispPercentage();
                this.mMax = (Integer)object;
                this.setComponentModel(new FormsBoundedRange(this.mMin, this.mMax, n));
                ((FormsBoundedRange)this.getComponentModel()).setDispPercentage(bl2);
                break;
            }
            case 590: {
                ((FormsBoundedRange)this.getComponentModel()).setDispPercentage(VProgressDelegate.toBoolean(object));
                break;
            }
            case 254: {
                if (VProgressDelegate.toBoolean(object) || this.mProgress == null) break;
                this.mVertical = true;
                int n = ((UICommon)this.mHandler).getDispatcher().getDarkLuminance();
                this.mProgress.setPainter(FormsProgressPainter.getPainter(true, false, n));
                break;
            }
            case 572: {
                if (VProgressDelegate.toBoolean(object) && this.mProgress != null) {
                    int n = ((UICommon)this.mHandler).getDispatcher().getDarkLuminance();
                    this.mProgress.setPainter(FormsProgressPainter.getPainter(this.mVertical, true, n));
                    break;
                }
                if (!VProgressDelegate.toBoolean(object) || this.mGauge == null) break;
                this.mGauge.setPainter(FormsGaugePainter.getPainter(this.mStyle == 3, true));
                break;
            }
            default: {
                bl = super.setProperty(iD, object);
            }
        }
        return bl;
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        super.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        super.removeListener(clazz, eventListener);
    }

    private class GaugeAnimator
    implements Task {
        public int mTarget = 0;
        public int mDelta = 0;

        private GaugeAnimator() {
        }

        public void initValues(Object object) {
            int n;
            try {
                Float f = Float.valueOf((String)object);
                this.mTarget = Math.round(f.floatValue());
            }
            catch (NumberFormatException numberFormatException) {
                this.mTarget = 0;
            }
            this.mDelta = (int)Math.round((double)(VProgressDelegate.this.mMax - VProgressDelegate.this.mMin) * 0.02);
            if (this.mDelta == 0) {
                this.mDelta = 1;
            }
            if (this.mTarget < (n = VProgressDelegate.this.getComponentModel().getValue())) {
                this.mDelta *= -1;
            }
        }

        @Override
        public void runTask(TaskEvent taskEvent) {
            int n = VProgressDelegate.this.getComponentModel().getValue();
            if (n == this.mTarget) {
                return;
            }
            if (this.mDelta > 0 && n == VProgressDelegate.this.mMax || this.mDelta < 0 && n == VProgressDelegate.this.mMin) {
                return;
            }
            int n2 = n + this.mDelta;
            if (this.mDelta > 0 && n2 > this.mTarget || this.mDelta < 0 && n2 < this.mTarget) {
                n2 = this.mTarget;
            }
            VProgressDelegate.this.getComponentModel().setValue(n2);
            if (n2 == this.mTarget) {
                return;
            }
            sTaskScheduler.schedule(this, 10);
        }

        public void start() {
            sTaskScheduler.schedule(this, 1);
        }

        public void cancel() {
            sTaskScheduler.cancel(this);
        }
    }
}

