/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.delegates;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import oracle.ewt.EwtComponent;
import oracle.ewt.imageCanvas.ScalingImageCanvas;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.properties.ImageScrollPolicy;
import oracle.forms.properties.PropertyInfo;
import oracle.forms.properties.PropertyMask;
import oracle.forms.ui.VImage;
import oracle.forms.ui.delegates.VComponentDelegate;

public class VImageDelegate
extends VComponentDelegate {
    private static PropertyInfo[] mNewProperties = new PropertyInfo[]{new PropertyInfo("BORDER_BEVEL", BorderBevel.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("CANVAS_ORIGIN", Point.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("SCALE", Integer.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("SCROLL_STYLE", ImageScrollPolicy.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("SCROLL_POSITION", Point.class, PropertyMask.GETTABLE), new PropertyInfo("VALUE", Image.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("VIEWPORT_SIZE", Dimension.class, PropertyMask.GETTABLE), new PropertyInfo("PARTIAL_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("COLOR_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("ROLLOVER_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE))};
    private static String[] mNewListeners = new String[0];
    private ImageScrollPolicy mScrollPolicy = ImageScrollPolicy.NONE;
    private Image mImage = null;
    private boolean mImageSentToVImage = false;
    private double mScaleX = 1.0;
    private double mScaleY = 1.0;
    private double mSmoothScalingMaxZoom = 0.0;
    private boolean mImageScaleIsPercent = false;
    private BorderBevel mBorderBevel;

    public VImageDelegate(VImage vImage) {
        super(vImage);
    }

    @Override
    public void init(IHandler iHandler) {
        super.init(iHandler);
        this.mSmoothScalingMaxZoom = this.getApplet().getSmoothScalingMaxZoom();
        this.mImageScaleIsPercent = this.getApplet().isImageScaleIsPercent();
    }

    public final ScalingImageCanvas getImageCanvas() {
        return (ScalingImageCanvas)((ScrollBox)this.getComponent()).getContent();
    }

    public final VImage getVImage() {
        return (VImage)this.getComponent();
    }

    @Override
    public Object getProperty(ID iD) {
        switch (iD.toID()) {
            case 152: {
                return this.mBorderBevel;
            }
            case 139: {
                return this.getImageCanvas().getCanvasOrigin();
            }
            case 386: {
                if (!this.mImageScaleIsPercent) {
                    return (int)(this.mScaleX * 524288.0 + 0.5);
                }
                return (int)(this.mScaleX * 100.0 + 0.5);
            }
            case 387: {
                return this.mScrollPolicy;
            }
            case 131: {
                return this.mImage;
            }
            case 396: {
                return this.getVImage().getViewPortSize();
            }
            case 395: {
                return this.getVImage().getScrollPosition();
            }
            case 511: {
                return VImageDelegate.concatenate((Object[])super.getProperty(ID.ALL_PROPERTIES), mNewProperties);
            }
            case 512: {
                return VImageDelegate.concatenate((Object[])super.getProperty(ID.ALL_LISTENERS), mNewListeners);
            }
        }
        return super.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = true;
        VImage vImage = this.getVImage();
        switch (iD.toID()) {
            case 152: {
                this.setBorderBevel(vImage, object);
                return true;
            }
            case 387: {
                this.mScrollPolicy = (ImageScrollPolicy)object;
                this.setScrollPolicy(this.mScrollPolicy);
                break;
            }
            case 139: {
                vImage.setCanvasOrigin(((Point)object).x, ((Point)object).y);
                break;
            }
            case 131: {
                this.mImage = (Image)object;
                this.mImageSentToVImage = false;
                break;
            }
            case 386: {
                long l = (long)((Integer)object).intValue() & 0xFFFFFFFFL;
                vImage.validate();
                if (l > 1L) {
                    this.mScaleX = !this.mImageScaleIsPercent ? (this.mScaleY = (double)l / 524288.0) : (this.mScaleY = (double)l / 100.0);
                } else if (this.mImage == null) {
                    this.mScaleY = 1.0;
                    this.mScaleX = 1.0;
                } else {
                    this.adjustToFit(l == 0L);
                }
                if (this.mImage == null || this.mScaleX == 1.0 && this.mScaleY == 1.0 || this.mScaleX > this.mSmoothScalingMaxZoom || this.mScaleY > this.mSmoothScalingMaxZoom) {
                    if (!this.mImageSentToVImage) {
                        vImage.setImage(this.mImage);
                        this.mImageSentToVImage = true;
                    }
                    vImage.setScale(this.mScaleX, this.mScaleY);
                    break;
                }
                vImage.setScale(1.0, 1.0);
                vImage.setImage(this.getScaledInstance());
                this.mImageSentToVImage = false;
                break;
            }
            case 576: {
                this.mColorEdge = VImageDelegate.toBoolean(object);
                this.setBorderBevel(vImage, this.mBorderBevel);
                return true;
            }
            case 578: {
                this.mRolloverEdge = VImageDelegate.toBoolean(object);
                return true;
            }
            case 577: {
                this.mPartialEdge = VImageDelegate.toBoolean(object);
                this.setBorderBevel(vImage, this.mBorderBevel);
                return true;
            }
            default: {
                bl = super.setProperty(iD, object);
            }
        }
        return bl;
    }

    private Image getScaledInstance() {
        int n = this.mImage.getWidth(this.getImageCanvas());
        int n2 = this.mImage.getHeight(this.getImageCanvas());
        n = (int)(this.mScaleX * (double)n + 0.5);
        n2 = (int)(this.mScaleY * (double)n2 + 0.5);
        if (n == 0 || n2 == 0) {
            return null;
        }
        return this.mImage.getScaledInstance(n, n2, 4);
    }

    private void setScrollPolicy(ImageScrollPolicy imageScrollPolicy) {
        int n = 2;
        int n2 = 2;
        switch (imageScrollPolicy.toID()) {
            case 1: {
                n = 1;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 3: {
                n = 1;
                n2 = 1;
                break;
            }
        }
        this.getVImage().setHDisplayPolicy(n);
        this.getVImage().setVDisplayPolicy(n2);
    }

    public void setBorderBevel(EwtComponent ewtComponent, Object object) {
        this.mBorderBevel = (BorderBevel)object;
        BorderPainter borderPainter = sBorder[this.mBorderBevel.toID()];
        if (this.mPartialEdge && this.mColorEdge) {
            borderPainter = sBorder[6];
        } else if (this.mPartialEdge) {
            borderPainter = sBorder[5];
        } else if (this.mColorEdge) {
            borderPainter = sBorder[4];
        }
        ewtComponent.setBorderPainter(borderPainter);
    }

    private void adjustToFit(boolean bl) {
        int n = this.mImage.getWidth(this.getImageCanvas());
        int n2 = this.mImage.getHeight(this.getImageCanvas());
        Dimension dimension = this.getImageCanvas().getInnerSize();
        int n3 = dimension.width;
        int n4 = dimension.height;
        this.mScaleX = (double)n3 / (double)n;
        this.mScaleY = (double)n4 / (double)n2;
        if (bl) {
            if (this.mScaleX > this.mScaleY) {
                this.mScaleX = this.mScaleY;
            } else {
                this.mScaleY = this.mScaleX;
            }
        }
    }
}

