/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.delegates;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import java.util.Locale;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIManager;
import oracle.ewt.alert.AlertPane;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwWindow.LWWindow;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.FixedImagePainter;
import oracle.ewt.painter.NullPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.painter.PainterTiler;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.ClipboardProxy;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.ewt.util.stringFilter.IdentityStringFilter;
import oracle.ewt.util.stringFilter.LowerCaseFilter;
import oracle.ewt.util.stringFilter.StringFilter;
import oracle.ewt.util.stringFilter.UpperCaseFilter;
import oracle.forms.engine.Main;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.properties.LanguageDirection;
import oracle.forms.properties.Property;
import oracle.forms.properties.PropertyInfo;
import oracle.forms.properties.PropertyMask;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.BeanManager;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.FormsToolTip;
import oracle.forms.ui.GenericBorderPainter;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.IView;
import oracle.forms.ui.OracleBorderPainter;
import oracle.forms.ui.VCheckbox;
import oracle.forms.ui.VTextField;

public class VComponentDelegate
implements ICustomView {
    private static PropertyInfo[] mNewProperties = new PropertyInfo[]{new PropertyInfo("BACKGROUND", Color.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("BGPATTERN", Image.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("BOUNDS", Rectangle.class, PropertyMask.GETTABLE), new PropertyInfo("ENABLED", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("FOCUS", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("FONT", Font.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("FOREGROUND", Color.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("LANGUAGE_DIRECTION", LanguageDirection.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("LOCATION", Point.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("MNEMONIC", Character.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("SIZE", Point.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("VISIBLE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("UI_PARENT", Container.class, PropertyMask.GETTABLE), new PropertyInfo("PARTIAL_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("COLOR_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("ROLLOVER_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE))};
    private static String[] mNewListeners = new String[]{"java.awt.event.KeyListener", "java.awt.event.FocusListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener"};
    protected static final int STYLE_DEFAULT = 0;
    protected static final int STYLE_GRAY = 1;
    protected static final int STYLE_AUTOMATIC = 2;
    private static boolean sInitialized = false;
    protected static int sBackgroundStyle = 0;
    private static boolean sOracleLookAndFeel = false;
    private static boolean sDisableValidateClipBoard = false;
    private static LanguageDirection sDefaultDirection;
    private static boolean sAllowAlertDialog;
    private Component mComponent;
    private LWWindow mDialog;
    private AlertPane mAlert;
    private LanguageDirection mDirection = sDefaultDirection;
    protected Image mBGPattern = null;
    private Main mApplet;
    private MessageGenerator mEMG;
    private MessageGenerator mTPG;
    protected Painter mGrayFill;
    protected Painter mDefaultFill;
    protected Painter mCurrentFill;
    protected Painter mImageFill;
    protected boolean mColorEdge = false;
    protected boolean mRolloverEdge = false;
    protected boolean mPartialEdge = false;
    private Boolean mDirectionSet = Boolean.FALSE;
    private BeanManager mManager;
    protected IHandler mHandler;
    protected static BorderPainter[] sBorder;
    protected static final StringFilter[] sFilter;
    private static Integer[] sSmallInts;

    public VComponentDelegate(Component component) {
        this.mComponent = component;
    }

    public final Component getComponent() {
        return this.mComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mApplet = iHandler.getApplet();
        this.mEMG = this.mApplet.getErrorMessageGenerator();
        this.mTPG = this.mApplet.getTranslatedPhraseGenerator();
        Object object = VComponentDelegate.class;
        synchronized (VComponentDelegate.class) {
            if (!sInitialized) {
                String string;
                String string2;
                String string3;
                sInitialized = true;
                String string4 = iHandler.getParameter("readOnlyBackground");
                if (string4 != null) {
                    if (string4.equalsIgnoreCase("true")) {
                        sBackgroundStyle = 1;
                    } else if (string4.equalsIgnoreCase("automatic")) {
                        sBackgroundStyle = 2;
                    }
                }
                if ((string3 = iHandler.getParameter("lookAndFeel")) != null && string3.equalsIgnoreCase("Oracle")) {
                    sOracleLookAndFeel = true;
                }
                if ((string2 = iHandler.getParameter("disableValidateClipboard")) != null && string2.equalsIgnoreCase("true")) {
                    sDisableValidateClipBoard = true;
                }
                if ((string = iHandler.getParameter("allowAlertClipboard")) != null && string.equalsIgnoreCase("true")) {
                    sAllowAlertDialog = true;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.mComponent instanceof LWComponent) {
                object = (LWComponent)this.mComponent;
                this.mGrayFill = this.getGrayFill();
                this.mDefaultFill = this.getDefaultFill();
                this.mCurrentFill = sBackgroundStyle != 0 ? this.mGrayFill : this.mDefaultFill;
                ((LWComponent)object).setFill(this.mCurrentFill);
            }
            if (sBorder == null) {
                sBorder = new BorderPainter[7];
                VComponentDelegate.sBorder[0] = NullPainter.getPainter();
                if (this.isOracleLookAndFeel()) {
                    VComponentDelegate.sBorder[1] = new OracleBorderPainter(1);
                    VComponentDelegate.sBorder[2] = new OracleBorderPainter(2);
                    VComponentDelegate.sBorder[3] = new OracleBorderPainter(3);
                    VComponentDelegate.sBorder[4] = this.mHandler instanceof UICommon ? new OracleBorderPainter(3, ((UICommon)this.mHandler).getDispatcher().getBorderColor(), true, true, true, true) : new OracleBorderPainter(3);
                    VComponentDelegate.sBorder[5] = new OracleBorderPainter(3, this.mApplet.getDrawLeftBorder(), this.mApplet.getDrawRightBorder(), this.mApplet.getDrawTopBorder(), this.mApplet.getDrawBottomBorder());
                    VComponentDelegate.sBorder[6] = this.mHandler instanceof UICommon ? new OracleBorderPainter(3, ((UICommon)this.mHandler).getDispatcher().getBorderColor(), this.mApplet.getDrawLeftBorder(), this.mApplet.getDrawRightBorder(), this.mApplet.getDrawTopBorder(), this.mApplet.getDrawBottomBorder()) : new OracleBorderPainter(3);
                } else {
                    VComponentDelegate.sBorder[1] = new GenericBorderPainter(1);
                    VComponentDelegate.sBorder[2] = new GenericBorderPainter(2);
                    VComponentDelegate.sBorder[3] = new GenericBorderPainter(3);
                    VComponentDelegate.sBorder[4] = new GenericBorderPainter(3);
                    VComponentDelegate.sBorder[5] = new GenericBorderPainter(3);
                    VComponentDelegate.sBorder[6] = new GenericBorderPainter(3);
                }
            }
            return;
        }
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.getComponent().contains(n, n2);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        Component component = this.getComponent();
        Object var3_3 = null;
        switch (iD.toID()) {
            case 147: {
                return component.getBackground();
            }
            case 148: {
                return this.mBGPattern;
            }
            case 146: {
                return component.getForeground();
            }
            case 153: {
                return component.getBounds();
            }
            case 144: {
                return component.isEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 165: {
                return this.mDirection;
            }
            case 135: {
                return component.getLocation();
            }
            case 140: {
                return Character.valueOf(((LWComponent)component).getMnemonicChar());
            }
            case 126: {
                return component.getSize();
            }
            case 173: {
                return component.isVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 134: {
                return component.getParent();
            }
            case 511: {
                return mNewProperties;
            }
            case 512: {
                return mNewListeners;
            }
            case 576: {
                return VComponentDelegate.toBoolean(this.mColorEdge);
            }
            case 578: {
                return VComponentDelegate.toBoolean(this.mRolloverEdge);
            }
            case 577: {
                return VComponentDelegate.toBoolean(this.mPartialEdge);
            }
        }
        return Property.UNKNOWN;
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        Component component = this.getComponent();
        switch (iD.toID()) {
            case 148: {
                this.mBGPattern = (Image)object;
                if (component instanceof LWComponent) {
                    LWComponent lWComponent = (LWComponent)component;
                    if (object != null) {
                        this.mImageFill = new PainterTiler(new FixedImagePainter((Image)object));
                        lWComponent.setFill(this.mImageFill);
                    } else {
                        this.mImageFill = null;
                        if (((UICommon)this.mHandler).isGlassBackground()) {
                            lWComponent.setFill(NullPainter.getPainter());
                        } else {
                            lWComponent.setFill(this.mCurrentFill);
                        }
                    }
                }
                return true;
            }
            case 147: {
                Color color = (Color)object;
                if (this.mImageFill == null && sBackgroundStyle == 2 && component instanceof LWComponent) {
                    LWComponent lWComponent = (LWComponent)this.mComponent;
                    Painter painter = this.mCurrentFill = color == IView.DEFAULT_COLOR ? this.mGrayFill : this.mDefaultFill;
                    if (((UICommon)this.mHandler).isGlassBackground()) {
                        lWComponent.setFill(NullPainter.getPainter());
                    } else {
                        lWComponent.setFill(this.mCurrentFill);
                    }
                }
                component.setBackground(color);
                return true;
            }
            case 144: {
                component.setEnabled(VComponentDelegate.toBoolean(object));
                return true;
            }
            case 174: {
                if (object == Boolean.TRUE) {
                    if (this.mHandler instanceof UICommon) {
                        ((UICommon)this.mHandler).clearDeferredItem();
                    }
                    if (component instanceof VTextField || component instanceof VCheckbox) {
                        UICommon uICommon;
                        LWWindow lWWindow;
                        if (!component.requestFocusInWindow() && this.mHandler instanceof UICommon && (lWWindow = (uICommon = (UICommon)this.mHandler).getParentWindow()) != null) {
                            UICommon.deferRequestFocus(lWWindow, uICommon);
                        }
                    } else {
                        component.requestFocus();
                    }
                }
                return true;
            }
            case 149: {
                component.setFont((Font)object);
                return true;
            }
            case 146: {
                Color color = (Color)object;
                component.setForeground(color);
                return true;
            }
            case 165: {
                this.setDirection((LanguageDirection)object);
                this.setProperty(ID.ALIGNMENT, this.getProperty(ID.ALIGNMENT));
                return true;
            }
            case 135: {
                component.setLocation((Point)object);
                return true;
            }
            case 140: 
            case 551: {
                char c = ((Character)object).charValue();
                ((LWComponent)component).setMnemonicChar(c);
                return true;
            }
            case 126: {
                Point point = (Point)object;
                component.setSize(point.x, point.y);
                return true;
            }
            case 173: {
                component.setVisible(VComponentDelegate.toBoolean(object));
                return true;
            }
            case 576: {
                this.mColorEdge = VComponentDelegate.toBoolean(object);
                return true;
            }
            case 578: {
                this.mRolloverEdge = VComponentDelegate.toBoolean(object);
                return true;
            }
            case 577: {
                this.mPartialEdge = VComponentDelegate.toBoolean(object);
                return true;
            }
            case 410: {
                if (component instanceof ScrollBox) {
                    component = ((ScrollBox)component).getContent();
                }
                ((LWComponent)component).setToolTipValue((FormsToolTip)object);
                return true;
            }
        }
        return false;
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        Component component = this.getComponent();
        if (clazz == KeyListener.class) {
            component.addKeyListener((KeyListener)eventListener);
        } else if (clazz == FocusListener.class) {
            component.addFocusListener((FocusListener)eventListener);
        } else if (clazz == MouseListener.class) {
            component.addMouseListener((MouseListener)eventListener);
        } else if (clazz == MouseMotionListener.class) {
            component.addMouseMotionListener((MouseMotionListener)eventListener);
        } else if (clazz == CustomListener.class) {
            this.getBeanManager().addCustomListener((CustomListener)eventListener);
        }
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        Component component = this.getComponent();
        if (clazz == KeyListener.class) {
            component.removeKeyListener((KeyListener)eventListener);
        } else if (clazz == FocusListener.class) {
            component.removeFocusListener((FocusListener)eventListener);
        } else if (clazz == MouseListener.class) {
            component.removeMouseListener((MouseListener)eventListener);
        } else if (clazz == MouseMotionListener.class) {
            component.removeMouseMotionListener((MouseMotionListener)eventListener);
        } else if (clazz == CustomListener.class && this.mManager != null) {
            this.getBeanManager().removeCustomListener((CustomListener)eventListener);
        }
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.getBeanManager().dispatchCustomEvent(customEvent);
    }

    public BeanManager getBeanManager() {
        if (this.mManager == null) {
            this.mManager = new BeanManager();
            this.mManager.setHandler(this.mHandler);
            this.mManager.addCustomListener((CustomListener)((Object)this.mHandler));
        }
        return this.mManager;
    }

    @Override
    public void paint(Graphics graphics) {
        this.getComponent().paint(graphics);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        if (rectangle == null) {
            this.getComponent().repaint();
        } else {
            this.getComponent().repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    public Boolean handleOKToPaste(LWCommonText lWCommonText) {
        Clipboard clipboard = ClipboardProxy.getSystemClipboard();
        try {
            Transferable transferable;
            if (!sDisableValidateClipBoard ? (transferable = clipboard.getContents(lWCommonText)) != null && lWCommonText.isOKToPaste(transferable) && lWCommonText.isEditable() : lWCommonText.isEditable()) {
                return Boolean.TRUE;
            }
        }
        catch (IllegalStateException illegalStateException) {
            ClipboardErrorUtils.displayMessage(this.mEMG, this.mTPG, lWCommonText.getParent(), sAllowAlertDialog);
        }
        return Boolean.FALSE;
    }

    public static final StringFilter[] getCaseFilters() {
        return sFilter;
    }

    public static final BorderPainter[] getBorders() {
        return sBorder;
    }

    public static Object[] concatenate(Object[] objectArray, Object[] objectArray2) {
        int n = 0;
        int n2 = 0;
        if (objectArray != null) {
            n2 += objectArray.length;
        }
        if (objectArray2 != null) {
            n2 += objectArray2.length;
        }
        Object[] objectArray3 = new Object[n2];
        if (objectArray != null) {
            for (n = 0; n < objectArray.length; ++n) {
                objectArray3[n] = objectArray[n];
            }
        }
        if (objectArray2 != null) {
            for (int i = 0; i < objectArray2.length; ++i) {
                objectArray3[n++] = objectArray2[i];
            }
        }
        return objectArray3;
    }

    protected String processLabel(String string) {
        String string2 = string == null || string.equals("") ? " " : string;
        int n = StringUtils.getMnemonicIndex(string2);
        if (n != -1 && this.getComponent() instanceof LWComponent) {
            ((LWComponent)this.getComponent()).setMnemonicIndex(n);
        }
        return StringUtils.stripMnemonic(string2);
    }

    protected static final Boolean toBoolean(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    protected static final boolean toBoolean(Object object) {
        return (Boolean)object;
    }

    protected static final int toByte(Object object) {
        return ((Byte)object).byteValue();
    }

    protected static final int toInt(Object object) {
        return (Integer)object;
    }

    protected static final Integer toInt(int n) {
        return n < sSmallInts.length ? sSmallInts[n] : Integer.valueOf(n);
    }

    protected void setDirection(LanguageDirection languageDirection) {
        if (this.mDirectionSet == Boolean.TRUE && languageDirection == this.mDirection) {
            return;
        }
        this.mDirection = languageDirection;
        this.mDirectionSet = Boolean.TRUE;
        Component component = this.getComponent();
        if (component instanceof LWComponent) {
            int n = 0;
            if (languageDirection == LanguageDirection.RIGHT_TO_LEFT) {
                n = 2;
            } else if (languageDirection == LanguageDirection.LEFT_TO_RIGHT) {
                n = 1;
            }
            ((LWComponent)component).setReadingDirection(n);
        }
    }

    protected Main getApplet() {
        return this.mApplet;
    }

    protected LanguageDirection getDirection() {
        return this.mDirection;
    }

    protected boolean isOracleLookAndFeel() {
        return sOracleLookAndFeel;
    }

    protected Painter getDefaultFill() {
        return UIManager.getPainter(LookAndFeel.BACKGROUND_PAINTER);
    }

    protected Painter getGrayFill() {
        return ((LWComponent)this.mComponent).getFill();
    }

    static {
        sAllowAlertDialog = false;
        sBorder = null;
        sFilter = new StringFilter[]{null, UpperCaseFilter.getStringFilter(), LowerCaseFilter.getStringFilter(), IdentityStringFilter.getStringFilter()};
        switch (LocaleUtils.getReadingDirectionForLocale(Locale.getDefault())) {
            case 2: {
                sDefaultDirection = LanguageDirection.RIGHT_TO_LEFT;
                break;
            }
            case 1: {
                sDefaultDirection = LanguageDirection.LEFT_TO_RIGHT;
                break;
            }
            default: {
                sDefaultDirection = LanguageDirection.DEFAULT;
            }
        }
        sSmallInts = new Integer[]{0, 1, 2};
    }
}

