/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui.delegates;

import java.awt.Point;
import java.awt.event.TextListener;
import java.util.EventListener;
import oracle.ewt.EwtComponent;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWCommonText;
import oracle.ewt.lwAWT.lwText.SelectionListener;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.LocaleUtils;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.Alignment;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.CaseRestriction;
import oracle.forms.properties.ID;
import oracle.forms.properties.LanguageDirection;
import oracle.forms.properties.PropertyInfo;
import oracle.forms.properties.PropertyMask;
import oracle.forms.ui.delegates.VComponentDelegate;

public class VCommonTextDelegate
extends VComponentDelegate {
    private static PropertyInfo[] mNewProperties = new PropertyInfo[]{new PropertyInfo("ALIGNMENT", Alignment.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("BORDER_BEVEL", BorderBevel.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("CASE_FOLD", CaseRestriction.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("CURSOR_POSITION", Integer.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("CAN_TAKE_FOCUS", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("EDITABLE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("MAX_LENGTH", Integer.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("OK_TO_PASTE", Boolean.class, PropertyMask.GETTABLE), new PropertyInfo("SELECTION", Point.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("VALUE", String.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("PARTIAL_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("COLOR_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE)), new PropertyInfo("ROLLOVER_EDGE", Boolean.class, PropertyMask.addMasks(PropertyMask.GETTABLE, PropertyMask.SETTABLE))};
    private static String[] mNewListeners = new String[]{"java.awt.event.TextListener"};
    private static final int[] sAlignment = new int[]{3, 1, 2, 0};
    private Alignment mAlignment;
    private BorderBevel mBorderBevel;
    private CaseRestriction mCaseRestriction;
    private LWCommonText mCommonText;

    public VCommonTextDelegate(LWComponent lWComponent) {
        super(lWComponent);
        this.mCommonText = (LWCommonText)(lWComponent instanceof LWCommonText ? lWComponent : ((ScrollBox)lWComponent).getContent());
        this.mCommonText.setBorderPainter(null);
        this.setProperty(ID.ALIGNMENT, Alignment.START);
    }

    public LWCommonText getLWCommonText() {
        return this.mCommonText;
    }

    @Override
    public void init(IHandler iHandler) {
        super.init(iHandler);
    }

    @Override
    public Object getProperty(ID iD) {
        LWCommonText lWCommonText = this.getLWCommonText();
        switch (iD.toID()) {
            case 115: {
                return this.mAlignment;
            }
            case 152: {
                return this.mBorderBevel;
            }
            case 199: {
                return this.mCaseRestriction;
            }
            case 202: {
                return VCommonTextDelegate.toBoolean(!lWCommonText.isFocusable());
            }
            case 193: {
                return VCommonTextDelegate.toInt(lWCommonText.getCaretPosition());
            }
            case 194: {
                return VCommonTextDelegate.toBoolean(lWCommonText.isEditable());
            }
            case 117: {
                return VCommonTextDelegate.toInt(lWCommonText.getMaximumChars());
            }
            case 531: {
                return this.handleOKToPaste(lWCommonText);
            }
            case 195: {
                return new Point(lWCommonText.getSelectionStart(), lWCommonText.getSelectionEnd());
            }
            case 131: {
                return lWCommonText.getText();
            }
            case 511: {
                return VCommonTextDelegate.concatenate((Object[])super.getProperty(ID.ALL_PROPERTIES), mNewProperties);
            }
            case 512: {
                return VCommonTextDelegate.concatenate((Object[])super.getProperty(ID.ALL_LISTENERS), mNewListeners);
            }
        }
        return super.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        LWCommonText lWCommonText = this.getLWCommonText();
        switch (iD.toID()) {
            case 115: {
                this.mAlignment = (Alignment)object;
                this.setTextAlignment(this.mAlignment.toID());
                return true;
            }
            case 152: {
                this.setBorderBevel(lWCommonText, object);
                return true;
            }
            case 576: {
                this.mColorEdge = VCommonTextDelegate.toBoolean(object);
                this.setBorderBevel(lWCommonText, this.mBorderBevel);
                return true;
            }
            case 578: {
                this.mRolloverEdge = VCommonTextDelegate.toBoolean(object);
                return true;
            }
            case 577: {
                this.mPartialEdge = VCommonTextDelegate.toBoolean(object);
                this.setBorderBevel(lWCommonText, this.mBorderBevel);
                return true;
            }
            case 199: {
                this.mCaseRestriction = (CaseRestriction)object;
                lWCommonText.setValueStringFilter(sFilter[this.mCaseRestriction.toID()]);
                return true;
            }
            case 193: {
                lWCommonText.setCaretPosition(VCommonTextDelegate.toInt(object));
                return true;
            }
            case 202: {
                lWCommonText.setFocusable(!VCommonTextDelegate.toBoolean(object));
                return true;
            }
            case 194: {
                lWCommonText.setEditable(VCommonTextDelegate.toBoolean(object));
                return true;
            }
            case 117: {
                lWCommonText.setMaximumChars(VCommonTextDelegate.toInt(object));
                return true;
            }
            case 195: {
                if (object == null) {
                    lWCommonText.selectAll();
                } else {
                    lWCommonText.select(((Point)object).x, ((Point)object).y);
                }
                return true;
            }
            case 131: {
                lWCommonText.setText((String)object);
                lWCommonText.invalidateCanvas();
                return true;
            }
        }
        return super.setProperty(iD, object);
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        if (clazz == TextListener.class) {
            this.getLWCommonText().addTextListener((TextListener)eventListener);
        } else if (clazz == SelectionListener.class) {
            this.getLWCommonText().addSelectionListener((SelectionListener)eventListener);
        } else {
            super.addListener(clazz, eventListener);
        }
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        if (clazz == TextListener.class) {
            this.getLWCommonText().removeTextListener((TextListener)eventListener);
        } else if (clazz == SelectionListener.class) {
            this.getLWCommonText().removeSelectionListener((SelectionListener)eventListener);
        } else {
            super.removeListener(clazz, eventListener);
        }
    }

    public void setBorderBevel(EwtComponent ewtComponent, Object object) {
        this.mBorderBevel = (BorderBevel)object;
        BorderPainter borderPainter = sBorder[this.mBorderBevel.toID()];
        if (this.mPartialEdge && this.mColorEdge) {
            borderPainter = sBorder[6];
        } else if (this.mPartialEdge) {
            borderPainter = sBorder[5];
        } else if (this.mColorEdge) {
            borderPainter = sBorder[4];
        }
        ((EwtComponent)this.getComponent()).setBorderPainter(borderPainter);
    }

    protected void setTextAlignment(int n) {
        LWCommonText lWCommonText = this.getLWCommonText();
        if (n == 4) {
            switch (n) {
                case 4: {
                    if (this.getDirection() == LanguageDirection.RIGHT_TO_LEFT) {
                        n = 1;
                        break;
                    }
                    if (this.getDirection() == LanguageDirection.LEFT_TO_RIGHT) {
                        n = 2;
                        break;
                    }
                    int n2 = LocaleUtils.getReadingDirectionForLocale(null);
                    n = n2 == 2 ? 1 : 2;
                    break;
                }
            }
        }
        lWCommonText.setAlignment(sAlignment[n]);
    }
}

