/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.text.StringCharacterIterator;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwText.displayFilter.CharEchoFilter;
import oracle.ewt.lwAWT.lwText.displayFilter.IdentityDisplayFilter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.Main;
import oracle.forms.engine.Runform;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.handler.TextFieldItem;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VTextFieldDelegate;
import oracle.graphics.vgs.ui.Text;

public class VTextField
extends LWTextField
implements ICustomView {
    private static final char PASSWORD_CHAR = '*';
    private static final char _ZWNBS = '\ufeff';
    private static int sInstanceCounter;
    private static CharEchoFilter sPasswordDisplayFilter;
    private static IdentityDisplayFilter sNewlineDisplayFilter;
    private ICustomView mDelegate;
    private IHandler mHandler;
    private int mInstance;
    private boolean mSecure = false;
    private int mFontStyle;
    private MessageGenerator mEMG;
    private MessageGenerator mTPG;
    private Main mApplet;
    private Runform mDispatcher = null;
    private Font mCachedFont = null;
    private Font mCachedItalicFont = null;
    private Font mCachedPersistFont = null;
    private Color mCachedColor = null;
    private Color mCachedPlaceholderColor = null;
    private boolean mPersistentPlaceholder = false;

    public VTextField(Runform runform) {
        this.mDispatcher = runform;
        this.mDelegate = new VTextFieldDelegate(this);
        this.init();
        this.mInstance = sInstanceCounter++;
    }

    public VTextField() {
        this((Runform)null);
    }

    public void setStyle(int n) {
        this.mFontStyle = n;
    }

    @Override
    public void cut() {
        if (this.mSecure) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                super.cut();
            }
            catch (IllegalStateException illegalStateException) {
                ClipboardErrorUtils.displayMessage(this.mEMG, this.mTPG, this.getParent(), this.mApplet.isAlertDialogAllowed());
            }
        }
    }

    @Override
    public void copy() {
        if (this.mSecure) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                super.copy();
            }
            catch (IllegalStateException illegalStateException) {
                ClipboardErrorUtils.displayMessage(this.mEMG, this.mTPG, this.getParent(), this.mApplet.isAlertDialogAllowed());
            }
        }
    }

    @Override
    public void paste() {
        try {
            super.paste();
        }
        catch (IllegalStateException illegalStateException) {
            ClipboardErrorUtils.displayMessage(this.mEMG, this.mTPG, this.getParent(), this.mApplet.isAlertDialogAllowed());
        }
    }

    public void setTextSecure(boolean bl) {
        this.mSecure = bl;
        this.init();
    }

    public boolean isTextSecure() {
        return this.mSecure;
    }

    public void setPersistentPlaceholder(boolean bl) {
        this.mPersistentPlaceholder = bl;
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        super.paintCanvasInterior(graphics);
        String string = this.getDisplayStringFilter().convertString(this.getText());
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Text.drawUnderlineOverstrike(graphics, string, this.getAlignmentOffset(string, this.getFont(), false), (this.getInnerHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent(), this.mFontStyle);
        if (this.getHandler() != null) {
            String string2 = null;
            string2 = ((TextComponentItem)this.getHandler()).getPlaceholderText();
            if (string2 != null) {
                Object object;
                UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
                Color color = graphics.getColor();
                Font font = graphics.getFont();
                if (this.mCachedFont == null || this.mCachedFont != font) {
                    Font font2;
                    this.mCachedFont = font;
                    this.mCachedItalicFont = font2 = new Font(font.getName(), 2, font.getSize());
                    if (this.mPersistentPlaceholder) {
                        this.mCachedPersistFont = object = new Font(font.getName(), 0, (int)((double)font.getSize() * 0.7));
                    }
                }
                boolean bl = false;
                if (this.mPersistentPlaceholder && (this.hasGlobalFocus() || !this.getText().equals("")) && this.mCachedPersistFont != null) {
                    bl = true;
                    graphics.setFont(this.mCachedPersistFont);
                    fontMetrics = graphics.getFontMetrics();
                } else if (this.mCachedItalicFont != null && this.getText().equals("")) {
                    graphics.setFont(this.mCachedItalicFont);
                    fontMetrics = graphics.getFontMetrics();
                } else {
                    return;
                }
                Object object2 = object = this.mDispatcher != null ? this.mDispatcher : ((TextFieldItem)this.mHandler).getDispatcher();
                if (this.mCachedColor == null || this.mCachedColor != color) {
                    float[] fArray;
                    this.mCachedColor = color;
                    this.mCachedPlaceholderColor = ((Runform)object).getPlaceholderColor() != null ? ((Runform)object).getPlaceholderColor() : ((double)(fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null))[1] >= 0.2 ? Color.getHSBColor(fArray[0], fArray[1] * 0.5f, fArray[2]) : ((double)fArray[2] <= 0.9 ? Color.getHSBColor(fArray[0], fArray[1], (1.0f - fArray[2]) * 0.5f + fArray[2]) : uIDefaults.getColor(LookAndFeel.TEXT_INACTIVE_TEXT)));
                }
                graphics.setColor(this.mCachedPlaceholderColor);
                graphics.drawString(string2, this.getAlignmentOffset(string2, graphics.getFont(), true), (bl ? -1 : (this.getInnerHeight() - fontMetrics.getHeight()) / 2) + fontMetrics.getAscent());
                graphics.setColor(color);
                graphics.setFont(font);
            }
        }
    }

    private int getAlignmentOffset(String string, Font font, boolean bl) {
        int n = 0;
        int n2 = this.getActualAlignment();
        if (n2 != 1) {
            String string2 = string;
            if (!bl || !this.mSecure) {
                string2 = this.getDisplayStringFilter().convertString(string);
            }
            int n3 = string2 != null ? this.getFontMetrics(font).stringWidth(string2) : 0;
            n = this.getInnerWidth() - 1 - 1 - n3;
            if (n2 == 3) {
                n >>= 1;
            }
            if (n < 0) {
                n = 0;
            }
        }
        return n + 1;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new FormsPWAccess();
    }

    private void init() {
        if (this.mSecure) {
            super.setDisplayStringFilter(this.getPasswordDisplayFilter());
            this.enableInputMethods(false);
        } else {
            super.setDisplayStringFilter(this.getNewlineDisplayFilter());
        }
    }

    @Override
    public BorderPainter getBorderPainter() {
        if (this.mHandler != null) {
            if (((UICommon)this.mHandler).getRolloverPainter() != null) {
                return ((UICommon)this.mHandler).getRolloverPainter();
            }
            if (((UICommon)this.mHandler).getHighlightPainter() != null) {
                return ((UICommon)this.mHandler).getHighlightPainter();
            }
            if (((UICommon)this.mHandler).getRequiredPainter() != null) {
                return ((UICommon)this.mHandler).getRequiredPainter();
            }
            if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
                return VTextFieldDelegate.getBorders()[6];
            }
            if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
                return VTextFieldDelegate.getBorders()[5];
            }
            if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
                return VTextFieldDelegate.getBorders()[4];
            }
        }
        return super.getBorderPainter();
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mApplet = iHandler.getApplet();
        this.mEMG = this.mApplet.getErrorMessageGenerator();
        this.mTPG = this.mApplet.getTranslatedPhraseGenerator();
        this.mDelegate.init(iHandler);
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
        super.add((Component)object);
    }

    @Override
    public void remove(Object object) {
        super.remove((Component)object);
    }

    @Override
    public void removeAll() {
    }

    private CharEchoFilter getPasswordDisplayFilter() {
        if (sPasswordDisplayFilter == null) {
            Runform runform = this.mDispatcher != null ? this.mDispatcher : ((TextFieldItem)this.mHandler).getDispatcher();
            char c = runform.getConcealedChar();
            sPasswordDisplayFilter = new CharEchoFilter(c != '\u0000' ? c : (char)'*');
        }
        return sPasswordDisplayFilter;
    }

    private IdentityDisplayFilter getNewlineDisplayFilter() {
        if (sNewlineDisplayFilter == null) {
            sNewlineDisplayFilter = new NewlineDisplayFilter();
        }
        return sNewlineDisplayFilter;
    }

    final class FormsPWAccess
    extends LWTextField.Access {
        FormsPWAccess() {
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            if (VTextField.this.mSecure) {
                return AccessibleRole.PASSWORD_TEXT;
            }
            return AccessibleRole.TEXT;
        }
    }

    private class NewlineDisplayFilter
    extends IdentityDisplayFilter {
        private NewlineDisplayFilter() {
        }

        @Override
        public String convertString(String string) {
            if (VTextField.this.mApplet != null && StringUtils.containsRightToLeft(string) && (string.indexOf(10) != -1 || string.indexOf(13) != -1)) {
                StringBuffer stringBuffer = new StringBuffer();
                StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
                char c = stringCharacterIterator.current();
                while (c != '\uffff') {
                    if (c != '\n' && c != '\r') {
                        stringBuffer.append(c);
                    } else {
                        stringBuffer.append('\ufeff');
                    }
                    c = stringCharacterIterator.next();
                }
                string = stringBuffer.toString();
                stringBuffer = null;
            }
            return string;
        }
    }
}

