/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Rectangle;
import java.util.EventListener;
import oracle.ewt.iterator.ArrayIterator;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.spinBox.BuddyTextField;
import oracle.ewt.spinBox.SpinBox;
import oracle.ewt.spinBox.SpinBuddy;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.SpinListItem;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VSpinListDelegate;

public class VSpinList
extends SpinBox
implements ICustomView {
    private static int sInstanceCounter;
    private ICustomView mDelegate;
    private IHandler mHandler;
    private int mInstance;
    private SpinBuddy mSpinBuddy;
    private ArrayIterator mIterator;
    private String[] mValues = new String[]{""};
    private boolean mEmpty = true;

    public VSpinList() {
        this.mSpinBuddy = this.getSpinBuddy();
        this.mIterator = new ArrayIterator(this.mValues, true);
        this.setIterator(this.mIterator);
        this.mDelegate = new VSpinListDelegate(this);
        this.mInstance = sInstanceCounter++;
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public BorderPainter getBorderPainter() {
        if (((UICommon)this.mHandler).getRolloverPainter() != null) {
            return ((UICommon)this.mHandler).getRolloverPainter();
        }
        if (((UICommon)this.mHandler).getHighlightPainter() != null) {
            return ((UICommon)this.mHandler).getHighlightPainter();
        }
        if (((UICommon)this.mHandler).getRequiredPainter() != null) {
            return ((UICommon)this.mHandler).getRequiredPainter();
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VSpinListDelegate.getBorders()[6];
        }
        if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VSpinListDelegate.getBorders()[5];
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
            return VSpinListDelegate.getBorders()[4];
        }
        return super.getBorderPainter();
    }

    @Override
    public boolean requestFocusInWindow() {
        return ((BuddyTextField)this.mSpinBuddy).requestFocusInWindow();
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
        String[] stringArray;
        if (this.mEmpty) {
            stringArray = new String[]{(String)object};
            this.mEmpty = false;
        } else {
            if (n < 0 || n > this.mValues.length) {
                n = this.mValues.length;
            }
            stringArray = new String[this.mValues.length + 1];
            int n2 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == n) {
                    stringArray[i] = (String)object;
                    continue;
                }
                stringArray[i] = this.mValues[n2];
                ++n2;
            }
        }
        this.mValues = stringArray;
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(true);
        this.mIterator = new ArrayIterator(this.mValues, true);
        super.setIterator(this.mIterator);
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(false);
    }

    @Override
    public void remove(Object object) {
        String[] stringArray;
        int n = this.mValues.length;
        int n2 = (Integer)object;
        if (n2 < 0 || n2 >= this.mValues.length) {
            return;
        }
        n = this.mValues.length - 1;
        if (n == 0) {
            stringArray = new String[]{""};
            this.mEmpty = true;
        } else {
            stringArray = new String[n];
            int n3 = 0;
            for (int i = 0; i < this.mValues.length; ++i) {
                if (i == n2) continue;
                stringArray[n3++] = this.mValues[i];
            }
        }
        this.mValues = stringArray;
        Integer n4 = (Integer)this.getProperty(ID.SELECTEDINDEX);
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(true);
        this.mIterator = new ArrayIterator(this.mValues, true);
        super.setIterator(this.mIterator);
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(false);
        if (n4 > n2) {
            Integer n5 = n4;
            n4 = n4 - 1;
        } else if (n4 == n2) {
            return;
        }
        boolean bl = this.setProperty(ID.SELECT, (int)n4);
    }

    @Override
    public void removeAll() {
        this.mEmpty = true;
        Object[] objectArray = new String[]{""};
        this.mIterator = new ArrayIterator(objectArray, true);
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(true);
        super.setIterator(this.mIterator);
        ((SpinListItem)this.mHandler).setIgnoreChangeEvent(false);
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }
}

