/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import oracle.bali.share.util.IntegerUtils;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.meter.BoundedRangeModel;
import oracle.ewt.meter.BoundedRangeModelImpl;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.slider.Slider;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.SliderItem;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VSliderDelegate;

public class VSlider
extends Slider
implements ICustomView,
PropertyChangeListener {
    private static int sInstanceCounter;
    private ICustomView mDelegate;
    private IHandler mHandler;
    private int mInstance;
    private boolean mResetting = false;
    private boolean mServerSetting = false;
    private boolean mChanged = false;
    private int mOldValue = 0;
    private int mInterval = 1;
    private VSliderLabel mLabel;

    public VSlider() {
        BoundedRangeModelImpl boundedRangeModelImpl = new BoundedRangeModelImpl(0, 50, 0);
        this.setModel(boundedRangeModelImpl);
        boundedRangeModelImpl.addPropertyChangeListener(this);
        this.mDelegate = new VSliderDelegate(this);
        this.mInstance = sInstanceCounter++;
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501 || mouseEvent.getID() == 500) {
            this.paintImmediate();
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == "value") {
            int n = (Integer)propertyChangeEvent.getNewValue() * this.getInterval();
            if (this.mLabel != null) {
                this.mLabel.setText(String.valueOf(n));
            }
            if (this.mResetting) {
                return;
            }
            boolean bl = this.isSliderArmed();
            if (!bl) {
                this.mOldValue = this.getModel().getValue();
            }
            if (this.mServerSetting) {
                return;
            }
            if (bl) {
                this.mChanged = true;
                return;
            }
            ((SliderItem)this.mHandler).setDirty(true);
        }
    }

    public boolean isSliderArmed() {
        return this.getSliderUI().getSliderInputHandler(this).isArmed(this);
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    public void createLabel() {
        this.mLabel = new VSliderLabel("0", 3);
        this.add((Component)this.mLabel, -1);
        this.mLabel.setSize(this.getWidth(), this.getHeight() - 26);
        this.mLabel.setLocation(0, 26);
        this.mLabel.setVisible(true);
        this.mLabel.setForeground(this.getForeground());
    }

    public VSliderLabel getLabel() {
        return this.mLabel;
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public BorderPainter getBorderPainter() {
        if (((UICommon)this.mHandler).getRolloverPainter() != null) {
            return ((UICommon)this.mHandler).getRolloverPainter();
        }
        if (((UICommon)this.mHandler).getHighlightPainter() != null) {
            return ((UICommon)this.mHandler).getHighlightPainter();
        }
        if (((UICommon)this.mHandler).getRequiredPainter() != null) {
            return ((UICommon)this.mHandler).getRequiredPainter();
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VSliderDelegate.getBorders()[6];
        }
        if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VSliderDelegate.getBorders()[5];
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
            return VSliderDelegate.getBorders()[4];
        }
        return super.getBorderPainter();
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }

    public void setServerSetting(boolean bl) {
        this.mServerSetting = bl;
    }

    public void setResetting(boolean bl) {
        this.mResetting = bl;
    }

    public boolean getResetting() {
        return this.mResetting;
    }

    public void setChanged(boolean bl) {
        this.mChanged = bl;
    }

    public boolean getChanged() {
        return this.mChanged;
    }

    public void setOldValue(int n) {
        this.mOldValue = n;
    }

    public int getOldValue() {
        return this.mOldValue;
    }

    public void setInterval(int n) {
        this.mInterval = n;
    }

    public int getInterval() {
        return this.mInterval;
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new VSliderAccess();
    }

    public class VSliderLabel
    extends LWLabel {
        VSliderLabel(String string, int n) {
            super(string, n);
        }

        @Override
        protected AccessibleContext accessAccessibleContext() {
            return null;
        }
    }

    private class VSliderAccess
    extends AccessibleLWComponent
    implements AccessibleValue {
        public VSliderAccess() {
            super(VSlider.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.HORIZONTAL);
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SLIDER;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            BoundedRangeModel boundedRangeModel = VSlider.this.getModel();
            return IntegerUtils.getInteger(boundedRangeModel == null ? 0 : boundedRangeModel.getValue() * VSlider.this.getInterval());
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            BoundedRangeModel boundedRangeModel = VSlider.this.getModel();
            if (boundedRangeModel == null) {
                return false;
            }
            boundedRangeModel.setValue(number.intValue());
            return true;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            BoundedRangeModel boundedRangeModel = VSlider.this.getModel();
            return IntegerUtils.getInteger(boundedRangeModel == null ? 0 : boundedRangeModel.getMinimum() * VSlider.this.getInterval());
        }

        @Override
        public Number getMaximumAccessibleValue() {
            BoundedRangeModel boundedRangeModel = VSlider.this.getModel();
            return IntegerUtils.getInteger(boundedRangeModel == null ? 0 : boundedRangeModel.getMaximum() * VSlider.this.getInterval());
        }
    }
}

