/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Rectangle;
import java.util.EventListener;
import oracle.ewt.meter.ProgressBar;
import oracle.ewt.painter.BorderPainter;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.BorderBevel;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.FormsBoundedRange;
import oracle.forms.ui.FormsProgressPainter;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VProgressDelegate;

public class VProgress
extends ProgressBar
implements ICustomView {
    private static int sInstanceCounter;
    private ICustomView mDelegate;
    private IHandler mHandler;
    private int mInstance;

    public VProgress() {
        this.setModel(new FormsBoundedRange(0, 50, 0));
        this.mDelegate = new VProgressDelegate(this);
        this.mInstance = sInstanceCounter++;
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
        int n = ((UICommon)this.mHandler).getDispatcher().getDarkLuminance();
        this.setPainter(FormsProgressPainter.getPainter(false, false, n));
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public BorderPainter getBorderPainter() {
        BorderBevel borderBevel = (BorderBevel)this.getProperty(ID.BORDER_BEVEL);
        if (((UICommon)this.mHandler).getRolloverPainter() != null) {
            return ((UICommon)this.mHandler).getRolloverPainter();
        }
        if (((UICommon)this.mHandler).getHighlightPainter() != null) {
            return ((UICommon)this.mHandler).getHighlightPainter();
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VProgressDelegate.getBorders()[6];
        }
        if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VProgressDelegate.getBorders()[5];
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
            return VProgressDelegate.getBorders()[4];
        }
        if (borderBevel == null || borderBevel == BorderBevel.NONE) {
            return VProgressDelegate.getBorders()[0];
        }
        if (borderBevel == BorderBevel.RAISED) {
            return VProgressDelegate.getBorders()[1];
        }
        if (borderBevel == BorderBevel.LOWERED) {
            return VProgressDelegate.getBorders()[2];
        }
        if (borderBevel == BorderBevel.PLAIN) {
            return VProgressDelegate.getBorders()[3];
        }
        return super.getBorderPainter();
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }
}

