/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventListener;
import oracle.ewt.event.AnyEventListener;
import oracle.ewt.imageCanvas.ScalingImageCanvas;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.ImmInsets;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.ui.FScalingImageCanvas;
import oracle.forms.ui.IView;
import oracle.forms.ui.delegates.VImageDelegate;

public class VImage
extends ScrollBox
implements IView,
MouseListener {
    private static int sInstanceCounter;
    private IView mDelegate;
    private IHandler mHandler;
    private int mInstance;
    private MouseListener mMouseListener = null;

    public VImage() {
        super(new FScalingImageCanvas(), 2, 2);
        ((ScalingImageCanvas)this.getContent()).setInteriorAlignmentX(0.5f);
        ((ScalingImageCanvas)this.getContent()).setInteriorAlignmentY(0.5f);
        this.mDelegate = new VImageDelegate(this);
        this.mInstance = sInstanceCounter++;
    }

    @Override
    public BorderPainter getBorderPainter() {
        if (((UICommon)this.mHandler).getRolloverPainter() != null) {
            return ((UICommon)this.mHandler).getRolloverPainter();
        }
        if (((UICommon)this.mHandler).getHighlightPainter() != null) {
            return ((UICommon)this.mHandler).getHighlightPainter();
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VImageDelegate.getBorders()[6];
        }
        if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VImageDelegate.getBorders()[5];
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
            return VImageDelegate.getBorders()[4];
        }
        return super.getBorderPainter();
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.mHandler == null) {
            return;
        }
        String string = System.getProperty("os.name");
        boolean bl = false;
        if (string.startsWith("Windows")) {
            if ((mouseEvent.getModifiersEx() & 0x1000) == 4096) {
                bl = true;
            }
        } else {
            bl = mouseEvent.isPopupTrigger();
        }
        if (bl) {
            ImmInsets immInsets = this.getBorderInsets();
            mouseEvent.translatePoint(immInsets.left, immInsets.top);
            this.mMouseListener.mousePressed(mouseEvent);
            mouseEvent.translatePoint(-immInsets.left, -immInsets.top);
        } else {
            Point point = this.getScrollPosition();
            mouseEvent.translatePoint(point.x, point.y);
            this.mMouseListener.mousePressed(mouseEvent);
            mouseEvent.translatePoint(-point.x, -point.y);
            this.setProperty(ID.FOCUS, Boolean.TRUE);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            Point point = this.getScrollPosition();
            mouseEvent.translatePoint(point.x, point.y);
            this.mMouseListener.mouseReleased(mouseEvent);
            mouseEvent.translatePoint(-point.x, -point.y);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            this.mMouseListener.mouseEntered(mouseEvent);
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            this.mMouseListener.mouseExited(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mHandler != null) {
            this.mMouseListener.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void addAnyEventListener(AnyEventListener anyEventListener) {
        ((ScalingImageCanvas)this.getContent()).addAnyEventListener(anyEventListener);
    }

    @Override
    public void removeAnyEventListener(AnyEventListener anyEventListener) {
        ((ScalingImageCanvas)this.getContent()).removeAnyEventListener(anyEventListener);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this.getContent().addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.getContent().removeFocusListener(focusListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.getContent().addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.getContent().removeKeyListener(keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        if (this.mMouseListener == null) {
            this.mMouseListener = mouseListener;
            this.getContent().addMouseListener(this);
        }
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        if (this.mMouseListener == mouseListener) {
            this.mMouseListener = null;
            this.getContent().removeMouseListener(this);
        }
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.getContent().addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.getContent().removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void requestFocus() {
        this.getContent().requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getContent().requestFocusInWindow();
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        ((ScalingImageCanvas)this.getContent()).setCanvasOrigin(n, n2);
    }

    @Override
    public Painter getFill() {
        if (this.getContent() != null) {
            return ((ScalingImageCanvas)this.getContent()).getFill();
        }
        return null;
    }

    @Override
    public void setFill(Painter painter) {
        ((ScalingImageCanvas)this.getContent()).setFill(painter);
    }

    public void setImage(Image image) {
        Image image2 = ((ScalingImageCanvas)this.getContent()).getImage();
        ((ScalingImageCanvas)this.getContent()).setImage(image);
        if (image2 != null) {
            image2.flush();
        }
    }

    public void setScale(double d, double d2) {
        ((ScalingImageCanvas)this.getContent()).setXScalingFactor(d);
        ((ScalingImageCanvas)this.getContent()).setYScalingFactor(d2);
        ((ScalingImageCanvas)this.getContent()).invalidateCanvas();
    }

    public void setScale(Integer n) {
        ((ScalingImageCanvas)this.getContent()).setXScalingFactor((double)n.intValue() / 100.0);
        ((ScalingImageCanvas)this.getContent()).setYScalingFactor((double)n.intValue() / 100.0);
        ((ScalingImageCanvas)this.getContent()).invalidateCanvas();
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.getContent().setEnabled(bl);
    }
}

