/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.EventListener;
import oracle.bali.share.event.ListenerManager;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.stringFilter.StringFilter;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.CaseRestriction;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.DropDownEvent;
import oracle.forms.ui.DropDownListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VComboBoxDelegate;

public class VComboBox
extends ComboBox
implements ICustomView {
    private static int sInstanceCounter;
    private ICustomView mDelegate = new VComboBoxDelegate(this);
    private IHandler mHandler;
    private int mInstance = sInstanceCounter++;
    private ListenerManager mDDListenerManager;
    private boolean mDropDownShown = false;
    private ItemEvent mPendingItemEvent = null;

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public BorderPainter getBorderPainter() {
        if (((UICommon)this.mHandler).getRolloverPainter() != null) {
            return ((UICommon)this.mHandler).getRolloverPainter();
        }
        if (((UICommon)this.mHandler).getHighlightPainter() != null) {
            return ((UICommon)this.mHandler).getHighlightPainter();
        }
        if (((UICommon)this.mHandler).getRequiredPainter() != null) {
            return ((UICommon)this.mHandler).getRequiredPainter();
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE && this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VComboBoxDelegate.getBorders()[6];
        }
        if (this.getProperty(ID.PARTIAL_EDGE) == Boolean.TRUE) {
            return VComboBoxDelegate.getBorders()[5];
        }
        if (this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE) {
            return VComboBoxDelegate.getBorders()[4];
        }
        return super.getBorderPainter();
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
        String string = (String)object;
        CaseRestriction caseRestriction = (CaseRestriction)this.mDelegate.getProperty(ID.CASE_FOLD);
        if (caseRestriction != null) {
            StringFilter[] stringFilterArray = VComboBoxDelegate.getCaseFilters();
            StringFilter stringFilter = stringFilterArray[caseRestriction.toID()];
            string = stringFilter.convertString(string);
        }
        if (n == -1) {
            super.add(string);
        } else {
            super.insert(string, n);
        }
    }

    @Override
    public void remove(Object object) {
        super.remove((Integer)object);
    }

    @Override
    public void removeAll() {
        super.removeAll();
    }

    public synchronized void addDropDownListener(DropDownListener dropDownListener) {
        if (this.mDDListenerManager == null) {
            this.mDDListenerManager = new ListenerManager();
        }
        this.mDDListenerManager.addListener(dropDownListener);
    }

    public synchronized void removeDropDownListener(DropDownListener dropDownListener) {
        if (this.mDDListenerManager != null) {
            this.mDDListenerManager.removeListener(dropDownListener);
        }
    }

    @Override
    protected void processItemEvent(ItemEvent itemEvent) {
        if (!this.isDropDownVisible()) {
            super.processItemEvent(itemEvent);
            this.mPendingItemEvent = null;
        } else {
            this.mPendingItemEvent = itemEvent;
        }
    }

    @Override
    protected void setDropDownVisible(boolean bl) {
        super.setDropDownVisible(bl);
        if (this.mPendingItemEvent != null) {
            super.processItemEvent(this.mPendingItemEvent);
            this.mPendingItemEvent = null;
        }
        if (this.mDDListenerManager == null) {
            this.mDropDownShown = bl;
            return;
        }
        Enumeration enumeration = this.mDDListenerManager.getListeners();
        DropDownEvent dropDownEvent = new DropDownEvent(this, bl);
        if (bl) {
            while (enumeration.hasMoreElements()) {
                ((DropDownListener)enumeration.nextElement()).dropDownShown(dropDownEvent);
            }
        } else if (this.mDropDownShown) {
            while (enumeration.hasMoreElements()) {
                ((DropDownListener)enumeration.nextElement()).dropDownHidden(dropDownEvent);
            }
        }
        this.mDropDownShown = bl;
    }

    public void setMaxLength(int n) {
        LWTextField lWTextField = this.getLWTextField();
        lWTextField.setMaximumChars(n);
    }

    public int getMaxLength() {
        LWTextField lWTextField = this.getLWTextField();
        return lWTextField.getMaximumChars();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.getLWTextField().requestFocusInWindow();
    }

    @Override
    public void setFill(Painter painter) {
        LWTextField lWTextField = this.getLWTextField();
        lWTextField.setFill(painter);
        super.setFill(painter);
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }

    @Override
    protected boolean allowDropDown() {
        return this.getItemCount() > 0;
    }
}

