/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import oracle.bali.share.collection.StringKey;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.button.PushButton;
import oracle.ewt.painter.FixedBorderPainter;
import oracle.ewt.painter.Painter;
import oracle.forms.handler.ButtonItem;
import oracle.forms.handler.IHandler;
import oracle.forms.handler.UICommon;
import oracle.forms.properties.ID;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VButtonDelegate;
import oracle.graphics.vgs.ui.Text;

public class VButton
extends PushButton
implements ICustomView {
    private static int sInstanceCounter;
    private ICustomView mDelegate;
    private IHandler mHandler;
    private int mInstance;
    private Painter mFBP = null;
    private int mFontStyle;
    private boolean mColorEdge = false;
    private static StringKey sCSDKey;

    public VButton() {
        if (this.mFBP == null) {
            FixedBorderPainter fixedBorderPainter = new FixedBorderPainter(this.getPainter(), -3, -1, -3, -1);
            this.mFBP = fixedBorderPainter;
        }
        this.mDelegate = new VButtonDelegate(this);
        this.mInstance = sInstanceCounter++;
    }

    @Override
    public void init(IHandler iHandler) {
        this.mHandler = iHandler;
        this.mDelegate.init(iHandler);
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void destroy() {
    }

    @Override
    public Object getProperty(ID iD) {
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void setLabel(String string) {
        if (this.mFBP == null) {
            FixedBorderPainter fixedBorderPainter = new FixedBorderPainter(this.getPainter(), -3, -1, -3, -1);
            this.setPainter(fixedBorderPainter);
            this.mFBP = fixedBorderPainter;
        }
        super.setLabel(string);
    }

    public Painter getLabelOnlyPainter() {
        return this.mFBP;
    }

    @Override
    protected String getDefaultName() {
        return this.getBaseClassName() + this.mInstance;
    }

    public void setStyle(int n) {
        this.mFontStyle = n;
    }

    @Override
    public void paintInterior(Graphics graphics) {
        super.paintInterior(graphics);
        String string = this.getLabel();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        Text.drawUnderlineOverstrike(graphics, this.getLabel(), (this.getInnerWidth() - (int)rectangle2D.getWidth()) / 2, (this.getInnerHeight() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent(), this.mFontStyle);
    }

    @Override
    public void paint(Graphics graphics) {
        if ((this.getProperty(ID.COLOR_EDGE) == Boolean.TRUE || ((ButtonItem)this.mHandler).useRolloverBorderColor()) && this.mHandler.getApplet().hasOracleLF()) {
            UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
            Object object = uIDefaults.get("Button.lightBorder");
            Object object2 = uIDefaults.get("Button.darkBorder");
            Color color = ((ButtonItem)this.mHandler).useRolloverBorderColor() ? ((UICommon)this.mHandler).getDispatcher().getBorderRolloverColor() : ((UICommon)this.mHandler).getDispatcher().getBorderColor();
            Color color2 = null;
            Color color3 = null;
            if (this.getProperty(ID.ENABLED) != Boolean.TRUE) {
                color = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
            } else {
                color2 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
                uIDefaults.put(LookAndFeel.NORMAL_INTENSITY, color);
            }
            if ((this.getPaintState() & 4) != 0) {
                color3 = uIDefaults.getColor(sCSDKey);
                uIDefaults.put(sCSDKey, color);
            }
            uIDefaults.put("Button.lightBorder", color);
            uIDefaults.put("Button.darkBorder", color);
            super.paint(graphics);
            if (color2 != null) {
                uIDefaults.put(LookAndFeel.NORMAL_INTENSITY, color2);
            }
            if (color3 != null) {
                uIDefaults.put(sCSDKey, color3);
            }
            uIDefaults.put("Button.lightBorder", object);
            uIDefaults.put("Button.darkBorder", object2);
        } else {
            super.paint(graphics);
        }
    }

    static {
        sCSDKey = new StringKey("controlShadowDark");
    }
}

