/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.EventListener;
import java.util.EventObject;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.util.FocusUtils;
import oracle.forms.beans.Encoder;
import oracle.forms.beans.PropertyManager;
import oracle.forms.handler.HeavyBeanManager;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.ID;
import oracle.forms.ui.BeanManager;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;
import oracle.forms.ui.ICustomView;
import oracle.forms.ui.delegates.VBeanDelegate;

public class VBean
extends LWContainer
implements ICustomView {
    private VBeanDelegate mDelegate;
    private Component mBean;
    private IHandler mHandler;
    private String mBeanName;
    private boolean mBeanMgrInitialized = false;
    public static final ID BEAN_NAME = ID.registerProperty("beanName");
    public static final ID DEBUG_MODE = ID.registerProperty("debugMode");
    public static final ID DELIVER_EVENT = ID.registerProperty("deliverEvent");
    public static final ID FOCUS_EVENT = ID.registerProperty("FOCUS_EVENT");
    public static final ID KEY_EVENT = ID.registerProperty("KEY_EVENT");

    public VBean() {
        this.setLayout(new BorderLayout());
        this.mDelegate = new VBeanDelegate(this);
    }

    public final Component getBean() {
        return this.mBean;
    }

    public final IHandler getHandler() {
        return this.mHandler;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.addManager();
    }

    @Override
    public void init(IHandler iHandler) {
        this.mDelegate.init(iHandler);
        this.mHandler = iHandler;
        this.instantiateBean();
    }

    @Override
    public void destroy() {
        if (this.getBean() instanceof Applet) {
            Applet applet = (Applet)this.getBean();
            applet.stop();
            applet.destroy();
        }
    }

    @Override
    public Object getProperty(ID iD) {
        if (iD == BEAN_NAME) {
            return this.mBeanName;
        }
        if (iD == DEBUG_MODE) {
            return this.mDelegate.getBeanManager().getDebugMode();
        }
        if (iD == ID.ALL_PROPERTIES || iD == ID.ALL_LISTENERS) {
            return (Object[])this.mDelegate.getProperty(iD);
        }
        if (ID.isRegistered(iD.toString())) {
            return this.getBeanProperty(iD);
        }
        return this.mDelegate.getProperty(iD);
    }

    @Override
    public boolean setProperty(ID iD, Object object) {
        boolean bl = false;
        if (iD == BEAN_NAME) {
            if (this.getBean() != null) {
                return bl;
            }
            this.mBeanName = (String)object;
            this.mDelegate.getBeanManager().log("Setting beanName to " + object);
            this.instantiateBean();
            return true;
        }
        if (iD == DEBUG_MODE) {
            this.mDelegate.getBeanManager().setDebugMode((String)object);
            return true;
        }
        if (ID.isRegistered(iD.toString())) {
            if (iD == DELIVER_EVENT) {
                this.mDelegate.getBeanManager().dispatchEvent((EventObject)object);
                this.mDelegate.getBeanManager().log("Setting deliverEvent to " + ((EventObject)object).toString());
                return true;
            }
            bl = this.setBeanProperty(iD, object);
        }
        if (bl) {
            return bl;
        }
        return this.mDelegate.setProperty(iD, object);
    }

    @Override
    public void addListener(Class clazz, EventListener eventListener) {
        this.mDelegate.addListener(clazz, eventListener);
    }

    @Override
    public void removeListener(Class clazz, EventListener eventListener) {
        this.mDelegate.removeListener(clazz, eventListener);
    }

    @Override
    public void repaint(Rectangle rectangle) {
        this.mDelegate.repaint(rectangle);
    }

    @Override
    public void add(Object object, int n) {
    }

    @Override
    public void remove(Object object) {
    }

    @Override
    public void removeAll() {
    }

    @Override
    public void dispatchCustomEvent(CustomEvent customEvent) {
        this.mDelegate.getBeanManager().dispatchCustomEvent(customEvent);
    }

    public void addCustomListener(CustomListener customListener) {
        this.addListener(CustomListener.class, customListener);
    }

    public void removeCustomListener(CustomListener customListener) {
        this.removeListener(CustomListener.class, customListener);
    }

    protected void initializeBean() {
    }

    private void addManager() {
        if (!this.mBeanMgrInitialized && this.getBean() != null && this.getBean().isDisplayable()) {
            Object object;
            this.mBeanMgrInitialized = true;
            BeanManager beanManager = this.mDelegate.getBeanManager();
            if (!this.getBean().isLightweight()) {
                object = new HeavyBeanManager(this.getBean(), beanManager);
                beanManager.log("Heavyweight bean " + this.mBeanName);
            }
            if (this.getBean() instanceof Applet) {
                object = (Applet)this.getBean();
                beanManager.log("Applet bean " + this.mBeanName);
                ((Applet)object).setStub(this.getHandler());
                ((Applet)object).init();
                ((Applet)object).start();
            }
        }
    }

    private void instantiateBean() {
        String string = (String)this.getProperty(BEAN_NAME);
        BeanManager beanManager = this.mDelegate.getBeanManager();
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                this.mBean = (Component)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                beanManager.setBean(this.mBean, string);
                beanManager.introspectBean(clazz);
                this.add(this.mBean);
                this.addManager();
                this.initializeBean();
            }
            catch (Exception exception) {
                beanManager.error("Failed to instantiate class: " + string + " " + exception);
            }
        }
        beanManager.stopDebugCaching();
    }

    /*
     * Enabled aggressive block sorting
     */
    private Object getBeanProperty(ID iD) {
        Object object = null;
        BeanManager beanManager = this.mDelegate.getBeanManager();
        PropertyManager propertyManager = beanManager.get(iD);
        if (propertyManager != null) {
            object = propertyManager.getProperty();
            if (object != null && object.getClass() != String.class) {
                Encoder encoder = BeanManager.findEncoder(propertyManager.getType());
                if (encoder == null) {
                    beanManager.error("null Encoder found for type = " + beanManager.printType(propertyManager.getType()));
                    return null;
                }
                object = encoder.toString(object);
            }
        } else {
            beanManager.warning("null PropertyManager for id = " + iD);
        }
        beanManager.log("Got " + iD + " = " + object);
        return object;
    }

    private boolean setBeanProperty(ID iD, Object object) {
        boolean bl = false;
        Object object2 = object;
        BeanManager beanManager = this.mDelegate.getBeanManager();
        PropertyManager propertyManager = beanManager.get(iD);
        if (propertyManager != null) {
            beanManager.log("Setting " + iD + " to " + object);
            if (object != null && object.getClass() == String.class && object.getClass() != propertyManager.getType()) {
                Encoder encoder = BeanManager.findEncoder(propertyManager.getType());
                if (encoder != null) {
                    beanManager.tablog("found " + encoder.getClass().getName() + " for " + beanManager.printType(propertyManager.getType()));
                    object2 = encoder.fromString((String)object);
                    bl = propertyManager.setProperty(object2);
                    return bl;
                }
                beanManager.error("null Encoder found for type = " + beanManager.printType(propertyManager.getType()));
                return bl;
            }
            bl = propertyManager.setProperty(object2);
        }
        return bl;
    }

    @Override
    public boolean isFocusTraversable() {
        if (this.isVisible() && this.isActive() && FocusUtils.areNewFocusAPIsAvailable()) {
            return true;
        }
        return super.isFocusTraversable();
    }
}

