/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.share.event.ListenerManager;
import oracle.ewt.dTree.DTreeItem;
import oracle.ewt.dTree.DTreeSelection;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.forms.handler.TreeItem;

public class TreeDataSource
implements OneDDataSource {
    private TreeItem mTree;
    private Integer mID;
    private ListenerManager mListeners;
    private Vector mIDs;
    private Vector mLabels;
    private Vector mIcons;
    private Vector mState;
    private int mNumChildren = 0;
    private boolean mNodeModifying = false;

    public TreeDataSource(TreeItem treeItem, Integer n) {
        this(treeItem, n, null);
    }

    public TreeDataSource(TreeItem treeItem, Integer n, Integer n2) {
        this.mTree = treeItem;
        this.mID = n;
        if (n2 != null) {
            this.mNumChildren = n2;
        }
        this.mIDs = new Vector();
        this.mLabels = new Vector();
        this.mIcons = new Vector();
        this.mState = new Vector();
        if (this.mNumChildren > 0) {
            this.mIDs.setSize(this.mNumChildren);
            this.mLabels.setSize(this.mNumChildren);
            this.mIcons.setSize(this.mNumChildren);
            this.mState.setSize(this.mNumChildren);
        }
    }

    public void setNodeModifying(boolean bl) {
        this.mNodeModifying = bl;
    }

    public boolean isNodeModifying() {
        return this.mNodeModifying;
    }

    @Override
    public void addDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this.mListeners == null) {
            this.mListeners = new ListenerManager();
        }
        this.mListeners.addListener(oneDDataSourceListener);
    }

    @Override
    public void removeDataSourceListener(OneDDataSourceListener oneDDataSourceListener) {
        if (this.mListeners != null) {
            this.mListeners.removeListener(oneDDataSourceListener);
        }
    }

    @Override
    public Object getData(int n) {
        Object[] objectArray = new Object[4];
        if (n >= this.mIDs.size()) {
            throw new IllegalArgumentException(this.getClass().getName() + ".getData(): illegal index");
        }
        objectArray[0] = this.mIDs.elementAt(n);
        if (objectArray[0] == null) {
            this.mTree.getNode(this.mID, n);
            objectArray[0] = this.mIDs.elementAt(n);
            if (objectArray[0] == null) {
                this.mIDs.setElementAt(-1, n);
            }
        }
        objectArray[1] = this.mLabels.elementAt(n);
        objectArray[2] = this.mIcons.elementAt(n);
        objectArray[3] = this.mState.elementAt(n);
        return objectArray;
    }

    @Override
    public int getItemCount() {
        return this.mNumChildren;
    }

    public void setItemCount(Integer n, boolean bl) {
        this.mNumChildren = n;
        if (this.mNumChildren > 0) {
            this.mIDs.setSize(this.mNumChildren);
            this.mLabels.setSize(this.mNumChildren);
            this.mIcons.setSize(this.mNumChildren);
            this.mState.setSize(this.mNumChildren);
        }
        if (bl) {
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, 0, this.mNumChildren);
            this.processEvent(oneDDataSourceEvent);
        }
    }

    @Override
    public void setData(int n, Object object) {
    }

    public Integer getID(int n) {
        return (Integer)this.mIDs.elementAt(n);
    }

    public int getIndex(Integer n) {
        return this.mIDs.indexOf(n);
    }

    public TreeItem getTree() {
        return this.mTree;
    }

    public void addChild(int n, Integer n2, String string, Image image, Integer n3, int n4) {
        if (n4 == 2 || n4 == 3) {
            OneDDataSourceEvent oneDDataSourceEvent;
            Integer n5 = (Integer)this.mIDs.elementAt(n);
            boolean bl = n5 != null && n5 == -1;
            if (bl) {
                oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, n, 1);
                this.processEvent(oneDDataSourceEvent);
            }
            this.mIDs.setElementAt(n2, n);
            this.mLabels.setElementAt(string, n);
            this.mIcons.setElementAt(image, n);
            this.mState.setElementAt(n3, n);
            if (bl) {
                oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, 1);
                this.processEvent(oneDDataSourceEvent);
            }
        } else {
            ++this.mNumChildren;
            this.mIDs.insertElementAt(n2, n);
            this.mLabels.insertElementAt(string, n);
            this.mIcons.insertElementAt(image, n);
            this.mState.insertElementAt(n3, n);
            OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, 1);
            this.processEvent(oneDDataSourceEvent);
        }
    }

    public void resetChildren(int n, int n2) {
        this.mNumChildren += n2;
        for (int i = n2; i > 0; --i) {
            this.mIDs.insertElementAt(null, n);
            this.mLabels.insertElementAt(null, n);
            this.mIcons.insertElementAt(null, n);
            this.mState.insertElementAt(null, n);
        }
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, n2);
        this.processEvent(oneDDataSourceEvent);
    }

    public void removeChild(int n) {
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, n, 1);
        --this.mNumChildren;
        this.mIDs.removeElementAt(n);
        this.mLabels.removeElementAt(n);
        this.mIcons.removeElementAt(n);
        this.mState.removeElementAt(n);
        this.processEvent(oneDDataSourceEvent);
    }

    public void removeChildren() {
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, 0, this.mNumChildren);
        this.mNumChildren = 0;
        this.mIDs.removeAllElements();
        this.mLabels.removeAllElements();
        this.mIcons.removeAllElements();
        this.mState.removeAllElements();
        this.processEvent(oneDDataSourceEvent);
    }

    public void modifyChild(int n, int n2, String string, Image image, Integer n3) {
        Object object;
        Integer n4;
        OneDDataSourceEvent oneDDataSourceEvent = new OneDDataSourceEvent(this, 2003, n, 1);
        boolean bl = false;
        DTreeSelection dTreeSelection = null;
        if ((n2 & 1) != 0) {
            this.mLabels.setElementAt(string, n);
        }
        if ((n2 & 2) != 0) {
            this.mIcons.setElementAt(image, n);
        }
        if ((n2 & 4) != 0) {
            n4 = (Integer)this.mState.elementAt(n);
            object = this.getID(n);
            DTreeItem dTreeItem = this.getTree().getCreatedItem(object);
            this.mState.setElementAt(n3, n);
            if (dTreeItem != null) {
                if (n4 == 0 && n3 != 0 || n3 == 0 && n4 != 0) {
                    this.setNodeModifying(true);
                    dTreeSelection = dTreeItem.getTree().getSelection();
                    bl = dTreeSelection.isSelected(dTreeItem);
                    oneDDataSourceEvent = new OneDDataSourceEvent(this, 2002, n, 1);
                    this.processEvent(oneDDataSourceEvent);
                    this.setNodeModifying(false);
                    oneDDataSourceEvent = new OneDDataSourceEvent(this, 2001, n, 1);
                } else {
                    this.mTree.setProgrammaticEvent(true);
                    dTreeItem.setExpanded(n3 == 1);
                    this.mTree.setProgrammaticEvent(false);
                }
            }
        }
        this.processEvent(oneDDataSourceEvent);
        if (bl) {
            n4 = this.getID(n);
            object = this.getTree().getCreatedItem(n4);
            this.getTree().setProgrammaticEvent(true);
            dTreeSelection.toggleItem((DTreeItem)object);
            this.getTree().setProgrammaticEvent(false);
        }
    }

    protected void processEvent(OneDDataSourceEvent oneDDataSourceEvent) {
        Enumeration enumeration;
        if (this.mListeners == null || (enumeration = this.mListeners.getListeners()) == null) {
            return;
        }
        int n = oneDDataSourceEvent.getID();
        block5: while (enumeration.hasMoreElements()) {
            OneDDataSourceListener oneDDataSourceListener = (OneDDataSourceListener)enumeration.nextElement();
            switch (n) {
                case 2001: {
                    oneDDataSourceListener.itemsAdded(oneDDataSourceEvent);
                    continue block5;
                }
                case 2002: {
                    oneDDataSourceListener.itemsRemoved(oneDDataSourceEvent);
                    continue block5;
                }
                case 2003: {
                    oneDDataSourceListener.invalidateItems(oneDDataSourceEvent);
                    continue block5;
                }
            }
        }
    }
}

