/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.timer.Periodic;
import oracle.forms.engine.Runform;
import oracle.forms.registry.MessageGenerator;

public class StatsIndicator
extends LWContainer
implements Runnable,
MouseListener {
    private Periodic mTimer;
    private int mInterval;
    private String mBusyText;
    private boolean mRunning = false;
    private int mCount;
    private boolean mRight = true;
    private int mStrWidth;
    private int mStrHeight;
    private boolean mCancelInRun = false;
    private boolean mKillInRun = false;
    private static final int DIVISIONS = 50;
    private static final int BARWIDTH = 3;
    private Runform mDispatcher;
    private boolean mLatencyCheckRunning = false;
    private Object mLatencyLock = new Object();
    private static final int sLatencyDelay = 2000;

    public StatsIndicator(Runform runform, int n, String string) {
        this.mInterval = n;
        this.mBusyText = string;
        this.mCancelInRun = false;
        this.mKillInRun = false;
        this.mDispatcher = runform;
        this.addMouseListener(this);
    }

    public void setInterval(int n) {
        this.mInterval = n;
    }

    public int getInterval() {
        return this.mInterval;
    }

    public void setBusyText(String string) {
        this.mBusyText = string;
        this.mStrWidth = 0;
        this.mStrHeight = 0;
        if (this.mBusyText == null) {
            return;
        }
        Graphics graphics = this.getGraphics();
        FontMetrics fontMetrics = null;
        if (graphics != null) {
            fontMetrics = this.getGraphics().getFontMetrics();
        }
        if (fontMetrics != null) {
            this.mStrWidth = fontMetrics.stringWidth(this.mBusyText);
            this.mStrHeight = fontMetrics.getAscent();
        }
    }

    public String getBusyText() {
        return this.mBusyText;
    }

    public synchronized void start() {
        if (this.mTimer == null) {
            this.mTimer = new Periodic(this);
            this.mTimer.setName("Busy indicator");
            this.mTimer.setDaemon(true);
            this.mTimer.setPriority(1);
        }
        if (!this.mRunning) {
            this.mTimer.schedule(this.mInterval);
            this.mRight = true;
            this.mCount = 0;
            this.mRunning = true;
            this.mCancelInRun = false;
            this.mKillInRun = false;
        }
    }

    public synchronized void stop() {
        if (this.mRunning && this.mTimer != null) {
            this.mTimer.cancel();
            this.mRunning = false;
            this.mCancelInRun = true;
        }
        this.repaint();
    }

    public synchronized void kill() {
        if (this.mTimer != null && !this.mTimer.isKilled()) {
            this.mTimer.kill();
        }
        this.removeMouseListener(this);
        this.mDispatcher = null;
        this.mKillInRun = true;
        this.mRunning = false;
    }

    @Override
    public void run() {
        if (this.isVisible()) {
            if (++this.mCount == 48) {
                this.mRight = !this.mRight;
                this.mCount = 0;
            }
            this.paintImmediate();
        } else {
            this.stop();
        }
        if (this.mCancelInRun && this.mTimer != null) {
            this.mTimer.cancel();
        }
        if (this.mKillInRun && this.mTimer != null && !this.mTimer.isKilled()) {
            this.mTimer.kill();
            this.mTimer = null;
        }
    }

    @Override
    public void paintInterior(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        Dimension dimension = this.getSize();
        float f = dimension.width * this.mCount / 50;
        int n3 = dimension.height;
        graphics.setColor(this.getForeground());
        if (this.mRunning) {
            n = this.mRight ? (int)f : dimension.width - (int)f;
            graphics.fillRect(n, 0, 3, n3);
        } else {
            graphics.setColor(this.getBackground());
            graphics.fillRect(n, n2, dimension.width, dimension.height);
        }
        graphics.setColor(this.getForeground());
        if (this.mBusyText != null) {
            n = (dimension.width - this.mStrWidth) / 2;
            n2 = (dimension.height - this.mStrHeight) / 2 + this.mStrHeight;
            GraphicUtils.drawString(graphics, this.mBusyText, n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.mDispatcher.getApplet().isNetStatsVisible() && mouseEvent.getButton() == 3 && mouseEvent.getClickCount() >= 2) {
            MessageGenerator messageGenerator = this.mDispatcher.getApplet().getTranslatedPhraseGenerator();
            long l = this.mDispatcher.getConnection().getRoundTripsCount();
            long l2 = this.mDispatcher.getConnection().getBytesCount();
            System.out.println("********************************");
            System.out.println(messageGenerator.getText("STATRESET", new Object[]{Long.toString(l), Long.toString(l2)}));
            System.out.println("********************************");
            this.mDispatcher.getConnection().resetBytesCount();
            this.mDispatcher.getConnection().resetRoundTripsCount();
            this.setBusyText("0 : 0");
            this.repaint();
            return;
        }
        String string = this.mDispatcher.getApplet().getParameter("latencyCheck");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            Object object = this.mLatencyLock;
            synchronized (object) {
                if (!this.mLatencyCheckRunning) {
                    this.mLatencyCheckRunning = true;
                    this.mDispatcher.startLatencyTest();
                    LatencyTimer latencyTimer = new LatencyTimer();
                    this.setBusyText("Latency...");
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    class LatencyTimer
    implements Runnable {
        private Periodic mLatencyTimer;
        private int mLatencyCount = 0;
        private final MessageGenerator mTPG = StatsIndicator.access$000(StatsIndicator.this).getApplet().getTranslatedPhraseGenerator();

        public LatencyTimer() {
            this(2000);
        }

        public LatencyTimer(int n) {
            this.mLatencyTimer = new Periodic((Runnable)this, n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.mLatencyCount == 6) {
                Object object = StatsIndicator.this.mLatencyLock;
                synchronized (object) {
                    this.mLatencyTimer.kill();
                    this.mLatencyTimer = null;
                    StatsIndicator.this.mDispatcher.endLatencyTest();
                    StatsIndicator.this.mLatencyCheckRunning = false;
                    long[] lArray = StatsIndicator.this.mDispatcher.getLatencyResults();
                    if (lArray != null) {
                        StatsIndicator.this.setBusyText(lArray[0] + ":" + lArray[1]);
                        StatsIndicator.this.repaint();
                        System.out.println(this.mTPG.getText("LATRES", new Object[]{Long.toString(lArray[0]), Long.toString(lArray[1])}));
                    }
                }
            } else {
                StatsIndicator.this.setBusyText("Latency... " + (this.mLatencyCount + 1));
                StatsIndicator.this.repaint();
                if (StatsIndicator.this.mDispatcher.getApplet().isNetStatsVisible()) {
                    System.out.println("Latency... " + (this.mLatencyCount + 1));
                }
                StatsIndicator.this.mDispatcher.latencyTick();
            }
            ++this.mLatencyCount;
        }
    }
}

