/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import oracle.ewt.comboBox.ComboBox;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.ewt.lwAWT.lwText.LWTextComponent;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.toolBar.ToolBar;
import oracle.ewt.toolBar.ToolBarActionListener;
import oracle.ewt.toolBar.ToolBarBaseItem;
import oracle.ewt.toolBar.ToolBarButton;
import oracle.ewt.toolBar.ToolBarCheck;
import oracle.ewt.toolBar.ToolBarEvent;
import oracle.ewt.toolBar.ToolBarItem;
import oracle.ewt.toolBar.ToolBarMouseListener;
import oracle.ewt.toolBar.ToolBarPainterItem;
import oracle.ewt.toolBar.ToolBarRadio;
import oracle.ewt.toolBar.ToolBarRadioGroup;
import oracle.ewt.toolBar.ToolBarSeparator;
import oracle.ewt.toolBar.ToolBarToggleButton;
import oracle.ewt.util.ClipboardProxy;
import oracle.forms.engine.Main;
import oracle.forms.engine.Message;
import oracle.forms.engine.MessageHandler;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComboBoxItem;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.EndSubmenu;
import oracle.forms.handler.FormPrintableImpl;
import oracle.forms.handler.MenuInfo;
import oracle.forms.handler.MenuItemInfo;
import oracle.forms.handler.TextAreaItem;
import oracle.forms.handler.TextFieldItem;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.StatusBarInterface;
import oracle.forms.ui.VTextArea;

public class SmartBar
implements ToolBarActionListener,
ToolBarMouseListener {
    public static final int MSG_MENU_EVENT = 477;
    public static final int MSG_WINSYS_EVENT = 478;
    private ToolBar mToolBar;
    private MenuInfo mNonVisMenu;
    private MessageHandler mRecipient;
    private Hashtable mIDs;
    private Runform mDispatcher;
    private int mNumVisItems = 0;
    private static final int ICON_SIZE = 18;
    private static final int ICON_SIZE_MEDIUM = 34;
    private static final int ICON_SIZE_LARGE = 50;

    private SmartBar() {
    }

    public SmartBar(MenuInfo menuInfo, boolean bl, MessageHandler messageHandler, Runform runform, ToolBar toolBar) {
        ToolBarRadioGroup toolBarRadioGroup = null;
        int n = 0;
        int n2 = 0;
        Stack<MenuItemInfo> stack = new Stack<MenuItemInfo>();
        this.mIDs = new Hashtable();
        stack.push(null);
        this.mDispatcher = runform;
        this.mRecipient = messageHandler;
        this.mNonVisMenu = menuInfo;
        Vector vector = bl ? menuInfo.getHBarItemList() : menuInfo.getVBarItemList();
        int n3 = vector.size();
        if (toolBar != null) {
            this.mToolBar = toolBar;
            this.mToolBar.removeAll();
            if (runform.getApplet().getSmartBarColor() != null) {
                this.mToolBar.setBackground(runform.getApplet().getSmartBarColor());
            }
        } else {
            this.mToolBar = new ToolBar(n3);
            if (!bl) {
                this.mToolBar.setHorizontal(false);
            }
            if (runform.getApplet().getSmartBarColor() != null) {
                this.mToolBar.setBackground(runform.getApplet().getSmartBarColor());
            }
        }
        this.mToolBar.addToolBarMouseListener(this);
        for (int i = 0; i < n3; ++i) {
            ToolBarPainterItem toolBarPainterItem;
            boolean bl2;
            boolean bl3;
            Object e = vector.elementAt(i);
            if (e instanceof EndSubmenu) {
                if (n > 0) {
                    --n;
                } else if (n2 > 0) {
                    --n2;
                }
                stack.pop();
                continue;
            }
            MenuItemInfo menuItemInfo = (MenuItemInfo)e;
            int n4 = menuItemInfo.getID();
            MenuItemInfo menuItemInfo2 = (MenuItemInfo)stack.peek();
            if (menuItemInfo2 != null) {
                menuItemInfo.setParent(menuItemInfo2);
            }
            Image image = this.buildIcon(menuItemInfo);
            short s = menuItemInfo.getType();
            if (s == 0) {
                toolBarRadioGroup = null;
                if (menuItemInfo.hasSubmenu()) {
                    if (menuItemInfo.isHidden() || n > 0) {
                        ++n;
                    } else if (!menuItemInfo.isEnabled() || n2 > 0) {
                        ++n2;
                    }
                    stack.push(menuItemInfo);
                    continue;
                }
                bl3 = !menuItemInfo.isHidden() && n == 0;
                bl2 = menuItemInfo.isEnabled() && n2 == 0;
                ToolBarButton toolBarButton = new ToolBarButton(n4, image);
                toolBarButton.setEnabled(bl2);
                toolBarButton.setVisible(bl3);
                toolBarButton.addToolBarActionListener(this);
                toolBarPainterItem = toolBarButton;
            } else if (s == 1) {
                toolBarRadioGroup = null;
                bl3 = !menuItemInfo.isHidden() && n == 0;
                bl2 = menuItemInfo.isEnabled() && n2 == 0;
                ToolBarCheck toolBarCheck = new ToolBarCheck(n4, image);
                toolBarCheck.setEnabled(bl2);
                toolBarCheck.setVisible(bl3);
                toolBarCheck.setState(menuItemInfo.isChecked());
                toolBarCheck.addToolBarActionListener(this);
                toolBarPainterItem = toolBarCheck;
            } else if (s == 2) {
                boolean bl4 = false;
                if (menuItemInfo.isStartGroup() || toolBarRadioGroup == null) {
                    bl4 = true;
                    toolBarRadioGroup = new ToolBarRadioGroup();
                }
                bl3 = !(menuItemInfo.isHidden() || n != 0 || bl && !menuItemInfo.isOnHBar() || !bl && !menuItemInfo.isOnVBar());
                bl2 = menuItemInfo.isEnabled() && n2 == 0;
                ToolBarRadio toolBarRadio = new ToolBarRadio(n4, image, toolBarRadioGroup);
                toolBarRadio.setEnabled(bl2);
                toolBarRadio.setVisible(bl3);
                toolBarRadio.addToolBarActionListener(this);
                if (bl4 || menuItemInfo.isChecked()) {
                    toolBarRadio.setState(true);
                }
                toolBarPainterItem = toolBarRadio;
            } else {
                toolBarRadioGroup = null;
                bl3 = !menuItemInfo.isHidden() && n == 0;
                ToolBarSeparator toolBarSeparator = new ToolBarSeparator(true);
                toolBarSeparator.setVisible(bl3);
                toolBarPainterItem = toolBarSeparator;
            }
            this.hashItem(n4, toolBarPainterItem);
            this.mToolBar.addItem(toolBarPainterItem);
            if (toolBarPainterItem.isVisible()) {
                ++this.mNumVisItems;
            }
            if (menuItemInfo.getLabel() == null) continue;
            String string = this.processHelpText(menuItemInfo.getLabel());
            ((ToolBarItem)toolBarPainterItem).setHelpText(string);
        }
    }

    public void destroy() {
        if (this.mToolBar != null) {
            this.mToolBar.removeToolBarMouseListener(this);
        }
        if (this.mIDs != null) {
            this.mIDs.clear();
        }
        if (this.mNonVisMenu != null) {
            this.mNonVisMenu.removeSmartBar(this);
        }
        this.mRecipient = null;
        this.mToolBar = null;
        this.mNonVisMenu = null;
        this.mIDs = null;
        this.mDispatcher = null;
    }

    private Image buildIcon(MenuItemInfo menuItemInfo) {
        Image image;
        Image image2 = menuItemInfo.getSBImage();
        if (image2 == null && (image = menuItemInfo.getImage()) != null) {
            int n = this.mDispatcher.getScreenRes();
            int n2 = 18;
            if (this.mDispatcher.getSmartBarHeight() == 2) {
                n2 = 34;
            } else if (this.mDispatcher.getSmartBarHeight() == 3) {
                n2 = 50;
            } else if (this.mDispatcher.getSmartBarHeight() == 4 && n != this.mDispatcher.getScreenResolution()) {
                n2 = n2 * n / this.mDispatcher.getScreenResolution();
            }
            int n3 = image.getWidth(this.mDispatcher.getApplet());
            int n4 = image.getHeight(this.mDispatcher.getApplet());
            if ((n3 == -1 || n4 == -1) && ImageUtils.loadImage(image)) {
                n3 = image.getWidth(this.mDispatcher.getApplet());
                n4 = image.getHeight(this.mDispatcher.getApplet());
            }
            if (n3 == n2 && n4 == n2) {
                image2 = image;
            } else if (n3 < n2 || n4 < n2) {
                image2 = this.mDispatcher.getSmartBarIconScaling() ? image.getScaledInstance(n2, n2, 2) : image;
            } else {
                CropImageFilter cropImageFilter = new CropImageFilter(0, 0, n2, n2);
                FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
                image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            }
            MenuInfo.getSBIcons().put(menuItemInfo.getIcon(), image2);
            menuItemInfo.setSBImage(image2);
        }
        return image2;
    }

    private void hashItem(int n, ToolBarBaseItem toolBarBaseItem) {
        if (n != 0) {
            this.mIDs.put(n, toolBarBaseItem);
        }
    }

    public void changeState(ToolBarToggleButton toolBarToggleButton, boolean bl) {
        ToolBarRadio toolBarRadio;
        int n = toolBarToggleButton.getID();
        if (n == -1) {
            throw new Error("SmartBar.changeState(): Unable to identify menu item " + toolBarToggleButton);
        }
        if (toolBarToggleButton instanceof ToolBarRadio && (toolBarRadio = ((ToolBarRadio)toolBarToggleButton).getGroup().getCurrentRadio()) != toolBarToggleButton) {
            this.mNonVisMenu.setState(toolBarRadio.getID(), false);
        }
        this.mNonVisMenu.setState(n, bl);
    }

    public void setState(Integer n, boolean bl) {
        ToolBarBaseItem toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n);
        if (toolBarBaseItem != null && toolBarBaseItem instanceof ToolBarToggleButton) {
            ((ToolBarToggleButton)toolBarBaseItem).setState(bl);
        }
    }

    public void setIcon(Integer n, MenuItemInfo menuItemInfo) {
        Image image = this.buildIcon(menuItemInfo);
        this.setIcon(n, image);
    }

    public void setIcon(Integer n, Image image) {
        ToolBarBaseItem toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n);
        if (toolBarBaseItem != null && toolBarBaseItem instanceof ToolBarButton) {
            ((ToolBarButton)toolBarBaseItem).setIcon(image);
        }
    }

    private boolean isParentEnabled(MenuItemInfo menuItemInfo) {
        boolean bl = true;
        if (menuItemInfo != null) {
            for (MenuItemInfo menuItemInfo2 = menuItemInfo.getParent(); menuItemInfo2 != null; menuItemInfo2 = menuItemInfo2.getParent()) {
                if (menuItemInfo2.isEnabled()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private boolean isParentVisible(MenuItemInfo menuItemInfo) {
        boolean bl = true;
        if (menuItemInfo != null) {
            for (MenuItemInfo menuItemInfo2 = menuItemInfo.getParent(); menuItemInfo2 != null; menuItemInfo2 = menuItemInfo2.getParent()) {
                if (!menuItemInfo2.isHidden()) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void setEnabled(Integer n, boolean bl) {
        MenuItemInfo menuItemInfo = this.mNonVisMenu.getHashItem(n);
        if (menuItemInfo != null) {
            ToolBarBaseItem toolBarBaseItem;
            boolean bl2 = this.isParentEnabled(menuItemInfo);
            if (menuItemInfo.hasSubmenu()) {
                Vector vector = this.mToolBar.isHorizontal() ? this.mNonVisMenu.getHBarItemList() : this.mNonVisMenu.getVBarItemList();
                int n2 = vector.indexOf(menuItemInfo);
                if (n2 >= 0) {
                    this.enableSubmenu(vector, n2, bl && bl2);
                }
            } else if ((bl && bl2 || !bl) && (toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n)) != null) {
                toolBarBaseItem.setEnabled(bl);
            }
        }
    }

    public void setHidden(Integer n, boolean bl) {
        MenuItemInfo menuItemInfo = this.mNonVisMenu.getHashItem(n);
        if (menuItemInfo != null) {
            ToolBarBaseItem toolBarBaseItem;
            boolean bl2 = this.isParentVisible(menuItemInfo);
            if (menuItemInfo.hasSubmenu()) {
                Vector vector = this.mToolBar.isHorizontal() ? this.mNonVisMenu.getHBarItemList() : this.mNonVisMenu.getVBarItemList();
                int n2 = vector.indexOf(menuItemInfo);
                if (n2 >= 0) {
                    this.showSubmenu(vector, n2, this.mToolBar.isHorizontal(), !bl && bl2);
                }
            } else if ((!bl && bl2 || bl) && (toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n)) != null && toolBarBaseItem.isVisible() != !bl) {
                toolBarBaseItem.setVisible(!bl);
                this.mNumVisItems = toolBarBaseItem.isVisible() ? ++this.mNumVisItems : --this.mNumVisItems;
                if (this.mNumVisItems == 0) {
                    this.mToolBar.setVisible(false);
                } else if (this.mNumVisItems == 1) {
                    this.mToolBar.setVisible(true);
                }
            }
        }
    }

    private int enableSubmenu(Vector vector, int n, boolean bl) {
        int n2 = vector.size();
        ++n;
        while (n < n2) {
            ToolBarBaseItem toolBarBaseItem;
            Object e = vector.elementAt(n);
            if (e instanceof EndSubmenu) {
                ++n;
                break;
            }
            MenuItemInfo menuItemInfo = (MenuItemInfo)e;
            if (menuItemInfo.hasSubmenu()) {
                n = this.enableSubmenu(vector, n, bl && menuItemInfo.isEnabled());
                continue;
            }
            int n3 = menuItemInfo.getID();
            if (n3 != 0 && (toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n3)) != null) {
                toolBarBaseItem.setEnabled(bl && menuItemInfo.isEnabled());
            }
            ++n;
        }
        return n;
    }

    private int showSubmenu(Vector vector, int n, boolean bl, boolean bl2) {
        int n2 = vector.size();
        ++n;
        while (n < n2) {
            ToolBarBaseItem toolBarBaseItem;
            Object e = vector.elementAt(n);
            if (e instanceof EndSubmenu) {
                ++n;
                break;
            }
            MenuItemInfo menuItemInfo = (MenuItemInfo)e;
            if (menuItemInfo.hasSubmenu()) {
                n = this.showSubmenu(vector, n, bl, bl2 && !menuItemInfo.isHidden());
                continue;
            }
            int n3 = menuItemInfo.getID();
            if (n3 != 0 && (toolBarBaseItem = (ToolBarBaseItem)this.mIDs.get(n3)) != null) {
                boolean bl3 = true;
                if (menuItemInfo.isHidden() || bl && !menuItemInfo.isOnHBar() || !bl && !menuItemInfo.isOnVBar()) {
                    bl3 = false;
                }
                if (toolBarBaseItem.isVisible() != (bl2 && bl3)) {
                    toolBarBaseItem.setVisible(bl2 && bl3);
                    this.mNumVisItems = toolBarBaseItem.isVisible() ? ++this.mNumVisItems : --this.mNumVisItems;
                    if (this.mNumVisItems == 0) {
                        this.mToolBar.setVisible(false);
                    } else if (this.mNumVisItems == 1) {
                        this.mToolBar.setVisible(true);
                    }
                }
            }
            ++n;
        }
        return n;
    }

    public ToolBar getToolBar() {
        return this.mToolBar;
    }

    public MenuInfo getMenuInfo() {
        return this.mNonVisMenu;
    }

    @Override
    public void toolBarItemActionPerformed(ToolBarEvent toolBarEvent) {
        block32: {
            int n;
            if (this.mDispatcher == null) {
                return;
            }
            if (toolBarEvent.getID() == 2000 && (n = toolBarEvent.getItem().getID()) != 0 && n != -1) {
                int n2 = this.mNonVisMenu.getOrigMenuID(n);
                if (n2 == 0) {
                    n2 = n;
                }
                if (n2 == 32771 || n2 == 32772 || n2 == 32774 || n2 == 32773) {
                    ComponentItem componentItem = this.mNonVisMenu.getDispatcher().getFocusOwner();
                    LWTextComponent lWTextComponent = null;
                    boolean bl = false;
                    if (componentItem != null && componentItem.getView() instanceof LWComponent) {
                        if (componentItem instanceof TextAreaItem) {
                            lWTextComponent = (LWTextArea)((VTextArea)componentItem.getView()).getContent();
                        } else if (componentItem instanceof TextFieldItem) {
                            lWTextComponent = (LWTextField)((Object)componentItem.getView());
                        } else if (componentItem instanceof ComboBoxItem) {
                            lWTextComponent = ((ComboBox)((Object)componentItem.getView())).getLWTextField();
                        }
                    }
                    if (lWTextComponent != null) {
                        if (n2 == 32771) {
                            lWTextComponent.cut();
                            bl = true;
                        } else if (n2 == 32772) {
                            lWTextComponent.copy();
                            bl = true;
                        } else if (n2 == 32774) {
                            lWTextComponent.clear();
                        } else if (n2 == 32773) {
                            lWTextComponent.paste();
                        }
                        if (bl) {
                            boolean bl2 = this.mNonVisMenu.getApplet().isClipboardValidationDisabled();
                            Clipboard clipboard = ClipboardProxy.getSystemClipboard();
                            try {
                                if (!bl2) {
                                    Transferable transferable = clipboard.getContents(lWTextComponent);
                                    if (transferable != null && lWTextComponent.isOKToPaste(transferable)) {
                                        this.mNonVisMenu.doEnablePaste(true);
                                    }
                                    break block32;
                                }
                                this.mNonVisMenu.doEnablePaste(true);
                            }
                            catch (IllegalStateException illegalStateException) {
                                Main main2 = this.mNonVisMenu.getApplet();
                                ClipboardErrorUtils.displayMessage(main2.getErrorMessageGenerator(), main2.getTranslatedPhraseGenerator(), lWTextComponent.getParent(), main2.isAlertDialogAllowed());
                            }
                        }
                    }
                } else if (n2 == 32781) {
                    if (FormPrintableImpl.getPrintJob() == null) {
                        FormPrintableImpl.setPrintJob(PrinterJob.getPrinterJob());
                    }
                    if (FormPrintableImpl.getAttributes() == null) {
                        FormPrintableImpl.setAttributes(new HashPrintRequestAttributeSet());
                    }
                    PrinterJob printerJob = FormPrintableImpl.getPrintJob();
                    PrintRequestAttributeSet printRequestAttributeSet = FormPrintableImpl.getAttributes();
                    PageFormat pageFormat = null;
                    boolean bl = true;
                    pageFormat = printerJob.pageDialog(printRequestAttributeSet);
                } else {
                    StatusBarInterface statusBarInterface;
                    MenuItemInfo menuItemInfo;
                    int n3;
                    if (n2 == 32779 || n2 == 32784 || n2 == 32770) {
                        n3 = 478;
                    } else {
                        if (toolBarEvent.getItem() instanceof ToolBarToggleButton) {
                            this.changeState((ToolBarToggleButton)toolBarEvent.getItem(), ((ToolBarToggleButton)toolBarEvent.getItem()).getState());
                        }
                        n3 = 477;
                    }
                    Message message = new Message(this.mRecipient, n3, (Object)n2);
                    this.mDispatcher.onMessage(message, 0);
                    if (this.mNonVisMenu != null && (menuItemInfo = this.mNonVisMenu.getHashItem(n2)).getHelpText() != null && (statusBarInterface = this.mDispatcher.getCurrentStatusBar()) != null) {
                        statusBarInterface.setStatusBarProperty(10, null);
                    }
                }
            }
        }
    }

    @Override
    public void toolBarItemMouseEntered(ToolBarEvent toolBarEvent) {
        int n = toolBarEvent.getItem().getID();
        if (n != 0 && n != -1) {
            StatusBarInterface statusBarInterface;
            MenuItemInfo menuItemInfo;
            String string;
            int n2 = this.mNonVisMenu.getOrigMenuID(n);
            if (n2 == 0) {
                n2 = n;
            }
            if ((string = (menuItemInfo = this.mNonVisMenu.getHashItem(n2)).getHelpText()) != null && (statusBarInterface = this.mDispatcher.getCurrentStatusBar()) != null) {
                statusBarInterface.setStatusBarProperty(10, string);
            }
        }
    }

    @Override
    public void toolBarItemMouseExited(ToolBarEvent toolBarEvent) {
        int n = toolBarEvent.getItem().getID();
        if (n != 0 && n != -1) {
            StatusBarInterface statusBarInterface;
            MenuItemInfo menuItemInfo;
            int n2 = this.mNonVisMenu.getOrigMenuID(n);
            if (n2 == 0) {
                n2 = n;
            }
            if ((menuItemInfo = this.mNonVisMenu.getHashItem(n2)) != null && menuItemInfo.getHelpText() != null && (statusBarInterface = this.mDispatcher.getCurrentStatusBar()) != null) {
                statusBarInterface.setStatusBarProperty(10, null);
            }
        }
    }

    private String processHelpText(String string) {
        String string2 = string;
        int n = string.lastIndexOf(41);
        if (n != -1 && n == string.length() - 1 && string.charAt(n - 2) == '(') {
            string2 = string.charAt(n - 3) == ' ' ? string.substring(0, n - 3) : string.substring(0, n - 2);
        }
        return string2;
    }
}

