/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import oracle.ewt.EwtComponent;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.access.AccessibleLWComponent;
import oracle.ewt.dataSource.OneDDataSource;
import oracle.ewt.dataSource.OneDDataSourceEvent;
import oracle.ewt.dataSource.OneDDataSourceListener;
import oracle.ewt.dataSource.TwoDDataSource;
import oracle.ewt.dataSource.TwoDDataSourceEvent;
import oracle.ewt.dataSource.TwoDDataSourceListener;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.laf.generic.GenericHeaderItemPainter;
import oracle.ewt.laf.oracle.OracleHeaderItemPainter;
import oracle.ewt.painter.BorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.scrolling.ScrollableException;
import oracle.ewt.util.ImmInsets;
import oracle.ewt.util.LocaleUtils;
import oracle.ewt.util.StringUtils;
import oracle.forms.engine.Runform;

public class ListView
extends EwtComponent
implements TwoDDataSourceListener,
OneDDataSourceListener {
    private final Vector mColumns = new Vector();
    private TwoDDataSource mDataSource;
    private OneDDataSource mHeaderDataSource;
    private int mSelectedRow = -1;
    private int mFocusedRow = 0;
    private int mColumnCount = 0;
    private int mRowCount = 0;
    private int mColumnNumber = -1;
    private Cursor mOldCursor = null;
    private Adjustable mHAdjustable;
    private Adjustable mVAdjustable;
    private int mCanvasHeight;
    private int mHeaderHeight;
    private int mRowHeight = 0;
    private int mRowWidth = 0;
    private int mDefaultColumnWidth = 128;
    private boolean mHeaderVisible = true;
    private BorderPainter mBorderPainter;
    private ImmInsets mBorderInsets;
    private Color mUserForeground = null;
    private Color mUserBackground = null;
    private Color mUserHeaderBackground = null;
    private Color mUserSelectForeground = null;
    private Color mUserSelectBackground = null;
    private Color mSelectForeground;
    private Color mSelectBackground;
    private Color mHeaderBackground;
    private Color mSelectedFocusColor;
    private Color mDefaultForeground = SystemColor.textText;
    private Color mDefaultBackground = SystemColor.text;
    private Object[] mRowData;
    private final Object mRowDataLock = new Object();
    private int mOldInnerWidth = 0;
    private Color mSelectNullFG;
    private Color mNormalNullFG;
    private String mNullText = null;
    private boolean mReadOnly = false;
    private final PaintContext mPaintContext = this.getPaintContext();
    private Font mFont;
    private FontMetrics mFontMetrics;
    private int mFontMaxAdvance;
    private int mFontMaxHeight;
    private int mFontMaxBaseLine;
    private Runform mRunform = null;
    static final int OLAF_FUDGE = 5;
    private static final String ELLIPSIS = "...";

    public ListView(TwoDDataSource twoDDataSource) {
        this(null, twoDDataSource);
    }

    public ListView(OneDDataSource oneDDataSource, TwoDDataSource twoDDataSource) {
        this(oneDDataSource, twoDDataSource, null);
    }

    public ListView(OneDDataSource oneDDataSource, TwoDDataSource twoDDataSource, Runform runform) {
        this.mDataSource = twoDDataSource;
        this.mHeaderDataSource = oneDDataSource;
        this.mRunform = runform;
        long l = 28L;
        this.enableEvents(l);
        if (this.mHeaderDataSource != null) {
            this.mHeaderDataSource.addDataSourceListener(this);
        }
        this.mDataSource.addDataSourceListener(this);
    }

    @Override
    public boolean isClippedBySibling() {
        return true;
    }

    public void setNullText(String string) {
        this.mNullText = string;
        if (this.mNullText.equals("")) {
            this.mNullText = null;
        }
        this.repaintInterior();
    }

    public String getNullText() {
        return this.mNullText;
    }

    public void setReadOnly(boolean bl) {
        if (bl != this.mReadOnly) {
            this.mReadOnly = bl;
            this.repaintInterior();
        }
    }

    public void setColumnAlignment(int n, int n2) {
        this.getColumn((int)n).alignment = n2;
        this.repaintColumns(n, 1);
    }

    public final int getColumnCount() {
        return this.mColumnCount;
    }

    public final int getRowCount() {
        return this.mRowCount;
    }

    public final String getCellData(int n, int n2) {
        Object object = this.mDataSource.getData(n, n2);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public final String getHeaderData(int n) {
        Object object = this.mHeaderDataSource.getData(n);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public final TwoDDataSource getDataSource() {
        return this.mDataSource;
    }

    public void setFocusedRow(int n) {
        if (n != this.mFocusedRow) {
            int n2 = this.mFocusedRow;
            this.mFocusedRow = n;
            this.freezeRepaints();
            try {
                this.repaintRows(n2, 1);
                this.repaintRows(n, 1);
            }
            finally {
                this.unfreezeRepaints();
            }
            AccessibleContext accessibleContext = this.accessAccessibleContext();
            if (accessibleContext != null) {
                Accessible accessible = n2 >= 0 ? accessibleContext.getAccessibleChild(n2) : null;
                Accessible accessible2 = n >= 0 ? accessibleContext.getAccessibleChild(n) : null;
                this.fireAccessiblePropertyChange("AccessibleActiveDescendant", accessible, accessible2);
            }
        }
    }

    public void setSelectedRow(int n) {
        if (n != this.mSelectedRow) {
            int n2 = this.mSelectedRow;
            this.mSelectedRow = n;
            this.freezeRepaints();
            try {
                this.repaintRows(n2, 1);
                this.repaintRows(n, 1);
            }
            finally {
                this.unfreezeRepaints();
            }
            this.fireAccessiblePropertyChange("AccessibleSelection", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public void itemsAdded(OneDDataSourceEvent oneDDataSourceEvent) {
        this.repaintHeader();
    }

    @Override
    public void itemsRemoved(OneDDataSourceEvent oneDDataSourceEvent) {
        this.repaintHeader();
    }

    @Override
    public void invalidateItems(OneDDataSourceEvent oneDDataSourceEvent) {
        this.repaintHeader();
    }

    private void repaintHeader() {
        this.repaintInterior(0, 0, this.getInnerWidth(), this.mHeaderHeight);
    }

    public ImmInsets getColumnInsets() {
        return this.mBorderInsets;
    }

    public final int getFocusedRow() {
        return this.mFocusedRow;
    }

    public final int getSelectedRow() {
        return this.mSelectedRow;
    }

    @Override
    public void setForeground(Color color) {
        this.mUserForeground = color;
        this.updateForeground(this.getUIDefaults());
        this.mNormalNullFG = ListView.blendColors(this.getForeground(), this.getBackground());
        this.repaintInterior();
    }

    @Override
    public void setBackground(Color color) {
        this.mUserBackground = color;
        this.updateBackground(this.getUIDefaults());
        this.mNormalNullFG = ListView.blendColors(this.getForeground(), this.getBackground());
        this.repaintInterior();
    }

    @Override
    public Color getForeground() {
        Color color = super.getForeground();
        if (color == null) {
            color = this.mDefaultForeground;
        }
        return color;
    }

    @Override
    public Color getBackground() {
        Color color = super.getBackground();
        if (color == null) {
            color = this.mDefaultBackground;
        }
        return color;
    }

    public void setHeaderBackground(Color color) {
        this.mUserHeaderBackground = color;
        this.mHeaderBackground = color != null ? color : this.getLookAndFeel().getDefaults(this.mPaintContext).getColor(LookAndFeel.CONTROL);
    }

    public void setSelectForeground(Color color) {
        this.mUserSelectForeground = color;
        this.updateSelectForeground(this.getUIDefaults());
        this.mSelectNullFG = ListView.blendColors(this.mSelectForeground, this.mSelectBackground);
        this.repaintRows(this.mSelectedRow, 1);
    }

    public void setSelectBackground(Color color) {
        this.mUserSelectBackground = color;
        this.updateSelectBackground(this.getUIDefaults());
        this.mSelectNullFG = ListView.blendColors(this.mSelectForeground, this.mSelectBackground);
        this.repaintRows(this.mSelectedRow, 1);
    }

    public void setFirstRowOnScreen(int n) {
        int n2 = this.getCanvasOriginX();
        this.setCanvasOrigin(n2, n * this.mRowHeight);
    }

    private static Color blendColors(Color color, Color color2) {
        return new Color((color.getRed() + color2.getRed()) / 2, (color.getGreen() + color2.getGreen()) / 2, (color.getBlue() + color2.getBlue()) / 2);
    }

    public final Rectangle getExposedCells() {
        if (this.mRowHeight <= 0) {
            return new Rectangle();
        }
        Point point = this.getCanvasOrigin();
        Dimension dimension = this.getInnerSize();
        ImmInsets immInsets = this.getScrollInsets();
        return this.pixelsToCells(immInsets.left - point.x, immInsets.top - point.y, dimension.width - immInsets.left - immInsets.right, dimension.height - immInsets.top - immInsets.bottom);
    }

    public final boolean isRowExposed(int n) {
        Rectangle rectangle = this.getExposedCells();
        return n >= rectangle.y && n < rectangle.y + rectangle.height;
    }

    public void setColumnWidth(int n, int n2) {
        this.freezeRepaints();
        try {
            this.mRowWidth -= this.getActualColumnWidth(n);
            this.getColumn((int)n).width = n2;
            this.mRowWidth += this.getActualColumnWidth(n);
            this.invalidateCanvas();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private Column getColumn(int n) {
        return (Column)this.mColumns.elementAt(n);
    }

    public final int getColumnWidth(int n) {
        return this.getColumn((int)n).width;
    }

    public final int getActualColumnWidth(int n) {
        int n2 = this.getColumnWidth(n);
        if (n2 < 0) {
            n2 = this.getDefaultColumnWidth();
        }
        return n2;
    }

    public void setDefaultColumnWidth(int n) {
        int n2 = (n = Math.max(n, 0)) - this.mDefaultColumnWidth;
        if (n2 == 0) {
            return;
        }
        this.mDefaultColumnWidth = n;
        for (int i = 0; i < this.mColumnCount; ++i) {
            if (this.getColumn((int)i).width >= 0) continue;
            this.mRowWidth += n2;
        }
        this.invalidateCanvas();
    }

    public int getDefaultColumnWidth() {
        return this.mDefaultColumnWidth;
    }

    @Override
    public void setFont(Font font) {
        this.freezeRepaints();
        try {
            Font font2 = this.mFont;
            super.setFont(font);
            this.updateFontMetrics();
            if (font2 != this.mFont) {
                this.invalidateCanvas();
            }
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    @Override
    public final void setVScrollInsets(int n, int n2) {
        throw new IllegalArgumentException("ListView.setVScrollInsets() should never be called.");
    }

    public void setHeaderVisible(boolean bl) {
        this.mHeaderVisible = bl;
        this.updateCanvasHeight();
    }

    private void updateCanvasHeight() {
        int n = this.mCanvasHeight;
        int n2 = this.mHeaderHeight;
        this.mHeaderHeight = this.mHeaderVisible ? this.mFontMaxHeight + this.mBorderInsets.top + this.mBorderInsets.bottom : 0;
        this.mCanvasHeight = this.mRowHeight * this.mRowCount;
        if (this.mRowHeight > 0) {
            this.mCanvasHeight += Math.max(0, this.getInnerHeight() - this.mHeaderHeight) % this.mRowHeight;
        }
        this.mCanvasHeight += this.mHeaderHeight;
        if (this.mCanvasHeight != n || this.mHeaderHeight != n2) {
            this.invalidateCanvas();
        }
    }

    @Override
    protected AccessibleContext createAccessibleContext() {
        return new AccessibleListView();
    }

    @Override
    protected Dimension layoutCanvas() {
        this.updateFontMetrics();
        super.setVScrollInsets(this.mHeaderHeight, 0);
        Point point = this.getCanvasOrigin();
        this.setCanvasOrigin(point.x, point.y);
        return new Dimension(this.mRowWidth, this.mCanvasHeight);
    }

    private void updateFontMetrics() {
        Font font = this.getFont();
        if (font != this.mFont) {
            this.mFont = font;
            this.mFontMetrics = this.getFontMetrics(this.mFont);
            this.mFontMaxAdvance = this.mFontMetrics.getMaxAdvance();
            this.mFontMaxBaseLine = this.mFontMetrics.getLeading() + this.mFontMetrics.getMaxAscent();
            this.mFontMaxHeight = this.mFontMaxBaseLine + this.mFontMetrics.getMaxDescent();
            this.mRowHeight = this.mFontMaxHeight + 2;
            if (this.mVAdjustable != null && this.mRowHeight != 0) {
                this.mVAdjustable.setUnitIncrement(this.mRowHeight);
            }
            this.updateCanvasHeight();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setCanvasSize(int n, int n2) {
        if (this.getActualReadingDirection() == 2) {
            int n3 = this.getCanvasWidth();
            Point point = this.getCanvasOrigin();
            this.freezeRepaints();
            try {
                super.setCanvasSize(n, n2);
                if (n3 != n) {
                    point.x -= n - n3;
                    this.setCanvasOrigin(point.x, point.y);
                } else {
                    Adjustable adjustable = this.getHAdjustable();
                    if (adjustable != null && this.getProxyConfigurer() == null) {
                        adjustable.setValue(this.getHValueOfOffset(this.getCanvasOriginX()));
                    }
                }
            }
            finally {
                this.unfreezeRepaints();
            }
            return;
        }
        super.setCanvasSize(n, n2);
        this.updateCanvasHeight();
    }

    static Rectangle intersect(Rectangle rectangle, int n, int n2, int n3, int n4) {
        rectangle.x = Math.max(n, rectangle.x);
        rectangle.y = Math.max(n2, rectangle.y);
        int n5 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n6 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.width = n5 - rectangle.x;
        rectangle.height = n6 - rectangle.y;
        return rectangle;
    }

    static Rectangle intersect(Rectangle rectangle, Rectangle rectangle2) {
        return ListView.intersect(rectangle, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        Shape shape = graphics.getClip();
        try {
            int n;
            if (shape.getBounds().isEmpty()) {
                return;
            }
            this.updateFontMetrics();
            graphics.setFont(this.mFont);
            ImmInsets immInsets = this.getScrollInsets();
            int n2 = this.getInnerWidth() - immInsets.left - immInsets.right;
            int n3 = this.getInnerHeight() - immInsets.top - immInsets.bottom;
            Point point = this.getCanvasOrigin();
            if (this.mHeaderDataSource != null && immInsets.top > 0) {
                graphics.clipRect(immInsets.left - point.x, -point.y, n2, immInsets.top);
                if (!graphics.getClipBounds().isEmpty()) {
                    graphics.translate(immInsets.left, -point.y);
                    this.paintHeader(graphics);
                    graphics.translate(-immInsets.left, point.y);
                }
                graphics.setClip(shape);
            }
            Rectangle rectangle = shape.getBounds();
            ListView.intersect(rectangle, immInsets.left - point.x, immInsets.top - point.y, n2, n3);
            Rectangle rectangle2 = this.pixelsToCells(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            ListView.intersect(rectangle2, 0, 0, this.mColumnCount, this.mRowCount);
            if (rectangle2.isEmpty()) {
                return;
            }
            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.translate(immInsets.left, immInsets.top);
            int n4 = rectangle2.y + rectangle2.height;
            int n5 = this.mSelectedRow;
            if (rectangle2.y <= n5 && n5 < n4) {
                graphics.setColor(this.mSelectBackground);
                graphics.fillRect(0, n5 * this.mRowHeight, this.mRowWidth, this.mRowHeight);
            }
            this.paintCells(graphics, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            if (this.hasGlobalFocus() && rectangle2.y <= (n = this.mFocusedRow) && n < n4) {
                int n6 = this.mRowHeight * n;
                int n7 = this.mRowWidth - 1;
                int n8 = n6 + this.mRowHeight - 1;
                if (n5 == n) {
                    graphics.setColor(this.mSelectedFocusColor);
                } else {
                    graphics.setColor(this.getForeground());
                }
                GraphicUtils.drawDottedLine(graphics, 0, n6, n7, n6);
                GraphicUtils.drawDottedLine(graphics, n7, n6, n7, n8);
                GraphicUtils.drawDottedLine(graphics, n7, n8, 0, n8);
                GraphicUtils.drawDottedLine(graphics, 0, n8, 0, n6);
            }
        }
        catch (Exception exception) {
        }
        finally {
            graphics.setClip(shape);
        }
    }

    private void paintHeader(Graphics graphics) {
        int n;
        Rectangle rectangle = graphics.getClip().getBounds();
        graphics.setColor(this.mHeaderBackground);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n2 = this.getColumnCount();
        Rectangle rectangle2 = this.pixelsToCells(rectangle.x, 0, rectangle.width, 1);
        Rectangle rectangle3 = this.cellsToPixels(rectangle2.x, 0, rectangle2.width, 1);
        boolean bl = this.getActualReadingDirection() == 2;
        int n3 = rectangle3.x;
        if (bl) {
            n3 += rectangle3.width;
        }
        int n4 = this.getCanvasHeight();
        graphics.setColor(this.getForeground());
        int n5 = LocaleUtils.getAlignmentForReadingDirection(this.getActualReadingDirection());
        int n6 = this.mFontMaxBaseLine + this.mBorderInsets.top;
        Rectangle rectangle4 = graphics.getClipBounds();
        int n7 = rectangle2.x + rectangle2.width;
        for (n = rectangle2.x; n < n7; ++n) {
            int n8;
            int n9 = this.getActualColumnWidth(n);
            if (bl) {
                n3 -= n9;
            }
            if ((n8 = n9 - this.mBorderInsets.left - this.mBorderInsets.right) > 0) {
                int n10 = n3 + this.mBorderInsets.left;
                graphics.clipRect(n10, 0, n8, this.mHeaderHeight);
                try {
                    Object object = this.mHeaderDataSource.getData(n);
                    if (object != null) {
                        ListView.drawString(graphics, this.getColumn((int)n).alignment, n5, object.toString(), n10, n6, n8, this.mPaintContext, this.mFontMetrics);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                graphics.setClip(rectangle4);
            }
            this.mBorderPainter.paint(this.mPaintContext, graphics, n3, 0, n9, this.mHeaderHeight);
            if (bl) continue;
            n3 += n9;
        }
        n = rectangle.width + this.mBorderInsets.left + this.mBorderInsets.right;
        if (bl) {
            n3 = -n;
        }
        this.mBorderPainter.paint(this.mPaintContext, graphics, n3, 0, n, this.mHeaderHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintCells(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        Object[] objectArray;
        int n6;
        int n7 = 0;
        for (n6 = 0; n6 < n; ++n6) {
            n7 += this.getActualColumnWidth(n6);
        }
        int n8 = n6 = this.getActualReadingDirection() == 2 ? 1 : 0;
        if (n6 != 0) {
            n7 = this.mRowWidth - n7;
        }
        int n9 = LocaleUtils.getAlignmentForReadingDirection(this.getActualReadingDirection());
        Color color = this.getForeground();
        String string = this.mNullText;
        Object object = this.mRowDataLock;
        synchronized (object) {
            objectArray = this.mRowData;
            this.mRowData = null;
        }
        if (objectArray == null || objectArray.length < this.mColumnCount) {
            objectArray = new Object[this.mColumnCount];
        }
        object = graphics.getClip();
        try {
            for (n5 = n2; n5 < n2 + n4; ++n5) {
                int n10;
                int n11 = this.mRowHeight * n5;
                boolean bl = false;
                for (n10 = 0; n10 < this.mColumnCount; ++n10) {
                    objectArray[n10] = this.mDataSource.getData(n10, n5);
                    if (objectArray[n10] != null) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    if (string == null) continue;
                    if (n5 == this.mSelectedRow) {
                        graphics.setColor(this.mSelectNullFG);
                    } else {
                        graphics.setColor(this.mNormalNullFG);
                    }
                    n10 = this.mRowWidth - this.mBorderInsets.left - this.mBorderInsets.right;
                    graphics.clipRect(this.mBorderInsets.left, 0, n10, this.mCanvasHeight);
                    ListView.drawString(graphics, n9, n9, string, this.mBorderInsets.left, n11 + this.mFontMaxBaseLine + 1, n10, this.mPaintContext, this.mFontMetrics);
                    graphics.setClip((Shape)object);
                    if (this.mRunform == null || this.mRunform.getLOVRowLineColor() == null) continue;
                    Color color2 = graphics.getColor();
                    graphics.setColor(this.mRunform.getLOVRowLineColor());
                    GraphicUtils.drawDottedLine(graphics, 0, n11 + this.mRowHeight - 1, this.mRowWidth, n11 + this.mRowHeight - 1);
                    graphics.setColor(color2);
                    continue;
                }
                if (n5 == this.mSelectedRow) {
                    graphics.setColor(this.mSelectForeground);
                } else {
                    graphics.setColor(color);
                }
                n10 = n7;
                for (int i = n; i < n + n3; ++i) {
                    int n12;
                    int n13 = this.getActualColumnWidth(i);
                    if (n6 != 0) {
                        n10 -= n13;
                    }
                    if ((n12 = n13 - this.mBorderInsets.left - this.mBorderInsets.right) > 0) {
                        int n14 = n10 + this.mBorderInsets.left;
                        int n15 = this.getColumn((int)i).alignment;
                        graphics.clipRect(n14, 0, n12, this.mRowHeight * (n2 + n4));
                        String string2 = objectArray[i].toString();
                        if (string2 != null) {
                            ListView.drawString(graphics, n15, n9, string2, n14, n11 + this.mFontMaxBaseLine + 1, n12, this.mPaintContext, this.mFontMetrics);
                        }
                        graphics.setClip((Shape)object);
                        if (this.mRunform != null && this.mRunform.getLOVRowLineColor() != null) {
                            Color color3 = graphics.getColor();
                            graphics.setColor(this.mRunform.getLOVRowLineColor());
                            GraphicUtils.drawDottedLine(graphics, 0, n11 + this.mRowHeight - 1, this.mRowWidth, n11 + this.mRowHeight - 1);
                            graphics.setColor(color3);
                        }
                    }
                    if (n6 != 0) continue;
                    n10 += n13;
                }
            }
        }
        finally {
            graphics.setClip((Shape)object);
        }
        for (n5 = 0; n5 < this.mColumnCount; ++n5) {
            objectArray[n5] = null;
        }
        Object object2 = this.mRowDataLock;
        synchronized (object2) {
            this.mRowData = objectArray;
        }
    }

    @Override
    public void rowsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getRowStartIndex();
        int n2 = twoDDataSourceEvent.getRowCount();
        this.mRowCount += n2;
        this.updateCanvasHeight();
        this.repaintRows(n, this.mRowCount - n);
    }

    @Override
    public void rowsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getRowStartIndex();
        int n2 = twoDDataSourceEvent.getRowCount();
        this.mRowCount -= n2;
        this.updateCanvasHeight();
        this.repaintRows(n, this.mRowCount - n);
    }

    @Override
    public void invalidateRows(TwoDDataSourceEvent twoDDataSourceEvent) {
        this.repaintRows(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
    }

    @Override
    public void columnsAdded(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getColumnStartIndex();
        int n2 = twoDDataSourceEvent.getColumnCount();
        this.mColumnCount += n2;
        for (int i = 0; i < n2; ++i) {
            this.mColumns.insertElementAt(new Column(), n);
        }
        this.mRowWidth += n2 * this.mDefaultColumnWidth;
        this.invalidateCanvas();
    }

    @Override
    public void columnsRemoved(TwoDDataSourceEvent twoDDataSourceEvent) {
        int n = twoDDataSourceEvent.getColumnStartIndex();
        int n2 = twoDDataSourceEvent.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            this.mRowWidth -= this.getActualColumnWidth(n);
            this.mColumns.removeElementAt(n);
        }
        this.mColumnCount -= n2;
        this.invalidateCanvas();
    }

    @Override
    public void invalidateColumns(TwoDDataSourceEvent twoDDataSourceEvent) {
        this.repaintInterior();
    }

    @Override
    public void invalidateCells(TwoDDataSourceEvent twoDDataSourceEvent) {
        this.repaintRows(twoDDataSourceEvent.getRowStartIndex(), twoDDataSourceEvent.getRowCount());
    }

    @Override
    public void attachHAdjustable(Adjustable adjustable) throws ScrollableException {
        this.mHAdjustable = adjustable;
    }

    @Override
    public void attachVAdjustable(Adjustable adjustable) throws ScrollableException {
        this.mVAdjustable = adjustable;
        if (this.mRowHeight != 0) {
            this.mVAdjustable.setUnitIncrement(this.mRowHeight);
        }
    }

    @Override
    public void detachAdjustable(Adjustable adjustable) throws ScrollableException {
        if (this.mHAdjustable == adjustable) {
            this.mHAdjustable = null;
        } else if (this.mVAdjustable == adjustable) {
            this.mVAdjustable = null;
        }
    }

    @Override
    public Adjustable getHAdjustable() {
        return this.mHAdjustable;
    }

    @Override
    public Adjustable getVAdjustable() {
        return this.mVAdjustable;
    }

    @Override
    public boolean isHScrollable() {
        return true;
    }

    @Override
    public boolean isVScrollable() {
        return true;
    }

    @Override
    public void handleVScroll(int n, int n2) throws ScrollableException {
        try {
            Point point = this.getCanvasOrigin();
            int n3 = this.getPageHeight();
            this.setCanvasOrigin(point.x, this.getScrollAmount(n, n2, point.y, this.mRowHeight, n3));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int getPageHeight() {
        ImmInsets immInsets = this.getScrollInsets();
        int n = this.getInnerHeight() - immInsets.top - immInsets.bottom;
        return Math.max(this.mRowHeight, n - n % this.mRowHeight);
    }

    @Override
    public void handleHScroll(int n, int n2) throws ScrollableException {
        Point point = this.getCanvasOrigin();
        ImmInsets immInsets = this.getScrollInsets();
        this.setCanvasOrigin(this.getScrollAmount(n, n2, point.x, this.mFontMaxAdvance, this.getInnerWidth() - immInsets.left - immInsets.right), point.y);
    }

    private int getScrollAmount(int n, int n2, int n3, int n4, int n5) throws ScrollableException {
        switch (n2) {
            case 1: {
                n3 += n4;
                break;
            }
            case 0: {
                n3 -= n4;
                break;
            }
            case 3: {
                n3 += n5;
                break;
            }
            case 2: {
                n3 -= n5;
                break;
            }
            case 4: {
                n3 = -n;
                break;
            }
            default: {
                throw new ScrollableException("Unknown action: " + n2 + " passed to ListView.getScrollAmount()");
            }
        }
        return n3;
    }

    @Override
    public void setCanvasOrigin(int n, int n2) {
        boolean bl;
        ImmInsets immInsets = this.getScrollInsets();
        if (this.mRowHeight > 0 && n2 < 0) {
            n2 = (this.mRowHeight / 2 - n2) / this.mRowHeight * -this.mRowHeight;
        }
        n2 = Math.min(Math.max(n2, this.getInnerHeight() - this.mCanvasHeight), 0);
        int n3 = this.getInnerWidth();
        boolean bl2 = bl = this.getActualReadingDirection() == 2;
        if (bl) {
            if (n3 != this.mOldInnerWidth) {
                n = n3 - this.mRowWidth;
            }
            this.mOldInnerWidth = n3;
        }
        int n4 = 0;
        int n5 = n3 - this.mRowWidth;
        if (bl && n5 > 0) {
            n4 = n5;
        }
        n = Math.min(n4, Math.max(n5, n));
        super.setCanvasOrigin(n, n2);
    }

    private void repaintRows(int n, int n2) {
        if (this.isVisible()) {
            if (this.mFont == null) {
                this.invalidateCanvas();
            } else {
                ImmInsets immInsets = this.getScrollInsets();
                this.repaintCanvas(0, immInsets.top + n * this.mRowHeight, this.mRowWidth, n2 * this.mRowHeight);
            }
        }
    }

    private void repaintColumns(int n, int n2) {
        this.repaintCells(n, n2, 0, this.mRowCount);
    }

    private void repaintCells(int n, int n2, int n3, int n4) {
        if (this.isVisible()) {
            if (this.mFont == null) {
                this.invalidateCanvas();
            } else {
                Rectangle rectangle = this.cellsToPixels(n, n3, n2, n4);
                this.repaintCanvas(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    Rectangle cellsToPixels(int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        for (n5 = 0; n5 < n; ++n5) {
            n6 += this.getActualColumnWidth(n5);
        }
        n5 = 0;
        if (n3 > 0) {
            for (int i = n; i < n + n3; ++i) {
                n5 += this.getActualColumnWidth(i);
            }
        }
        if (this.getActualReadingDirection() == 2) {
            n6 = this.mRowWidth - n6 - n5;
        }
        ImmInsets immInsets = this.getScrollInsets();
        return new Rectangle(n6 + immInsets.left, n2 * this.mRowHeight + immInsets.top, n5, n4 * this.mRowHeight);
    }

    Rectangle pixelsToCells(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        ImmInsets immInsets = this.getScrollInsets();
        n -= immInsets.left;
        n2 -= immInsets.top;
        if (this.getActualReadingDirection() == 2) {
            n = this.mRowWidth - n - n3;
        }
        int n7 = this.mColumnCount;
        int n8 = 0;
        for (n6 = 0; n6 < this.mColumnCount; ++n6) {
            if ((n8 += this.getActualColumnWidth(n6)) <= n) continue;
            n7 = n6;
            break;
        }
        n6 = 0;
        if (n3 <= 0) {
            n6 = 0;
        } else {
            n3 = n + n3 - n8;
            n6 = 1;
            for (n5 = n7 + 1; n3 > 0 && n5 < this.mColumnCount; n3 -= this.getActualColumnWidth(n5), ++n5) {
                ++n6;
            }
        }
        n5 = n2 / this.mRowHeight;
        int n9 = (n2 + n4 - 1) / this.mRowHeight - n5 + 1;
        return new Rectangle(n7, n5, n6, n9);
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }

    static void drawString(Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, PaintContext paintContext, FontMetrics fontMetrics) {
        int n6;
        String string2 = StringUtils.getDisplayString(string, paintContext);
        int n7 = fontMetrics.stringWidth(string2);
        if (n7 > (n6 = n5)) {
            int n8 = fontMetrics.stringWidth(ELLIPSIS);
            int n9 = n;
            if ((float)n9 == 1.0f || (float)n2 != 0.0f && paintContext.getReadingDirection() == 2) {
                int n10 = 0;
                int n11 = string2.length();
                for (int i = n6 - n8 - n7; i < 0; i += fontMetrics.charWidth(string2.charAt(n10++))) {
                    if (n10 != n11) continue;
                }
                string2 = string2.charAt(0) == '\u202d' ? "\u202d..." + string2.substring(n10) : ELLIPSIS + string2.substring(n10);
            } else {
                int n12 = -1;
                int n13 = string2.length();
                for (int i = n6 - n8; i > 0 && ++n12 != n13; i -= fontMetrics.charWidth(string2.charAt(n12))) {
                }
                if (n12 < 0) {
                    n12 = 0;
                }
                string2 = string2.substring(0, n12) + ELLIPSIS;
            }
        } else {
            if (n == 0) {
                n = n2;
            }
            switch (n) {
                case 2: {
                    n3 += n5 - n7;
                    break;
                }
                case 3: {
                    n3 += (n5 - n7) / 2;
                }
            }
        }
        GraphicUtils.drawString(graphics, string2, n3, n4);
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (this.isEnabled() && !mouseEvent.isConsumed()) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.requestFocus();
                    if (this.mRowHeight <= 0) break;
                    Point point = mouseEvent.getPoint();
                    Rectangle rectangle = this.getInnerBounds();
                    ImmInsets immInsets = this.getScrollInsets();
                    rectangle.x += immInsets.left;
                    rectangle.y += immInsets.top;
                    rectangle.width -= immInsets.left + immInsets.right;
                    rectangle.height -= immInsets.top + immInsets.bottom;
                    if (!rectangle.contains(point)) break;
                    Point point2 = this.getCanvasOrigin();
                    point.translate(immInsets.left - rectangle.x - point2.x, immInsets.top - rectangle.y - point2.y);
                    int n = (point.y - immInsets.top) / this.mRowHeight;
                    if (n < 0 || n >= this.mRowCount || point.x < immInsets.left || point.x >= this.mRowWidth - immInsets.left - immInsets.right) break;
                    this.userSetFocus(n);
                    mouseEvent.consume();
                    break;
                }
            }
        }
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        switch (mouseEvent.getID()) {
            case 506: {
                this.handleMouseDragged(mouseEvent);
                break;
            }
            case 503: {
                this.handleMouseMoved(mouseEvent);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (this.isEnabled() && !keyEvent.isConsumed() && keyEvent.getID() == 401) {
            Point point = this.getCanvasOrigin();
            boolean bl = false;
            int n = this.mFocusedRow;
            int n2 = 0;
            int n3 = this.mRowCount;
            ImmInsets immInsets = this.getScrollInsets();
            if (this.mRowHeight > 0) {
                n2 = this.getExposedCells().y;
                n3 = (this.getInnerHeight() - immInsets.top - immInsets.bottom) / this.mRowHeight;
            }
            int n4 = Math.max(n2 + n3 - 1, n2);
            int n5 = n;
            boolean bl2 = true;
            switch (keyEvent.getKeyCode()) {
                case 33: {
                    if (n == n4) {
                        n = n2;
                    }
                    if (n3 <= 1) {
                        --n5;
                        break;
                    }
                    if (n == n2) {
                        n5 = n - n3 + 1;
                        break;
                    }
                    n5 = n2;
                    break;
                }
                case 34: {
                    if (n3 <= 1) {
                        ++n5;
                        break;
                    }
                    if (n == n4) {
                        n5 = n + n3 - 1;
                        break;
                    }
                    n5 = n4;
                    break;
                }
                case 35: {
                    n5 = this.mRowCount - 1;
                    break;
                }
                case 36: {
                    n5 = 0;
                    break;
                }
                case 37: {
                    point.x += this.mFontMaxAdvance;
                    bl = true;
                    break;
                }
                case 38: {
                    --n5;
                    break;
                }
                case 39: {
                    point.x -= this.mFontMaxAdvance;
                    bl = true;
                    break;
                }
                case 40: {
                    ++n5;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            if (bl2) {
                keyEvent.consume();
            }
            if (n5 != n) {
                if ((n5 = Math.max(Math.min(n5, this.mRowCount - 1), 0)) < n2) {
                    point.y += this.mRowHeight * (n2 - n5);
                    bl = true;
                } else if (n4 < n5) {
                    point.y -= this.mRowHeight * (n5 - n4);
                    bl = true;
                } else if (n5 == n4) {
                    point.y += this.mRowHeight * (n2 - n4);
                    bl = true;
                }
            }
            this.freezeRepaints();
            try {
                if (bl) {
                    this.setCanvasOrigin(point.x, point.y);
                }
                this.userSetFocus(n5);
            }
            finally {
                this.unfreezeRepaints();
            }
        }
    }

    private void handleMouseMoved(MouseEvent mouseEvent) {
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        this.mColumnNumber = this.getResizeableColumn(point.x);
        if (this.mColumnNumber >= 0) {
            this.mOldCursor = this.getCursor();
            Cursor cursor = Cursor.getPredefinedCursor(10);
            this.setCursor(cursor);
        } else {
            Cursor cursor = Cursor.getDefaultCursor();
            if (this.mOldCursor == Cursor.getPredefinedCursor(3)) {
                this.setCursor(this.mOldCursor);
            } else {
                this.setCursor(cursor);
            }
        }
    }

    private void handleMouseDragged(MouseEvent mouseEvent) {
        Point point = this.convertOuterToCanvas(mouseEvent.getX(), mouseEvent.getY());
        int n = 0;
        if (this.mColumnNumber >= 0 && this.getColumn((int)this.mColumnNumber).isResizeable) {
            for (int i = this.mColumnNumber - 1; i >= 0; --i) {
                n += this.getColumn((int)i).width;
            }
            int n2 = this.getActualReadingDirection() == 2 ? this.getCanvasWidth() - point.x - n : point.x - n;
            if (n2 > 0) {
                this.setColumnWidth(this.mColumnNumber, n2);
            }
        }
    }

    private int getResizeableColumn(int n) {
        int n2 = 0;
        int n3 = this.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            n2 += this.getColumn((int)i).width;
            if (this.getActualReadingDirection() == 2) {
                if (n2 == this.getCanvasWidth() - n) {
                    this.getColumn((int)i).isResizeable = true;
                    return i;
                }
            } else if (n2 == n) {
                this.getColumn((int)i).isResizeable = true;
                return i;
            }
            this.getColumn((int)i).isResizeable = false;
        }
        return -1;
    }

    private void userSetFocus(int n) {
        if (this.mFocusedRow != n) {
            this.freezeRepaints();
            try {
                if (!this.mReadOnly) {
                    this.setSelectedRow(n);
                }
                this.setFocusedRow(n);
            }
            finally {
                this.unfreezeRepaints();
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        boolean bl = this.hasGlobalFocus();
        super.processFocusEvent(focusEvent);
        if (bl != this.hasGlobalFocus()) {
            this.repaintRows(this.mFocusedRow, 1);
        }
    }

    @Override
    protected void updateUI(LookAndFeel lookAndFeel) {
        super.updateUI(lookAndFeel);
        UIDefaults uIDefaults = lookAndFeel.getDefaults(this.mPaintContext);
        if (this.mUserForeground == null || this.mUserBackground == null) {
            this.updateForeground(uIDefaults);
            this.updateBackground(uIDefaults);
            this.mNormalNullFG = ListView.blendColors(this.getForeground(), this.getBackground());
        }
        if (this.mUserHeaderBackground == null) {
            this.mHeaderBackground = uIDefaults.getColor(LookAndFeel.CONTROL);
        }
        if (this.mUserSelectForeground == null || this.mUserSelectBackground == null) {
            this.updateSelectForeground(uIDefaults);
            this.updateSelectBackground(uIDefaults);
            this.mSelectNullFG = ListView.blendColors(this.mSelectForeground, this.mSelectBackground);
        }
        this.mSelectedFocusColor = uIDefaults.getColor(LookAndFeel.SELECTED_FOCUS);
        if (lookAndFeel.getName().equalsIgnoreCase("Oracle")) {
            this.mBorderPainter = new OracleHeaderItemPainter(true, false, false);
            this.mBorderInsets = this.mBorderPainter.getInsets(this.mPaintContext);
            this.mBorderInsets = new ImmInsets(this.mBorderInsets.top, this.mBorderInsets.left + 5, this.mBorderInsets.bottom, this.mBorderInsets.right + 5);
        } else {
            this.mBorderPainter = new GenericHeaderItemPainter();
            this.mBorderInsets = this.mBorderPainter.getInsets(this.mPaintContext);
        }
        this.freezeRepaints();
        try {
            if (this.mFont == null) {
                this.updateFontMetrics();
            }
            this.updateCanvasHeight();
            this.repaintInterior();
        }
        finally {
            this.unfreezeRepaints();
        }
    }

    private void updateForeground(UIDefaults uIDefaults) {
        this.mDefaultForeground = uIDefaults.getColor(LookAndFeel.TEXT_TEXT);
        if (this.mUserForeground == null) {
            super.setForeground(this.mDefaultForeground);
        }
    }

    private void updateBackground(UIDefaults uIDefaults) {
        this.mDefaultBackground = uIDefaults.getColor(LookAndFeel.TEXT);
        if (this.mUserBackground == null) {
            super.setBackground(this.mDefaultBackground);
        }
    }

    private void updateSelectForeground(UIDefaults uIDefaults) {
        if (this.mUserSelectForeground == null) {
            this.mSelectForeground = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT);
        }
    }

    private void updateSelectBackground(UIDefaults uIDefaults) {
        if (this.mUserSelectBackground == null) {
            this.mSelectBackground = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        }
    }

    private void fireAccessiblePropertyChange(String string, Object object, Object object2) {
        AccessibleContext accessibleContext = this.accessAccessibleContext();
        if (accessibleContext != null) {
            accessibleContext.firePropertyChange(string, object, object2);
        }
    }

    private static class Column {
        int width = -1;
        int alignment = 0;
        boolean isResizeable = false;

        private Column() {
        }
    }

    private class AccessibleListView
    extends AccessibleLWComponent
    implements AccessibleSelection {
        AccessibleListView() {
            super(ListView.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return ListView.this.getRowCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n >= 0 && n < ListView.this.getRowCount()) {
                return new AccessibleListViewChild(n);
            }
            return null;
        }

        @Override
        public final AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public final int getAccessibleSelectionCount() {
            if (ListView.this.getSelectedRow() < 0) {
                return 0;
            }
            return 1;
        }

        @Override
        public final Accessible getAccessibleSelection(int n) {
            if (n != 0) {
                return null;
            }
            int n2 = ListView.this.getSelectedRow();
            if (n2 < 0) {
                return null;
            }
            return this.getAccessibleChild(n2);
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            return n == ListView.this.getSelectedRow() && n >= 0;
        }

        @Override
        public void addAccessibleSelection(int n) {
            ListView.this.setSelectedRow(n);
        }

        @Override
        public void removeAccessibleSelection(int n) {
            if (n == ListView.this.getSelectedRow()) {
                ListView.this.setSelectedRow(-1);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            ListView.this.setSelectedRow(-1);
        }

        @Override
        public void selectAllAccessibleSelection() {
        }

        private class AccessibleListViewChild
        extends AccessibleContext
        implements Accessible {
            private final int mRow;

            AccessibleListViewChild(int n) {
                this.mRow = n;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                int n = ListView.this.getColumnCount();
                try {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < n; ++i) {
                        String string = ListView.this.getHeaderData(i);
                        String string2 = ListView.this.getCellData(i, this.mRow);
                        if (string == null || string2 == null) {
                            return ListView.this.getNullText();
                        }
                        stringBuffer.append(string.toString());
                        stringBuffer.append(':');
                        stringBuffer.append(string2.toString());
                        if (i >= n - 1) continue;
                        stringBuffer.append("\t");
                    }
                    return stringBuffer.toString();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return ListView.this.getNullText();
                }
            }

            @Override
            public void setAccessibleName(String string) {
            }

            @Override
            public Accessible getAccessibleParent() {
                return ListView.this;
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.LABEL;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleStateSet accessibleStateSet;
                AccessibleStateSet accessibleStateSet2 = new AccessibleStateSet();
                accessibleStateSet2.add(AccessibleState.SELECTABLE);
                accessibleStateSet2.add(AccessibleState.FOCUSABLE);
                accessibleStateSet2.add(AccessibleState.TRANSIENT);
                accessibleStateSet2.add(AccessibleState.VISIBLE);
                accessibleStateSet2.add(AccessibleState.SINGLE_LINE);
                if (AccessibleListView.this.isEnabled()) {
                    accessibleStateSet2.add(AccessibleState.ENABLED);
                }
                if (ListView.this.getSelectedRow() == this.mRow) {
                    accessibleStateSet2.add(AccessibleState.SELECTED);
                }
                if (ListView.this.getFocusedRow() == this.mRow) {
                    accessibleStateSet2.add(AccessibleState.ACTIVE);
                    if (ListView.this.hasGlobalFocus()) {
                        accessibleStateSet2.add(AccessibleState.FOCUSED);
                    }
                }
                if ((accessibleStateSet = AccessibleListView.this.getAccessibleStateSet()).contains(AccessibleState.SHOWING) && ListView.this.isRowExposed(this.mRow)) {
                    accessibleStateSet2.add(AccessibleState.SHOWING);
                }
                return accessibleStateSet2;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.mRow;
            }

            @Override
            public int getAccessibleChildrenCount() {
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int n) {
                return null;
            }

            @Override
            public Locale getLocale() throws IllegalComponentStateException {
                return AccessibleListView.this.getLocale();
            }
        }
    }
}

