/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.painter.AbstractBorderPainter;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;
import oracle.ewt.util.ImmInsets;

public class GenericBorderPainter
extends AbstractBorderPainter {
    private static final ImmInsets _SMALL_INSETS = new ImmInsets(1, 1, 1, 1);
    private static final ImmInsets _NORMAL_INSETS = new ImmInsets(2, 2, 2, 2);
    private boolean _isSmall;
    private int _bevel;

    public GenericBorderPainter() {
        this(null, 2, false);
    }

    public GenericBorderPainter(int n) {
        this(null, n, false);
    }

    public GenericBorderPainter(Painter painter, int n, boolean bl) {
        super(painter);
        this._bevel = n;
        this._isSmall = bl;
        if (this._bevel == 3) {
            this._isSmall = true;
        }
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext paintContext) {
        if (this._isSmall) {
            return _SMALL_INSETS;
        }
        return _NORMAL_INSETS;
    }

    @Override
    protected void paintBorder(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color = graphics.getColor();
        int n5 = n + n3 - 1;
        int n6 = n2 + n4 - 1;
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_SHADOW);
        Color color4 = uIDefaults.getColor(LookAndFeel.CONTROL_HIGHLIGHT);
        Color color5 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        if (this._bevel == 1) {
            if (this._isSmall) {
                Color color6 = color2;
                color2 = color3;
                color3 = color6;
            } else {
                Color color7 = color2;
                color2 = color5;
                color5 = color7;
                color7 = color3;
                color3 = color4;
                color4 = color7;
            }
        } else if (this._bevel == 3) {
            color2 = color5;
            color3 = color5;
        }
        graphics.setColor(color2);
        graphics.drawLine(n, n6, n5, n6);
        graphics.drawLine(n5, n2, n5, n6);
        graphics.setColor(color3);
        graphics.drawLine(n, n2, --n5, n2);
        graphics.drawLine(n, n2, n, --n6);
        if (!this._isSmall) {
            graphics.setColor(color4);
            graphics.drawLine(++n, n6, n5, n6);
            graphics.drawLine(n5, ++n2, n5, n6);
            graphics.setColor(color5);
            graphics.drawLine(n, n2, --n5, n2);
            graphics.drawLine(n, n2, n, --n6);
        }
        graphics.setColor(color);
    }

    @Override
    public int getRepaintFlags(PaintContext paintContext) {
        return super.getRepaintFlags(paintContext) | 1 | 0x80;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext paintContext) {
        return false;
    }
}

