/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.ColorUtils;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.laf.basic.ProgressBarPainter;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class FormsProgressPainter
extends ProgressBarPainter {
    private static Painter _sVerticalColorLabelInstance;
    private static Painter _sHorizontalColorLabelInstance;
    private static Painter _sVerticalColorBarInstance;
    private static Painter _sHorizontalColorBarInstance;
    private boolean mVertical = false;
    private boolean mColorBar = false;
    private int mDarkLuminance = 0;

    protected FormsProgressPainter(boolean bl, boolean bl2, int n) {
        this.mVertical = bl;
        this.mColorBar = bl2;
        this.mDarkLuminance = n;
    }

    public static Painter getPainter(boolean bl, boolean bl2, int n) {
        if (bl) {
            if (bl2) {
                if (_sVerticalColorBarInstance == null) {
                    _sVerticalColorBarInstance = new FormsProgressPainter(true, true, n);
                }
                return _sVerticalColorBarInstance;
            }
            if (_sVerticalColorLabelInstance == null) {
                _sVerticalColorLabelInstance = new FormsProgressPainter(true, false, n);
            }
            return _sVerticalColorLabelInstance;
        }
        if (bl2) {
            if (_sHorizontalColorBarInstance == null) {
                _sHorizontalColorBarInstance = new FormsProgressPainter(false, true, n);
            }
            return _sHorizontalColorBarInstance;
        }
        if (_sHorizontalColorLabelInstance == null) {
            _sHorizontalColorLabelInstance = new FormsProgressPainter(false, false, n);
        }
        return _sHorizontalColorLabelInstance;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        String string;
        int n5;
        Color color = graphics.getColor();
        StringRangeModel stringRangeModel = this.getModel(paintContext);
        double d = this.getPercent(stringRangeModel);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        Color color2 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        Color color3 = uIDefaults.getColor(LookAndFeel.TEXT_TEXT);
        Color color4 = this.mColorBar ? color : color2;
        int n6 = n5 = this.mVertical ? (int)((double)n4 * d) : (int)((double)n3 * d);
        if (n5 > 0) {
            graphics.setColor(color4);
            if (this.mVertical) {
                graphics.fillRect(n, n4 - n5, n3, n4);
            } else {
                graphics.fillRect(n, n2, n + n5, n4);
            }
            graphics.setColor(color);
        }
        if ((string = stringRangeModel.getStringValue(paintContext.getPaintLocale())) != null) {
            FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
            int n7 = fontMetrics.stringWidth(string);
            int n8 = (n3 - n7) / 2;
            if (n8 < 0) {
                n8 = 0;
            }
            int n9 = fontMetrics.getAscent();
            int n10 = (n4 - (n9 + fontMetrics.getDescent())) / 2 + n9;
            if (this.mVertical && n5 > n4 - n10 || !this.mVertical && n5 > n8) {
                boolean bl;
                if (!this.mColorBar) {
                    boolean bl2 = ColorUtils.getApproximateLuminance(color) < this.mDarkLuminance;
                    boolean bl3 = bl = ColorUtils.getApproximateLuminance(color2) < this.mDarkLuminance;
                    if (bl2 != bl) {
                        graphics.setColor(color);
                    } else if (bl2) {
                        graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                    } else {
                        graphics.setColor(color3);
                    }
                } else if (this.mColorBar && ColorUtils.getApproximateLuminance(color) < this.mDarkLuminance) {
                    graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                } else {
                    graphics.setColor(color3);
                }
                if (this.mVertical && n5 < n4 - n10 + n9 || !this.mVertical && n5 < n8 + n7) {
                    Shape shape = graphics.getClip();
                    if (this.mVertical) {
                        graphics.clipRect(n, n2 + n4 - n5, n3, n4);
                    } else {
                        graphics.clipRect(n, n2, n5, n4);
                    }
                    GraphicUtils.drawString(graphics, string, n + n8, n2 + n10);
                    graphics.setClip(shape);
                    if (!this.mColorBar) {
                        boolean bl4;
                        bl = ColorUtils.getApproximateLuminance(color) < this.mDarkLuminance;
                        boolean bl5 = bl4 = ColorUtils.getApproximateLuminance(paintContext.getPaintBackground()) < this.mDarkLuminance;
                        if (bl != bl4) {
                            graphics.setColor(color);
                        } else if (bl) {
                            graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                        } else {
                            graphics.setColor(color3);
                        }
                    } else if (ColorUtils.getApproximateLuminance(paintContext.getPaintBackground()) < this.mDarkLuminance) {
                        graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                    } else {
                        graphics.setColor(color3);
                    }
                    if (this.mVertical) {
                        graphics.clipRect(n, n2, n3, n4 - n5);
                    } else {
                        graphics.clipRect(n + n5, n2, n3 - n5, n4);
                    }
                    GraphicUtils.drawString(graphics, string, n + n8, n2 + n10);
                    graphics.setClip(shape);
                    graphics.setColor(color);
                } else {
                    GraphicUtils.drawString(graphics, string, n + n8, n2 + n10);
                    graphics.setColor(color);
                }
            } else {
                if (!this.mColorBar) {
                    boolean bl;
                    boolean bl6 = ColorUtils.getApproximateLuminance(color) < this.mDarkLuminance;
                    boolean bl7 = bl = ColorUtils.getApproximateLuminance(paintContext.getPaintBackground()) < this.mDarkLuminance;
                    if (bl6 != bl) {
                        graphics.setColor(color);
                    } else if (bl6) {
                        graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                    } else {
                        graphics.setColor(color3);
                    }
                } else if (ColorUtils.getApproximateLuminance(paintContext.getPaintBackground()) < this.mDarkLuminance) {
                    graphics.setColor(uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT_TEXT));
                } else {
                    graphics.setColor(color3);
                }
                GraphicUtils.drawString(graphics, string, n + n8, n2 + n10);
                graphics.setColor(color);
            }
        }
    }
}

