/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.graphics.GraphicUtils;
import oracle.ewt.laf.basic.ProgressBarPainter;
import oracle.ewt.meter.StringRangeModel;
import oracle.ewt.painter.PaintContext;
import oracle.ewt.painter.Painter;

public class FormsGaugePainter
extends ProgressBarPainter {
    private static final int _NUM_TICKS = 8;
    private static final int _TICK_LENGTH = 5;
    private static final int _EXTRA_BORDER = 6;
    private static final int _MIN_PREFERRED_SIZE = 50;
    private static FormsGaugePainter _sFullColorGaugeInstance;
    private static FormsGaugePainter _sHalfColorGaugeInstance;
    private static FormsGaugePainter _sFullColorLabelInstance;
    private static FormsGaugePainter _sHalfColorLabelInstance;
    private boolean mHalfdial = false;
    private boolean mColorGauge = false;

    private FormsGaugePainter(boolean bl, boolean bl2) {
        this.mHalfdial = bl;
        this.mColorGauge = bl2;
    }

    public static Painter getPainter(boolean bl, boolean bl2) {
        if (bl) {
            if (bl2) {
                if (_sHalfColorGaugeInstance == null) {
                    _sHalfColorGaugeInstance = new FormsGaugePainter(true, true);
                }
                return _sHalfColorGaugeInstance;
            }
            if (_sHalfColorLabelInstance == null) {
                _sHalfColorLabelInstance = new FormsGaugePainter(true, false);
            }
            return _sHalfColorLabelInstance;
        }
        if (bl2) {
            if (_sFullColorGaugeInstance == null) {
                _sFullColorGaugeInstance = new FormsGaugePainter(false, true);
            }
            return _sFullColorGaugeInstance;
        }
        if (_sFullColorLabelInstance == null) {
            _sFullColorLabelInstance = new FormsGaugePainter(false, false);
        }
        return _sFullColorLabelInstance;
    }

    @Override
    public void paint(PaintContext paintContext, Graphics graphics, int n, int n2, int n3, int n4) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n5 = this.mHalfdial ? n3 - n4 * 2 : n3 - n4;
        if (n5 != 0) {
            if (n5 < 0) {
                n4 = n3;
                n2 = this.mHalfdial ? (n2 -= n5 / 4) : (n2 -= n5 / 2);
            } else {
                n += n5 / 2;
                if (this.mHalfdial) {
                    n3 = n4 * 2;
                    n4 *= 2;
                } else {
                    n3 = n4;
                }
            }
        } else if (this.mHalfdial) {
            n4 *= 2;
        }
        Color color = graphics2D.getColor();
        StringRangeModel stringRangeModel = this.getModel(paintContext);
        double d = this.getPercent(stringRangeModel);
        int n6 = (int)(d * -360.0);
        UIDefaults uIDefaults = paintContext.getPaintUIDefaults();
        int n7 = paintContext.getPaintState();
        Color color2 = uIDefaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
        Color color3 = uIDefaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
        Color color4 = color;
        Color color5 = uIDefaults.getColor(LookAndFeel.NORMAL_INTENSITY);
        Color color6 = uIDefaults.getColor(LookAndFeel.TEXT_HIGHLIGHT);
        int n8 = n3 < n4 ? n3 : n4;
        int n9 = n8 -= 2;
        int n10 = n + (n3 - n8) / 2;
        int n11 = n2 + (n4 - n9) / 2;
        graphics2D.setColor(color5);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.mHalfdial) {
            graphics2D.fillArc(n10, n11, n8, n9, 180, -180);
        } else {
            graphics2D.fillArc(n10, n11, n8, n9, 0, 360);
        }
        if (this.mColorGauge) {
            graphics2D.setColor(color4);
        } else {
            graphics2D.setColor(color6);
        }
        if (this.mHalfdial) {
            graphics2D.fillArc(n10, n11, n8, n9, 180, n6 / 2);
        } else {
            graphics2D.fillArc(n10, n11, n8, n9, 90, n6);
        }
        if (this.mColorGauge) {
            graphics2D.setColor(color6);
        } else {
            graphics2D.setColor(color4);
        }
        double d2 = 0.7853981633974483;
        double d3 = 0.0;
        int n12 = n3 / 2 - 1;
        int n13 = n12 - 5;
        int n14 = 0;
        while (n14 < 8) {
            if (!this.mHalfdial || n14 >= 5) {
                double d4 = Math.cos(d3);
                double d5 = Math.sin(d3);
                graphics2D.drawLine(n + 1 + n12 + (int)((double)n12 * d4), n2 + 1 + n12 + (int)((double)n12 * d5), n + 1 + n12 + (int)((double)n13 * d4), n2 + 1 + n12 + (int)((double)n13 * d5));
            }
            ++n14;
            d3 += d2;
        }
        String string = stringRangeModel.getStringValue(paintContext.getPaintLocale());
        if (string != null) {
            FontMetrics fontMetrics = paintContext.getFontMetrics(paintContext.getPaintFont());
            int n15 = fontMetrics.stringWidth(string);
            int n16 = (n3 - n15) / 2;
            if (n16 < 0) {
                n16 = 0;
            }
            n12 = fontMetrics.getAscent();
            n13 = this.mHalfdial ? (n4 - n12 + fontMetrics.getDescent()) / 2 : (n4 - (n12 + fontMetrics.getDescent())) / 2 + n12;
            GraphicUtils.drawString(graphics, string, n + n16, n2 + n13);
        }
        graphics2D.setColor(color2);
        if (this.mHalfdial) {
            graphics2D.drawArc(n10, n11, n8, n9, 180, -180);
        } else {
            graphics2D.drawArc(n10, n11, n8, n9, 0, 360);
        }
        graphics2D.setColor(color);
    }

    @Override
    public Dimension getPreferredSize(PaintContext paintContext) {
        Dimension dimension = this.getMinimumSize(paintContext);
        int n = dimension.width;
        if (n < 50) {
            dimension.width = 50;
            dimension.height = 50;
        }
        return dimension;
    }

    @Override
    public Dimension getMinimumSize(PaintContext paintContext) {
        int n;
        int n2 = this.getMinimumWidth(paintContext);
        if (n2 < (n = this.getMinimumHeight(paintContext))) {
            n2 = n;
        }
        return new Dimension(n2, n2);
    }

    @Override
    protected int getMinimumWidth(PaintContext paintContext) {
        return super.getMinimumWidth(paintContext) + 6 + 10;
    }

    @Override
    protected int getMinimumHeight(PaintContext paintContext) {
        return super.getMinimumHeight(paintContext) + 6 + 10;
    }
}

