/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import oracle.ewt.dTree.DTree;
import oracle.ewt.event.tracking.GlassMouseGrabProvider;
import oracle.ewt.lwAWT.LWComponent;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.ewt.util.EventQueueUtils;
import oracle.forms.engine.Main;

public class FormMouseGrabProvider
extends GlassMouseGrabProvider {
    private Cursor mOverrideCursor = null;
    private MouseGrab mMouseGrab = new MouseGrab();
    private ArrayList mTreeList = new ArrayList();
    private boolean mBusy = false;

    public FormMouseGrabProvider() {
        String string = System.getProperty("java.version");
        int n = -1;
        int n2 = -1;
        try {
            if (!string.startsWith("1.")) {
                n = 90;
            } else {
                n = 10 * Integer.parseInt(string.substring(0, 1)) + Integer.parseInt(string.substring(2, 3));
                int n3 = string.indexOf("_");
                n2 = n3 >= 0 ? Integer.parseInt(string.substring(n3 + 1)) : 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 16 && n2 >= 14 || n > 16) {
            if (n == 90) {
                try {
                    Method method = Component.class.getMethod("setMixingCutoutShape", Shape.class);
                    method.invoke((Object)this.getProxyComponent(), new Rectangle());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                try {
                    Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                    Method method = clazz.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                    method.invoke(null, this.getProxyComponent(), new Rectangle());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMouseGrab(DTree dTree) {
        ArrayList arrayList = this.mTreeList;
        synchronized (arrayList) {
            if (this.mTreeList.isEmpty()) {
                super.addMouseGrab(this.mMouseGrab);
                super.addMouseMotionGrab(this.mMouseGrab);
            }
            this.mTreeList.add(dTree);
        }
    }

    public void unregisterMouseGrab(DTree dTree) {
        EventQueueUtils.invokeLater(new MouseGrabRemover(dTree));
    }

    public void setOverrideCursor(int n) {
        if (n == 0) {
            this.setOverrideCursor(null);
        } else {
            this.setOverrideCursor(Cursor.getPredefinedCursor(n));
        }
    }

    public synchronized void setOverrideCursor(Cursor cursor) {
        if (cursor == this.mOverrideCursor) {
            return;
        }
        this.mOverrideCursor = cursor;
        if (!this.isBusy()) {
            this._updateCursor(cursor);
        }
    }

    public Cursor getOverrideCursor() {
        return this.mOverrideCursor;
    }

    public synchronized void setBusy(boolean bl) {
        if (bl == this.mBusy) {
            return;
        }
        this.mBusy = bl;
        this._updateCursor(bl ? Cursor.getPredefinedCursor(3) : this.mOverrideCursor);
    }

    public boolean isBusy() {
        return this.mBusy;
    }

    @Override
    protected Cursor getCursor(Component component, boolean bl, boolean bl2) {
        if (this.mBusy) {
            return Cursor.getPredefinedCursor(3);
        }
        Cursor cursor = this.mOverrideCursor;
        if (cursor == null) {
            cursor = super.getCursor(component, bl, bl2);
        }
        return cursor;
    }

    private void _updateCursor(Cursor cursor) {
        if (cursor == null) {
            cursor = Cursor.getDefaultCursor();
        }
        this.getProxyComponent().setCursor(cursor);
        for (Component component = this.getProxyComponent(); component != null; component = component.getParent()) {
            if (component.isLightweight() || component instanceof Main) continue;
            if (cursor == null) {
                cursor = Cursor.getDefaultCursor();
            }
            component.setCursor(cursor);
            break;
        }
    }

    private boolean isFreezeLayoutTreeComponent(Object object) {
        Component component;
        Container container;
        if (object != null && object instanceof DTree && this.mTreeList.contains((DTree)object)) {
            return true;
        }
        return object != null && object instanceof LWComponent && ((LWComponent)object).getName() != null && ((LWComponent)object).getName().startsWith("EwtLWScrollbar") && (container = ((LWComponent)object).getParent()) != null && container instanceof ScrollBox && (component = ((ScrollBox)container).getContent()) != null && component instanceof DTree && this.mTreeList.contains((DTree)component);
    }

    private class MouseGrab
    extends MouseAdapter
    implements MouseMotionListener {
        private boolean mpressed = false;

        private MouseGrab() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                this.mpressed = true;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource()) && this.mpressed) {
                this.mpressed = false;
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                mouseEvent.consume();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (FormMouseGrabProvider.this.isFreezeLayoutTreeComponent(mouseEvent.getSource())) {
                mouseEvent.consume();
            }
        }
    }

    private class MouseGrabRemover
    implements Runnable {
        DTree mTree;

        MouseGrabRemover(DTree dTree) {
            this.mTree = dTree;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList arrayList = FormMouseGrabProvider.this.mTreeList;
            synchronized (arrayList) {
                FormMouseGrabProvider.this.mTreeList.remove(this.mTree);
                if (FormMouseGrabProvider.this.mTreeList.isEmpty()) {
                    FormMouseGrabProvider.this.removeMouseGrab(FormMouseGrabProvider.this.mMouseGrab);
                    FormMouseGrabProvider.this.removeMouseMotionGrab(FormMouseGrabProvider.this.mMouseGrab);
                }
            }
        }
    }
}

