/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import oracle.ewt.LookAndFeel;
import oracle.ewt.UIDefaults;
import oracle.ewt.UIManager;
import oracle.ewt.lwAWT.lwText.LWTextArea;
import oracle.forms.engine.Main;
import oracle.forms.engine.Runform;
import oracle.forms.handler.TextComponentItem;
import oracle.forms.registry.MessageGenerator;
import oracle.forms.ui.ClipboardErrorUtils;
import oracle.forms.ui.VTextArea;

public class FLWTextArea
extends LWTextArea {
    private Font mCachedFont = null;
    private Font mCachedItalicFont = null;
    private Color mCachedColor = null;
    private Color mCachedPlaceholderColor = null;

    @Override
    public void cut() {
        Main main2 = ((VTextArea)this.getParent()).getHandler().getApplet();
        MessageGenerator messageGenerator = main2.getTranslatedPhraseGenerator();
        MessageGenerator messageGenerator2 = main2.getErrorMessageGenerator();
        try {
            super.cut();
        }
        catch (IllegalStateException illegalStateException) {
            ClipboardErrorUtils.displayMessage(messageGenerator2, messageGenerator, this.getParent(), main2.isAlertDialogAllowed());
        }
    }

    @Override
    public void copy() {
        Main main2 = ((VTextArea)this.getParent()).getHandler().getApplet();
        MessageGenerator messageGenerator = main2.getTranslatedPhraseGenerator();
        MessageGenerator messageGenerator2 = main2.getErrorMessageGenerator();
        try {
            super.copy();
        }
        catch (IllegalStateException illegalStateException) {
            ClipboardErrorUtils.displayMessage(messageGenerator2, messageGenerator, this.getParent(), main2.isAlertDialogAllowed());
        }
    }

    @Override
    public void paste() {
        Main main2 = ((VTextArea)this.getParent()).getHandler().getApplet();
        MessageGenerator messageGenerator = main2.getTranslatedPhraseGenerator();
        MessageGenerator messageGenerator2 = main2.getErrorMessageGenerator();
        try {
            super.paste();
        }
        catch (IllegalStateException illegalStateException) {
            ClipboardErrorUtils.displayMessage(messageGenerator2, messageGenerator, this.getParent(), main2.isAlertDialogAllowed());
        }
    }

    @Override
    protected void paintCanvasInterior(Graphics graphics) {
        super.paintCanvasInterior(graphics);
        if (this.getText().equals("")) {
            String string = null;
            string = ((TextComponentItem)((VTextArea)this.getParent()).getHandler()).getPlaceholderText();
            if (string != null) {
                Object object;
                UIDefaults uIDefaults = UIManager.getLookAndFeel().getDefaults();
                Color color = graphics.getColor();
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Font font = graphics.getFont();
                if (this.mCachedFont == null || this.mCachedFont != font) {
                    this.mCachedFont = font;
                    this.mCachedItalicFont = object = new Font(font.getName(), 2, font.getSize());
                }
                if (this.mCachedItalicFont != null) {
                    graphics.setFont(this.mCachedItalicFont);
                    fontMetrics = graphics.getFontMetrics();
                }
                object = ((TextComponentItem)((VTextArea)this.getParent()).getHandler()).getDispatcher();
                if (this.mCachedColor == null || this.mCachedColor != color) {
                    float[] fArray;
                    this.mCachedColor = color;
                    this.mCachedPlaceholderColor = ((Runform)object).getPlaceholderColor() != null ? ((Runform)object).getPlaceholderColor() : ((double)(fArray = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null))[1] >= 0.2 ? Color.getHSBColor(fArray[0], fArray[1] * 0.5f, fArray[2]) : ((double)fArray[2] <= 0.9 ? Color.getHSBColor(fArray[0], fArray[1], (1.0f - fArray[2]) * 0.5f + fArray[2]) : uIDefaults.getColor(LookAndFeel.TEXT_INACTIVE_TEXT)));
                }
                graphics.setColor(this.mCachedPlaceholderColor);
                graphics.drawString(string, this.getAlignmentOffset(string), fontMetrics.getAscent() + fontMetrics.getLeading());
                graphics.setColor(color);
                graphics.setFont(font);
            }
        }
    }

    private int getAlignmentOffset(String string) {
        int n = 0;
        int n2 = this.getActualAlignment();
        if (n2 != 1) {
            int n3 = string != null ? this.getFontMetrics(this.getFont()).stringWidth(string) : 0;
            n = this.getInnerWidth() - 1 - 1 - n3;
            if (n2 == 3) {
                n >>= 1;
            }
            if (n < 0) {
                n = 0;
            }
        }
        return n + 1;
    }
}

