/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import oracle.ewt.EwtComponent;
import oracle.ewt.button.PushButton;
import oracle.ewt.graphics.ImageUtils;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwMenu.LWMenuBar;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.lwAWT.lwWindow.laf.TitleBar;
import oracle.ewt.toolBar.ToolBar;
import oracle.forms.engine.Message;
import oracle.forms.engine.Runform;
import oracle.forms.handler.ComponentItem;
import oracle.forms.handler.FormCanvas;
import oracle.forms.handler.FormWindow;
import oracle.forms.handler.UICommon;
import oracle.forms.ui.DrawnPanel;
import oracle.forms.ui.FWindow;
import oracle.forms.ui.mdi.MDIContainer;
import oracle.forms.ui.mdi.MDIUtils;

public class ExtendedFrame
extends FWindow
implements KeyListener,
ActionListener {
    private DrawnPanel mVToolbar = null;
    private DrawnPanel mHToolbar = null;
    private DrawnPanel mStatusBar = null;
    private ToolBar mHSmartBar = null;
    private ToolBar mVSmartBar = null;
    private LWContainer mHAlley = null;
    private LWContainer mVAlley = null;
    private DrawnPanel mContent = null;
    protected EwtComponent mRootPanel = null;
    private LWContainer mNorthPanel = null;
    protected FormWindow mHandler;
    private Object mResizeLock = new Object();
    protected boolean mNoFocus = true;
    private static int sRedirected;
    private static int sWindowCount;
    private int mWindowSequence;
    private boolean mWindowSequenceSet = false;
    private PushButton mLovButton;
    private LWTextField mLovButtonParent;
    private LWLabel mCharCountLabel;
    private static Image mEllipsisIcon;
    private Message mAlertDismissMsg;
    private static final int FUDGE_FACTOR = 4;

    public ExtendedFrame(FormWindow formWindow) {
        this(formWindow, true, false);
    }

    public ExtendedFrame(FormWindow formWindow, boolean bl) {
        this(formWindow, true, bl);
    }

    private ExtendedFrame(FormWindow formWindow, boolean bl, boolean bl2) {
        if (bl2) {
            this.removeTitleBar();
        } else {
            TitleBar titleBar = this.getTitleBar();
            if (titleBar != null) {
                titleBar.setVisible(false);
            }
        }
        this.init(formWindow, bl);
    }

    public void removeTitleBar() {
        TitleBar titleBar = this.getTitleBar();
        if (titleBar != null) {
            this.remove(titleBar);
        }
    }

    public TitleBar getTitleBar() {
        Component[] componentArray = this.getComponents();
        Object var2_2 = null;
        for (Component component : componentArray) {
            if (!(component instanceof TitleBar)) continue;
            return (TitleBar)component;
        }
        return null;
    }

    public void init(FormWindow formWindow, boolean bl) {
        this.mHandler = formWindow;
        if (bl) {
            this.initPanels();
        }
        if (this.mHandler.getDispatcher().useLovButtons()) {
            this.createLOVButton();
        }
        this.createCharCountLabel();
        this.setIcon(null);
        AccessibleContext accessibleContext = this.getAccessibleContext();
    }

    protected void initPanels() {
        this.mRootPanel = new EwtComponent();
        this.mRootPanel.setLayout(new BorderLayout());
        this.mNorthPanel = new LWContainer();
        this.mNorthPanel.setLayout(new BorderLayout());
        this.mRootPanel.add("North", this.mNorthPanel);
        this.addKeyListener(this);
        this.mHAlley = new LWContainer();
        this.mHAlley.setLayout(new BorderLayout());
        this.mHAlley.setVisible(false);
        this.mNorthPanel.add("South", this.mHAlley);
        this.mVAlley = new LWContainer();
        this.mVAlley.setLayout(new BorderLayout());
        this.mVAlley.setVisible(false);
        if (this.getActualReadingDirection() == 2) {
            this.mRootPanel.add("East", this.mVAlley);
        } else {
            this.mRootPanel.add("West", this.mVAlley);
        }
        this.setContent(this.mRootPanel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createLOVButton() {
        Serializable serializable;
        if (mEllipsisIcon == null) {
            serializable = this;
            synchronized (serializable) {
                mEllipsisIcon = this.mHandler.getApplet().getDefaultImage("ellipsis");
            }
        }
        this.mLovButton = mEllipsisIcon != null ? new PushButton(mEllipsisIcon) : new PushButton("...");
        serializable = this.mLovButton.getPreferredSize();
        ((Dimension)serializable).width -= 4;
        this.mLovButton.setSize((Dimension)serializable);
        this.mLovButtonParent = new LWTextField();
        this.mLovButtonParent.setSize((Dimension)serializable);
        this.mLovButtonParent.add((Component)this.mLovButton, 0);
        this.mLovButton.addActionListener(this);
        this.mLovButton.setCursor(Cursor.getDefaultCursor());
        this.mLovButton.setFocusable(false);
    }

    private void createCharCountLabel() {
        this.mCharCountLabel = new LWLabel();
    }

    public Dimension getTKInnerSize() {
        return this.getContent().getSize();
    }

    public void setTKInnerSize(int n, int n2) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getContent().getSize();
        this.getContent().setSize(n, n2);
        this.setSize(n += dimension.width - dimension2.width, n2 += dimension.height - dimension2.height);
    }

    public void loseFocus() {
        this.requestFocus();
    }

    @Override
    public void setVisible(boolean bl, boolean bl2) {
        if (bl && this.mNoFocus) {
            this.loseFocus();
            this.mNoFocus = false;
        }
        super.setVisible(bl, bl2);
        if (bl && !this.mWindowSequenceSet) {
            this.mWindowSequenceSet = true;
            this.mWindowSequence = sWindowCount++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        Dimension dimension = this.getSize();
        Object object = this.mResizeLock;
        synchronized (object) {
            super.addNotify();
        }
    }

    protected Component setGenericComponent(Component component, Component component2, Container container, String string) {
        if (component == component2) {
            return component;
        }
        if (component == null || component.getParent() != null) {
            // empty if block
        }
        if (component2 != null) {
            container.remove(component2);
        }
        if (component != null) {
            container.add(string, component);
        }
        return component;
    }

    public void setStatusBar(DrawnPanel drawnPanel) {
        Runform runform = this.mHandler.getDispatcher();
        if (runform.isSDIMode()) {
            this.setGenericComponent(drawnPanel, this.mStatusBar, this.mRootPanel, "South");
        }
        this.mStatusBar = drawnPanel;
    }

    public void setVerticalToolbar(DrawnPanel drawnPanel) {
        if (drawnPanel == null) {
            this.setGenericComponent(drawnPanel, this.mVToolbar, this.mVAlley, "Center");
            this.setMDIVerticalToolbar(drawnPanel);
            this.mVToolbar = drawnPanel;
            return;
        }
        if (!drawnPanel.getMDIFlag()) {
            this.setGenericComponent(drawnPanel, this.mVToolbar, this.mVAlley, "Center");
            if (drawnPanel != null) {
                this.mVAlley.setVisible(true);
            } else if (this.mVSmartBar == null) {
                this.mVAlley.setVisible(false);
            }
        } else {
            this.setMDIVerticalToolbar(drawnPanel);
        }
        this.mVToolbar = drawnPanel;
    }

    public void setMDIVerticalToolbar(DrawnPanel drawnPanel) {
        this.setMDIProperty("mdiVerticalClientToolBar", drawnPanel);
    }

    public void setHorizontalToolbar(DrawnPanel drawnPanel) {
        if (drawnPanel == null) {
            this.setGenericComponent(drawnPanel, this.mHToolbar, this.mHAlley, "Center");
            this.setMDIHorizontalToolbar(drawnPanel);
            this.mHToolbar = drawnPanel;
            return;
        }
        if (!drawnPanel.getMDIFlag()) {
            this.setGenericComponent(drawnPanel, this.mHToolbar, this.mHAlley, "Center");
            if (drawnPanel != null) {
                this.mHAlley.setVisible(true);
            } else if (this.mHSmartBar == null) {
                this.mHAlley.setVisible(false);
            }
        } else {
            this.setMDIHorizontalToolbar(drawnPanel);
        }
        this.mHToolbar = drawnPanel;
    }

    public void setMDIHorizontalToolbar(DrawnPanel drawnPanel) {
        this.setMDIProperty("mdiHorizontalClientToolBar", drawnPanel);
    }

    public void setVerticalSmartBar(ToolBar toolBar) {
        Runform runform = this.mHandler.getDispatcher();
        if (runform.isSDIMode()) {
            if (this.mVSmartBar != toolBar) {
                this.setGenericComponent(toolBar, this.mVSmartBar, this.mVAlley, "West");
                this.mVSmartBar = toolBar;
                if (toolBar != null) {
                    this.mVAlley.setVisible(true);
                } else if (this.mVToolbar == null) {
                    this.mVAlley.setVisible(false);
                }
            }
        } else {
            this.setMDIProperty("mdiVerticalToolBar", toolBar);
        }
    }

    public void setHorizontalSmartBar(ToolBar toolBar) {
        Runform runform = this.mHandler.getDispatcher();
        if (runform.isSDIMode()) {
            if (this.mHSmartBar != toolBar) {
                this.setGenericComponent(toolBar, this.mHSmartBar, this.mHAlley, "North");
                this.mHSmartBar = toolBar;
                if (toolBar != null) {
                    this.mHAlley.setVisible(true);
                } else if (this.mHToolbar == null) {
                    this.mHAlley.setVisible(false);
                }
            }
        } else {
            this.setMDIProperty("mdiHorizontalToolBar", toolBar);
        }
    }

    public void addToContent(FormCanvas formCanvas) {
        Component component = formCanvas.getComponent();
        this.mContent = formCanvas.getPanel();
        component.setSize(this.getSize());
        if (component != null) {
            this.mRootPanel.add("Center", component);
        }
    }

    public DrawnPanel getContentView() {
        return this.mContent;
    }

    private void retargetKeyEvent(KeyEvent keyEvent) {
        Component component;
        ComponentItem componentItem;
        if (sRedirected++ <= 0 && this.mHandler != null && (componentItem = this.mHandler.getDispatcher().getFocusOwner()) != null && (component = componentItem.getComponent()) != null) {
            if (componentItem.getParentWindow() == this) {
                keyEvent.consume();
                UICommon.setFocusHidden(true);
                component.requestFocus();
                UICommon.setFocusHidden(false);
                KeyEvent keyEvent2 = new KeyEvent(component, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiersEx(), keyEvent.getKeyCode(), keyEvent.getKeyChar());
                component.dispatchEvent(keyEvent2);
            } else if (keyEvent.getKeyCode() == 9 && keyEvent.getID() == 401) {
                keyEvent.consume();
            }
        }
        --sRedirected;
    }

    public PushButton getLovButton() {
        return this.mLovButton;
    }

    public LWLabel getCharCountLabel() {
        return this.mCharCountLabel;
    }

    public LWTextField getLovButtonParent() {
        return this.mLovButtonParent;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.retargetKeyEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.retargetKeyEvent(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.retargetKeyEvent(keyEvent);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mLovButton) {
            ComponentItem componentItem = this.mHandler.getDispatcher().getFocusOwner();
            componentItem.sendLOVButtonPressedMessage();
        }
    }

    public void setLWMenuBar(LWMenuBar lWMenuBar) {
        Runform runform = this.mHandler.getDispatcher();
        if (runform.isSDIMode()) {
            this.setMenuBar(lWMenuBar);
        } else {
            this.setMDIProperty("mdiMenuBar", lWMenuBar);
        }
    }

    private void setMDIProperty(String string, Component component) {
        this.putClientProperty(string, component);
        MDIContainer mDIContainer = this.mHandler.getApplet().getMDIContainer();
        if (mDIContainer != null) {
            mDIContainer.updateWindowProperties(this);
        }
    }

    public void setIcon(Image image) {
        if (image != null && !ImageUtils.loadImage(image)) {
            image = null;
        }
        if (image == null) {
            image = this.mHandler.getDefaultFrameIcon();
        }
        if (image != null) {
            this.setFrameIcon(image);
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
    }

    public void setDialogResult(Message message) {
        this.mAlertDismissMsg = message;
    }

    public Message getAlertDismissMsg() {
        return this.mAlertDismissMsg;
    }

    public FormWindow getHandler() {
        return this.mHandler;
    }

    public void setLogicalLocation(int n, int n2, boolean bl) {
        if (bl) {
            Dimension dimension = this.mHandler.getApplet().getDesktop().getParent().getParent().getSize();
            Dimension dimension2 = this.getSize();
            if (dimension.width <= 0 && dimension.height <= 0) {
                Vector vector = this.mHandler.getApplet().getWindowsToCenter();
                vector.addElement(this);
            }
            n = Math.max(0, dimension.width - dimension2.width) / 2;
            n2 = Math.max(0, dimension.height - dimension2.height) / 2;
        } else if (this.getReadingDirection() == 2) {
            Rectangle rectangle = MDIUtils.getDesktopBounds(this.getDesktop());
            Dimension dimension = this.getSize();
            n = rectangle.width - dimension.width - n;
        }
        this.setLocation(n, n2);
    }

    public Point getLogicalLocation() {
        Point point = this.getLocation();
        if (this.getReadingDirection() == 2) {
            Rectangle rectangle = MDIUtils.getDesktopBounds(this.getDesktop());
            Dimension dimension = this.getSize();
            point.x = rectangle.width - dimension.width - point.x;
        }
        return point;
    }

    public void destroy() {
        if (this.mVToolbar != null) {
            this.mVToolbar.removeAll();
        }
        if (this.mHToolbar != null) {
            this.mHToolbar.removeAll();
        }
        if (this.mStatusBar != null) {
            this.mStatusBar.removeAll();
        }
        if (this.mHSmartBar != null) {
            this.mHSmartBar.removeAll();
        }
        if (this.mVSmartBar != null) {
            this.mVSmartBar.removeAll();
        }
        if (this.mHAlley != null) {
            this.mHAlley.removeAll();
        }
        if (this.mVAlley != null) {
            this.mVAlley.removeAll();
        }
        if (this.mRootPanel != null) {
            this.mRootPanel.removeAll();
        }
        if (this.mNorthPanel != null) {
            this.mNorthPanel.removeAll();
        }
        this.mVToolbar = null;
        this.mHToolbar = null;
        this.mStatusBar = null;
        this.mHSmartBar = null;
        this.mVSmartBar = null;
        this.mVSmartBar = null;
        this.mHAlley = null;
        this.mVAlley = null;
        this.mRootPanel = null;
        this.mNorthPanel = null;
        this.mHandler = null;
        this.mResizeLock = null;
        this.mLovButton = null;
        this.mCharCountLabel = null;
    }

    public int getWindowSequence() {
        if (this.mWindowSequenceSet) {
            return this.mWindowSequence;
        }
        return -1;
    }

    public DrawnPanel getVerticalToolbar() {
        return this.mVToolbar;
    }

    static {
        sWindowCount = 0;
    }
}

