/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.accessibility.AccessibleContext;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.scrolling.scrollBox.ScrollBox;
import oracle.forms.handler.Painter;

public class DrawnPanel
extends LWContainer {
    public static final byte USAGE_CONTENT = 1;
    public static final byte USAGE_VTOOLBARALLEY = 2;
    public static final byte USAGE_HTOOLBARALLEY = 3;
    public static final byte USAGE_STATUSALLEY = 4;
    public static final byte USAGE_OTHER = 5;
    public static final byte UI_CONTENT_CANVAS = 0;
    public static final byte UI_STACKED_CANVAS = 1;
    public static final byte UI_SCROLLSTACKED_CANVAS = 2;
    public static final Font mDefaultFont = new Font("Dialog", 1, 10);
    private Painter mPainter;
    private Point mRealSize = new Point(0, 0);
    private byte mUsage = (byte)5;
    private boolean mMDIFlag = false;
    private boolean mAddRecurse = false;
    private Point mCanvasOrigin = null;
    private ScrollBox mParent = null;
    private byte mCanvasType;
    private DrawnPanel mScrollee = null;
    private boolean mUserScrolled = false;

    public DrawnPanel() {
        this.setFont(mDefaultFont);
        this.setVisible(false);
        AccessibleContext accessibleContext = this.getAccessibleContext();
    }

    public void setUsage(byte by) {
        this.mUsage = by;
        if (this.mUsage == 2 || this.mUsage == 3 || this.mUsage == 4) {
            this.setLayout(new BorderLayout());
        }
    }

    public byte getUsage() {
        return this.mUsage;
    }

    public final String getUsageString() {
        return null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.getUsage() == 4) {
            return super.getPreferredSize();
        }
        Point point = this.getRealSize();
        return point != null ? new Dimension(point.x, point.y) : new Dimension(0, 0);
    }

    @Override
    public Component add(Component component, int n) {
        byte by = this.getUsage();
        if (this.mAddRecurse) {
            return super.add(component, n);
        }
        this.mAddRecurse = true;
        Component component2 = null;
        if (by == 2 || by == 3 || by == 4) {
            this.add(component, "Center", 0);
            component2 = component;
        } else {
            component2 = super.add(component, n);
        }
        this.mAddRecurse = false;
        return component2;
    }

    @Override
    public void paintInterior(Graphics graphics) {
        Painter painter = this.getPainter();
        if (painter != null) {
            painter.paint(graphics, this.getSize(), this.getBounds());
        }
        super.paintInterior(graphics);
    }

    public void setPainter(Painter painter) {
        this.mPainter = painter;
    }

    public Painter getPainter() {
        return this.mPainter;
    }

    @Override
    public void setVisible(boolean bl) {
        byte by = this.getUsage();
        if (by == 2 || by == 3 || by == 4) {
            if (bl) {
                if (by != 4) {
                    Point point = this.getRealSize();
                    this.setSize(point.x, point.y);
                }
            } else {
                this.setSize(0, 0);
            }
        }
        super.setVisible(bl);
    }

    @Override
    public void setSize(int n, int n2) {
        if (this.getUsage() != 4) {
            super.setSize(n, n2);
            this.setRealSize(new Point(n, n2));
        }
    }

    @Override
    public void setSize(Dimension dimension) {
        if (this.getUsage() != 4) {
            super.setSize(dimension);
            this.setRealSize(new Point(dimension.width, dimension.height));
        }
    }

    public void setRealSize(Point point) {
        this.mRealSize = new Point(point.x, point.y);
    }

    public Point getRealSize() {
        return this.mRealSize;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.scrollToOrigin();
    }

    public void scrollToOrigin() {
        if (this.mCanvasOrigin != null && this.mParent != null) {
            this.mParent.setScrollPosition(-this.mCanvasOrigin.x, -this.mCanvasOrigin.y);
        }
    }

    public Point getOrigin() {
        if (this.mCanvasOrigin == null) {
            return new Point(0, 0);
        }
        return this.mCanvasOrigin;
    }

    public void setOrigin(Point point) {
        this.mCanvasOrigin = new Point(point.x, point.y);
    }

    public void setOrigin(ScrollBox scrollBox, Point point) {
        this.mCanvasOrigin = new Point(point.x, point.y);
        this.mParent = scrollBox;
        this.scrollToOrigin();
    }

    @Override
    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        if (this.hasUserScrolled() || this.mCanvasOrigin == null) {
            this.mCanvasOrigin = new Point(n, n2);
        }
    }

    @Override
    public void setLocation(Point point) {
        super.setLocation(point);
        if (this.hasUserScrolled() || this.mCanvasOrigin == null) {
            this.mCanvasOrigin = new Point(point.x, point.y);
        }
    }

    public byte getCanvasType() {
        return this.mCanvasType;
    }

    public void setCanvasType(byte by) {
        this.mCanvasType = by;
    }

    public boolean getMDIFlag() {
        return this.mMDIFlag;
    }

    public void setMDIFlag(boolean bl) {
        this.mMDIFlag = bl;
    }

    public void setRecentScrollee(DrawnPanel drawnPanel) {
        if (this.getUsage() == 1) {
            this.mScrollee = drawnPanel;
        }
    }

    public DrawnPanel getRecentScrollee() {
        return this.mScrollee;
    }

    public void setUserScrolled(boolean bl) {
        this.mUserScrolled = bl;
    }

    public boolean hasUserScrolled() {
        return this.mUserScrolled;
    }

    @Override
    public void doLayout() {
        byte by = this.getUsage();
        if (by == 2 || by == 3) {
            Dimension dimension = this.getSize();
            Insets insets = this.getInsets();
            dimension.width = dimension.width - insets.left - insets.right;
            dimension.height = dimension.height - insets.top - insets.bottom;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                component.setSize(dimension);
            }
        } else if (by == 1) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getSize();
                Point point = component.getLocation();
                if (dimension.width + point.x > n) {
                    n = dimension.width + point.x;
                }
                if (dimension.height + point.y <= n2) continue;
                n2 = dimension.height + point.y;
            }
            if (n > 0) {
                n3 = Math.max(n, this.getSize().width);
            }
            if (n2 > 0) {
                n4 = Math.max(n2, this.getSize().height);
            }
            if (n3 != 0 && n4 != 0) {
                this.setSize(n3, n4);
            }
            if (this.mParent != null) {
                this.mParent.setScrollPosition(-this.mCanvasOrigin.x, -this.mCanvasOrigin.y);
            }
        }
        if ((this.mCanvasType == 1 || this.mCanvasType == 2) && this.mParent != null) {
            this.mParent.setScrollPosition(-this.mCanvasOrigin.x, -this.mCanvasOrigin.y);
        }
        super.doLayout();
    }

    public void destroy() {
        this.mPainter = null;
        this.mParent = null;
        this.mScrollee = null;
        this.mCanvasOrigin = null;
        this.mRealSize = null;
    }
}

