/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.VetoableChangeListener;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import oracle.forms.beans.ActionEventEncoder;
import oracle.forms.beans.ArgumentPM;
import oracle.forms.beans.ArrayEncoder;
import oracle.forms.beans.BooleanEncoder;
import oracle.forms.beans.ByteEncoder;
import oracle.forms.beans.CharacterEncoder;
import oracle.forms.beans.ColorEncoder;
import oracle.forms.beans.ComponentEventEncoder;
import oracle.forms.beans.ContainerEventEncoder;
import oracle.forms.beans.DimensionEncoder;
import oracle.forms.beans.DoubleEncoder;
import oracle.forms.beans.Encoder;
import oracle.forms.beans.EventEncoder;
import oracle.forms.beans.FloatEncoder;
import oracle.forms.beans.FocusEventEncoder;
import oracle.forms.beans.ImageEncoder;
import oracle.forms.beans.IndexedPropertyArrayPM;
import oracle.forms.beans.IndexedPropertyPM;
import oracle.forms.beans.InsetsEncoder;
import oracle.forms.beans.IntegerEncoder;
import oracle.forms.beans.ItemEventEncoder;
import oracle.forms.beans.KeyEventEncoder;
import oracle.forms.beans.ListenerPM;
import oracle.forms.beans.LongEncoder;
import oracle.forms.beans.MethodPM;
import oracle.forms.beans.MouseEventEncoder;
import oracle.forms.beans.PointEncoder;
import oracle.forms.beans.PropertyChangeEventEncoder;
import oracle.forms.beans.PropertyManager;
import oracle.forms.beans.PropertyPM;
import oracle.forms.beans.RectangleEncoder;
import oracle.forms.beans.ShortEncoder;
import oracle.forms.beans.StringArrayEncoder;
import oracle.forms.beans.TextEventEncoder;
import oracle.forms.beans.WindowEventEncoder;
import oracle.forms.handler.IHandler;
import oracle.forms.properties.DebugMode;
import oracle.forms.properties.ID;
import oracle.forms.properties.PropertyMask;
import oracle.forms.ui.CustomEvent;
import oracle.forms.ui.CustomListener;

public class BeanManager
implements ActionListener,
ComponentListener,
ContainerListener,
FocusListener,
ItemListener,
KeyListener,
MouseListener,
PropertyChangeListener,
TextListener,
VetoableChangeListener,
WindowListener {
    private Component mBean;
    private Hashtable mPMs;
    private Vector mCustomListeners;
    private String mBeanName = "VBean";
    private IHandler mHandler;
    private int mDbg = DebugMode.DEBUG_NONE.toID();
    private boolean mStopCaching = false;
    private boolean mDbgModeSet = false;
    private String mDbgCache = "";
    private static Hashtable sET = new Hashtable();
    private static Class[] sTypes = new Class[]{ActionEvent.class, Boolean.class, Byte.class, Character.class, Color.class, ComponentEvent.class, ContainerEvent.class, Dimension.class, Double.class, EventObject.class, Float.class, FocusEvent.class, Image.class, Insets.class, Integer.class, ItemEvent.class, KeyEvent.class, Long.class, MouseEvent.class, Point.class, PropertyChangeEvent.class, Rectangle.class, Short.class, TextEvent.class, WindowEvent.class};
    private static Class[] sEncoders = new Class[]{ActionEventEncoder.class, BooleanEncoder.class, ByteEncoder.class, CharacterEncoder.class, ColorEncoder.class, ComponentEventEncoder.class, ContainerEventEncoder.class, DimensionEncoder.class, DoubleEncoder.class, EventEncoder.class, FloatEncoder.class, FocusEventEncoder.class, ImageEncoder.class, InsetsEncoder.class, IntegerEncoder.class, ItemEventEncoder.class, KeyEventEncoder.class, LongEncoder.class, MouseEventEncoder.class, PointEncoder.class, PropertyChangeEventEncoder.class, RectangleEncoder.class, ShortEncoder.class, TextEventEncoder.class, WindowEventEncoder.class};

    public BeanManager() {
        this.mPMs = new Hashtable();
        this.mCustomListeners = new Vector();
    }

    public static Encoder findEncoder(Class clazz) {
        if (clazz.isPrimitive()) {
            clazz = BeanManager.convertToObjectType(clazz);
        }
        return (Encoder)sET.get(clazz);
    }

    public PropertyManager get(ID iD) {
        return (PropertyManager)this.mPMs.get(iD);
    }

    public final Component getBean() {
        return this.mBean;
    }

    public final void put(ID iD, PropertyManager propertyManager) {
        this.mPMs.put(iD, propertyManager);
    }

    public static void registerEncoder(Encoder encoder) {
        sET.put(encoder.getType(), encoder);
    }

    public final void setBean(Component component, String string) {
        this.mBean = component;
        this.mBeanName = string;
    }

    public final void setHandler(IHandler iHandler) {
        this.mHandler = iHandler;
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.mBean.getClass().getName();
    }

    public void introspectBean(Class clazz) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Component.class);
            BeanInfo beanInfo2 = Introspector.getBeanInfo(clazz);
            this.registerProperties(beanInfo);
            this.registerMethods(beanInfo);
            this.registerListeners(beanInfo2);
        }
        catch (Exception exception) {
            this.error("Failed to introspect class: " + clazz + " " + exception);
        }
    }

    private void debug(String string) {
        if (!this.mDbgCache.equals("") && this.mDbgModeSet) {
            System.out.println(this.mDbgCache);
            System.out.println("*** " + this.mBeanName + " " + string);
            this.mDbgCache = "";
        } else if (this.mDbgModeSet) {
            System.out.println("*** " + this.mBeanName + " " + string);
        } else if (!this.mDbgModeSet) {
            this.mDbgCache = this.mDbgCache + "\n*** " + this.mBeanName + " " + string;
        }
    }

    public void error(String string) {
        if (!this.mStopCaching || this.mDbg == DebugMode.DEBUG_ERROR.toID() || this.mDbg == DebugMode.DEBUG_ALL.toID()) {
            this.debug("    " + string);
        }
    }

    public String getDebugMode() {
        return DebugMode.toString(this.mDbg);
    }

    public void log(String string) {
        if (!this.mStopCaching || this.mDbg == DebugMode.DEBUG_LOG.toID() || this.mDbg == DebugMode.DEBUG_ALL.toID()) {
            this.debug(string);
        }
    }

    public String printType(Class clazz) {
        if (clazz.isArray()) {
            return "[" + clazz.getComponentType().getName() + "]";
        }
        return clazz.getName();
    }

    public void setDebugMode(String string) {
        this.mDbg = DebugMode.fromString(string);
        if (DebugMode.isValid(this.mDbg)) {
            this.mDbgModeSet = true;
            this.log("Setting debugMode to " + string);
        } else {
            this.mDbg = DebugMode.DEBUG_NONE.toID();
        }
    }

    public void stopDebugCaching() {
        this.mStopCaching = true;
    }

    public void tablog(String string) {
        this.log("    " + string);
    }

    public void warning(String string) {
        if (!this.mStopCaching || this.mDbg == DebugMode.DEBUG_WARNING.toID() || this.mDbg == DebugMode.DEBUG_ALL.toID()) {
            this.debug(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCustomListener(CustomListener customListener) {
        Vector vector = this.mCustomListeners;
        synchronized (vector) {
            this.mCustomListeners.addElement(customListener);
        }
    }

    public void dispatchCustomEvent(CustomEvent customEvent) {
        Enumeration enumeration = this.mCustomListeners.elements();
        this.log("Dispatching " + customEvent.getName());
        while (enumeration.hasMoreElements()) {
            CustomListener customListener = (CustomListener)enumeration.nextElement();
            customListener.customActionPerformed(customEvent);
        }
    }

    public void dispatchEvent(EventObject eventObject) {
        Encoder encoder = BeanManager.findEncoder(eventObject.getClass());
        if (encoder != null) {
            String string = encoder.toString(eventObject);
            if (encoder instanceof EventEncoder) {
                ID iD = ID.registerProperty("DATA");
                try {
                    this.mHandler.setProperty(iD, ((EventEncoder)encoder).getParameters(eventObject));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            CustomEvent customEvent = new CustomEvent((Object)this.mHandler, string);
            this.dispatchCustomEvent(customEvent);
        } else {
            this.warning("Null Encoder for " + this.printType(eventObject.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomListener(CustomListener customListener) {
        Vector vector = this.mCustomListeners;
        synchronized (vector) {
            this.mCustomListeners.removeElement(customListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.dispatchEvent(actionEvent);
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
        this.dispatchEvent(componentEvent);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
        this.dispatchEvent(componentEvent);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.dispatchEvent(componentEvent);
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        this.dispatchEvent(componentEvent);
    }

    @Override
    public void componentAdded(ContainerEvent containerEvent) {
        this.dispatchEvent(containerEvent);
    }

    @Override
    public void componentRemoved(ContainerEvent containerEvent) {
        this.dispatchEvent(containerEvent);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.dispatchEvent(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.dispatchEvent(focusEvent);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.dispatchEvent(itemEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        this.dispatchEvent(keyEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchEvent(mouseEvent);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.dispatchEvent(propertyChangeEvent);
    }

    @Override
    public void textValueChanged(TextEvent textEvent) {
        this.dispatchEvent(textEvent);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        this.dispatchEvent(propertyChangeEvent);
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.dispatchEvent(windowEvent);
    }

    private Class convertToArrayType(Class clazz) {
        Object object = Array.newInstance(clazz, 0);
        return object.getClass();
    }

    private String getPrefixedName(String string, String string2) {
        return string2 + string.substring(0, 1).toUpperCase() + string.substring(1);
    }

    private String getUniqueListenerName(String string) {
        return this.getPrefixedName(string, "l");
    }

    private String getUniqueMethodName(String string) {
        String string2;
        String string3 = string2 = this.getPrefixedName(string, "m");
        int n = 0;
        while (this.get(ID.registerProperty(string3)) != null) {
            string3 = string2 + "_" + n++;
        }
        return string3;
    }

    private String getUniquePropName(String string) {
        return this.getPrefixedName(string, "p");
    }

    private void registerArrayEncoder(Class clazz) {
        Class clazz2 = BeanManager.convertToObjectType(clazz.getComponentType());
        if (clazz2 == String.class || clazz2 == Character.class || clazz2 == Character.TYPE) {
            BeanManager.registerEncoder(new StringArrayEncoder(clazz, ","));
        } else {
            Encoder encoder = BeanManager.findEncoder(clazz2);
            if (encoder != null) {
                BeanManager.registerEncoder(new ArrayEncoder(clazz, encoder, ","));
            }
        }
    }

    private PropertyManager registerIndexedProperty(String string, IndexedPropertyDescriptor indexedPropertyDescriptor) {
        IndexedPropertyPM indexedPropertyPM = null;
        Class<?> clazz = indexedPropertyDescriptor.getIndexedPropertyType();
        Class clazz2 = BeanManager.convertToObjectType(clazz);
        Class clazz3 = this.convertToArrayType(clazz2);
        PropertyManager propertyManager = new PropertyManager(this, Integer.class);
        indexedPropertyPM = new IndexedPropertyPM(this, indexedPropertyDescriptor, propertyManager, clazz2);
        ID iD = ID.registerProperty(string + "Index");
        this.tablog("int " + string + "Index");
        this.put(iD, propertyManager);
        if (indexedPropertyDescriptor.getWriteMethod() != null && indexedPropertyDescriptor.getReadMethod() != null) {
            IndexedPropertyArrayPM indexedPropertyArrayPM = new IndexedPropertyArrayPM(this, indexedPropertyDescriptor, clazz3);
            ID iD2 = ID.registerProperty(string + "[]");
            this.tablog(this.printType(clazz3) + " " + string + "[]");
            this.put(iD2, indexedPropertyArrayPM);
        }
        return indexedPropertyPM;
    }

    private void registerListeners(BeanInfo beanInfo) {
        this.log("Registering listeners");
        EventSetDescriptor[] eventSetDescriptorArray = beanInfo.getEventSetDescriptors();
        for (int i = 0; i < eventSetDescriptorArray.length; ++i) {
            String string = eventSetDescriptorArray[i].getListenerType().getName();
            String string2 = this.getUniqueListenerName(string.substring(string.lastIndexOf(".") + 1));
            this.tablog(string2);
            ID iD = ID.registerProperty(string2);
            Method method = eventSetDescriptorArray[i].getAddListenerMethod();
            Method method2 = eventSetDescriptorArray[i].getRemoveListenerMethod();
            ListenerPM listenerPM = new ListenerPM(this, method, method2);
            this.put(iD, listenerPM);
        }
    }

    private void registerMethods(BeanInfo beanInfo) {
        this.log("Registering methods");
        int n = 0;
        MethodDescriptor[] methodDescriptorArray = beanInfo.getMethodDescriptors();
        for (int i = 0; i < methodDescriptorArray.length; ++i) {
            ID iD;
            Method method = methodDescriptorArray[i].getMethod();
            Class<?>[] classArray = method.getParameterTypes();
            n = classArray.length;
            PropertyManager[] propertyManagerArray = new PropertyManager[n];
            String string = this.getUniqueMethodName(method.getName());
            this.tablog(this.printType(method.getReturnType()) + " " + string + (n == 0 ? "()" : "("));
            for (int j = 0; j < n; ++j) {
                iD = ID.registerProperty(string + "$" + (j + 1));
                if (classArray[j].isArray()) {
                    this.registerArrayEncoder(classArray[j]);
                }
                this.tablog("    " + this.printType(classArray[j]) + "    " + iD + (n == 1 || n - 1 == j ? ")" : ","));
                propertyManagerArray[j] = new PropertyManager(this, classArray[j]);
                this.put(iD, propertyManagerArray[j]);
            }
            if (method.getReturnType().isArray()) {
                this.registerArrayEncoder(method.getReturnType());
            }
            iD = ID.registerProperty(string);
            MethodPM methodPM = new MethodPM(this, method, propertyManagerArray);
            this.put(iD, methodPM);
            iD = ID.registerProperty(string + "$0");
            ArgumentPM argumentPM = new ArgumentPM(this, propertyManagerArray);
            this.put(iD, argumentPM);
        }
    }

    private void registerProperties(BeanInfo beanInfo) {
        this.log("Registering properties");
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            PropertyManager propertyManager;
            String string = propertyDescriptorArray[i].getName();
            String string2 = this.getUniquePropName(string);
            PropertyMask propertyMask = PropertyMask.GETTABLE;
            Class<?> clazz = propertyDescriptorArray[i].getPropertyType();
            if (clazz == null) {
                this.tablog("Null type for property " + string2);
                continue;
            }
            if (propertyDescriptorArray[i] instanceof IndexedPropertyDescriptor) {
                if (clazz != null && clazz.getComponentType() != null) {
                    this.tablog(this.printType(clazz.getComponentType()) + " " + string2);
                }
                IndexedPropertyDescriptor indexedPropertyDescriptor = (IndexedPropertyDescriptor)propertyDescriptorArray[i];
                clazz = indexedPropertyDescriptor.getIndexedPropertyType();
                propertyManager = this.registerIndexedProperty(string2, indexedPropertyDescriptor);
            } else if (clazz.isArray()) {
                this.registerArrayEncoder(clazz);
                propertyManager = new PropertyPM(this, propertyDescriptorArray[i]);
                this.tablog(this.printType(clazz) + " " + string2);
            } else {
                propertyManager = new PropertyPM(this, propertyDescriptorArray[i]);
                this.tablog(this.printType(clazz) + " " + string2);
            }
            if (propertyDescriptorArray[i].getWriteMethod() != null) {
                propertyMask = PropertyMask.addMasks(propertyMask, PropertyMask.SETTABLE);
            }
            if (string == null) continue;
            ID iD = ID.registerProperty(string2);
            this.put(iD, propertyManager);
        }
    }

    private static Class convertToObjectType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
        }
        return clazz;
    }

    static {
        try {
            for (int i = 0; i < sTypes.length; ++i) {
                sET.put(sTypes[i], sEncoders[i].getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

