/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.perf;

import java.text.DateFormat;
import java.util.Date;

public class Perf {
    private static int sLastInstNum = 0;
    private String mSessionID;
    private long mElapsedStart = 0L;
    boolean mTimerActive = false;
    private long mTimerStart = 0L;
    private long mTimerTotal = 0L;
    private long mLastLap = 0L;
    private long mLongLapThreshold = 1000000L;
    private long mCntLaps = 0L;
    private long mCntShortLaps = 0L;
    private long mTimerShortTotal = 0L;
    private int mTotalInputBytes;
    private int mTotalOutputBytes;

    private static synchronized String nextInstNum() {
        return ".." + String.valueOf(++sLastInstNum);
    }

    private static synchronized void writeLog(String string) {
        System.out.println(string);
    }

    public Perf() {
        this(null);
    }

    public Perf(String string) {
        this.mSessionID = string != null ? string : Perf.nextInstNum();
        this.mElapsedStart = System.currentTimeMillis();
        this.mTotalInputBytes = 0;
        this.mTotalOutputBytes = 0;
    }

    private static String getCurrentTime() {
        return DateFormat.getDateInstance().format(new Date());
    }

    public void elapsedMsg(String string) {
        long l = System.currentTimeMillis() - this.mElapsedStart;
        String string2 = this.formatMillis(l);
        Perf.writeLog("Perf(" + this.mSessionID + "): " + string2 + string + "\n");
    }

    public void resetElapsed() {
        this.mElapsedStart = System.currentTimeMillis();
    }

    public void setLongLapThreshold(long l) {
        this.mLongLapThreshold = l;
    }

    public void resetTimer() {
        this.mTimerActive = false;
        this.mTimerStart = 0L;
        this.mTimerTotal = 0L;
        this.mLastLap = 0L;
        this.mLongLapThreshold = 1000000L;
        this.mCntLaps = 0L;
        this.mCntShortLaps = 0L;
        this.mTimerShortTotal = 0L;
    }

    public void stopTimer() {
        if (!this.mTimerActive) {
            return;
        }
        this.mLastLap = System.currentTimeMillis() - this.mTimerStart;
        this.mTimerActive = false;
        this.mTimerTotal += this.mLastLap;
        ++this.mCntLaps;
        if (this.mLastLap < this.mLongLapThreshold) {
            this.mTimerShortTotal += this.mLastLap;
            ++this.mCntShortLaps;
        }
    }

    public void startTimer() {
        this.mTimerActive = true;
        this.mTimerStart = System.currentTimeMillis();
    }

    public Object[] getTimerValues(int n, int n2) {
        long l = this.mLastLap;
        if (this.mTimerActive) {
            long l2 = System.currentTimeMillis();
            l = l2 - this.mTimerStart;
        }
        Object[] objectArray = new Object[4];
        objectArray[0] = this.formatMillis(l);
        objectArray[1] = Integer.toString(n);
        objectArray[2] = Integer.toString(n2);
        return objectArray;
    }

    public String getFullStatsMsg() {
        Object[] objectArray = this.getFullStatsValues();
        return "            Total duration of network exchanges: " + objectArray[0] + "\n            Total number of network exchanges: " + objectArray[1] + " (" + objectArray[2] + " \"long\" ones over " + objectArray[3] + " sec)\n            Average time for one network exchange(excluding long ones): " + objectArray[4] + "\n            Total bytes: sent " + objectArray[5] + ", received " + objectArray[5];
    }

    public int getBytesSent() {
        return this.mTotalOutputBytes;
    }

    public int getBytesRecvd() {
        return this.mTotalInputBytes;
    }

    public long getRoundTrips() {
        return this.mCntLaps;
    }

    public Object[] getFullStatsValues() {
        long l = this.mCntShortLaps > 0L ? this.mTimerShortTotal / this.mCntShortLaps : 0L;
        Object[] objectArray = new Object[]{this.formatMillis(this.mTimerTotal), Long.toString(this.mCntLaps), Long.toString(this.mCntLaps - this.mCntShortLaps), this.formatMillis(this.mLongLapThreshold), this.formatMillis(l), Integer.toString(this.mTotalOutputBytes), Integer.toString(this.mTotalInputBytes)};
        return objectArray;
    }

    public void incrementByteCounts(int n, int n2) {
        this.mTotalInputBytes += n;
        this.mTotalOutputBytes += n2;
    }

    private String formatMillis(long l) {
        StringBuffer stringBuffer = new StringBuffer(Long.toString(l));
        while (stringBuffer.length() < 4) {
            stringBuffer.insert(0, "0");
        }
        stringBuffer.insert(stringBuffer.length() - 3, ".");
        return stringBuffer.toString();
    }
}

