/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net2;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLContext;
import oracle.forms.net.FURLConnection;

public class F2URLConnection
extends FURLConnection {
    private boolean mConnected = false;
    private boolean mDoOutput = false;
    private boolean mUseCaches = true;
    private boolean mIsSSL = false;
    private URI mURI = null;
    private long mIfModifiedSince = 0L;
    private int mReadTimeout = 0;
    private String mRequestMethod = "GET";
    private HttpRequest.Builder mRequestBuilder = HttpRequest.newBuilder();
    private byte[] mRequestBody = null;
    private int mRequestBodyOff = 0;
    private int mRequestBodyLen = 0;
    private HttpResponse<InputStream> mResponse = null;
    private int mConnectTimeout = 0;
    private boolean mInstanceFollowRedirects = true;
    private SSLContext mSSLContext = null;
    private static List<Connection> sConnections = new LinkedList<Connection>();
    private static final Object sConnectionLock = new Object();

    public F2URLConnection(URL uRL) throws IOException {
        super(uRL);
        try {
            this.mURI = uRL.toURI();
            this.mRequestBuilder.uri(this.mURI);
        }
        catch (IllegalArgumentException | URISyntaxException exception) {
            throw new MalformedURLException();
        }
        this.mIsSSL = F2URLConnection.isSSL(uRL);
    }

    private static boolean isSSL(URL uRL) {
        String string = uRL.getProtocol().toLowerCase(Locale.ROOT);
        return "https".equals(string) || "wss".equals(string);
    }

    private void checkNotConnected() {
        if (this.mConnected) {
            throw new IllegalStateException("Already connected");
        }
    }

    @Override
    public void applySslContext(SSLContext sSLContext) {
        if (!this.mIsSSL) {
            throw new UnsupportedOperationException();
        }
        this.checkNotConnected();
        this.mSSLContext = sSLContext;
    }

    @Override
    public void setConnectTimeout(int n) {
        this.checkNotConnected();
        this.mConnectTimeout = n;
    }

    @Override
    public void setReadTimeout(int n) {
        this.checkNotConnected();
        this.mReadTimeout = n;
    }

    @Override
    public void setDoOutput(boolean bl) {
        this.checkNotConnected();
        this.mDoOutput = bl;
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.checkNotConnected();
        this.mUseCaches = bl;
    }

    @Override
    public void setIfModifiedSince(long l) {
        this.checkNotConnected();
        this.mIfModifiedSince = l;
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.checkNotConnected();
        this.mRequestBuilder.setHeader(string, string2);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.checkNotConnected();
        this.mRequestBuilder.header(string, string2);
    }

    @Override
    public void setInstanceFollowRedirects(boolean bl) {
        this.checkNotConnected();
        this.mInstanceFollowRedirects = bl;
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.mInstanceFollowRedirects;
    }

    @Override
    public void setRequestMethod(String string) {
        this.mRequestMethod = string;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        this.checkNotConnected();
        return new OutputStream(){

            @Override
            public void write(int n) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(byte[] byArray, int n, int n2) {
                if (F2URLConnection.this.mRequestBody != null) {
                    throw new IllegalStateException("multiple writes not allowed");
                }
                F2URLConnection.access$002(F2URLConnection.this, byArray);
                F2URLConnection.this.mRequestBodyOff = n;
                F2URLConnection.this.mRequestBodyLen = n2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        if (!this.mConnected) {
            Object object = sConnectionLock;
            synchronized (object) {
                HttpRequest httpRequest;
                Object object2;
                Object object3;
                HttpClient httpClient = null;
                if (this.mSSLContext == null) {
                    for (Connection object42 : sConnections) {
                        if (object42.mConnectTimeout != this.mConnectTimeout || object42.mInstanceFollowRedirects != this.mInstanceFollowRedirects) continue;
                        httpClient = object42.mClient;
                        break;
                    }
                }
                if (httpClient == null) {
                    object3 = HttpClient.newBuilder();
                    object3.connectTimeout(this.mConnectTimeout == 0 ? Duration.ofDays(1L) : Duration.ofMillis(this.mConnectTimeout));
                    CookieHandler cookieHandler = CookieHandler.getDefault();
                    if (cookieHandler != null) {
                        object3.cookieHandler(cookieHandler);
                    }
                    object3.followRedirects(this.mInstanceFollowRedirects ? HttpClient.Redirect.ALWAYS : HttpClient.Redirect.NEVER);
                    if (!F2URLConnection.getUseHttp2()) {
                        object3.version(HttpClient.Version.HTTP_1_1);
                    }
                    if (this.mSSLContext != null) {
                        object3.sslContext(this.mSSLContext);
                    }
                    httpClient = object3.build();
                    if (this.mSSLContext == null) {
                        Connection interruptedException = new Connection();
                        interruptedException.mConnectTimeout = this.mConnectTimeout;
                        interruptedException.mInstanceFollowRedirects = this.mInstanceFollowRedirects;
                        interruptedException.mClient = httpClient;
                        sConnections.add(0, interruptedException);
                    }
                    if (!this.mIsSSL && F2URLConnection.getUseHttp2() && this.mRequestBodyLen > 0) {
                        Object var6_7 = null;
                        object2 = HttpRequest.newBuilder();
                        object2.uri(this.mURI);
                        if (this.mReadTimeout != 0) {
                            object2.timeout(Duration.ofMillis(this.mReadTimeout));
                        }
                        object2.method("OPTIONS", HttpRequest.BodyPublishers.noBody());
                        try {
                            httpRequest = object2.build();
                            HttpResponse<Void> httpResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.discarding());
                        }
                        catch (InterruptedException interruptedException) {
                            throw new InterruptedIOException();
                        }
                    }
                }
                if (this.mReadTimeout != 0) {
                    this.mRequestBuilder.timeout(Duration.ofMillis(this.mReadTimeout));
                }
                object3 = this.mRequestBodyLen > 0 ? HttpRequest.BodyPublishers.ofByteArray(this.mRequestBody, this.mRequestBodyOff, this.mRequestBodyLen) : HttpRequest.BodyPublishers.noBody();
                if (this.mDoOutput) {
                    this.mRequestMethod = "POST";
                }
                this.mRequestBuilder.method(this.mRequestMethod, (HttpRequest.BodyPublisher)object3);
                if (this.mIfModifiedSince > 0L) {
                    DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
                    object2 = dateTimeFormatter.format(Instant.ofEpochMilli(this.mIfModifiedSince));
                    this.mRequestBuilder.setHeader("if-modified-since", (String)object2);
                }
                if (!this.mUseCaches) {
                    this.mRequestBuilder.setHeader("cache-control", "no-cache,no-store");
                }
                try {
                    httpRequest = this.mRequestBuilder.build();
                    this.mResponse = httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
                }
                catch (InterruptedException interruptedException) {
                    throw new InterruptedIOException();
                }
                this.mRequestBody = null;
                this.mConnected = true;
            }
        }
    }

    @Override
    public String getHeaderField(String string) throws IOException {
        this.connect();
        List<String> list = this.mResponse.headers().allValues(string);
        int n = list.size();
        return n == 0 ? null : list.get(n - 1);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() throws IOException {
        this.connect();
        return this.mResponse.headers().map();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.mResponse.body();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.connect();
        return this.mResponse.statusCode();
    }

    static /* synthetic */ byte[] access$002(F2URLConnection f2URLConnection, byte[] byArray) {
        f2URLConnection.mRequestBody = byArray;
        return byArray;
    }

    private static class Connection {
        private int mConnectTimeout = 0;
        private boolean mInstanceFollowRedirects = true;
        private HttpClient mClient = null;

        private Connection() {
        }
    }
}

