/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.DataOutputStream;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.Message;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.SingleAccessorQueue;

public class StreamMessageWriter
extends Thread {
    private DataOutputStream mDataStream;
    private SingleAccessorQueue mQueue;
    private int mCacheId;
    private FormsDispatcher mRunform;
    private boolean mKilled = false;

    public StreamMessageWriter(FormsDispatcher formsDispatcher, DataOutputStream dataOutputStream, int n, int n2) {
        super("Forms-StreamMessageWriter");
        this.mRunform = formsDispatcher;
        this.mDataStream = dataOutputStream;
        this.mQueue = new SingleAccessorQueue(n);
        this.mCacheId = n2;
    }

    public void put(Object object) throws InterruptedException {
        if (this.isAlive()) {
            this.mQueue.put(object);
        }
    }

    public void kill() {
        if (this.mKilled) {
            return;
        }
        this.mKilled = true;
        Message.destroyMessageCache(this.mCacheId);
        this.mQueue.destroy();
        this.mDataStream = null;
        this.mRunform = null;
        this.mQueue = null;
    }

    @Override
    public void run() {
        block5: {
            try {
                while (true) {
                    Object object = this.mQueue.get();
                    if (!this.mKilled) {
                        if (object instanceof Message) {
                            ((Message)object).writeDetails(this.mRunform, this.mCacheId, this.mDataStream);
                            continue;
                        }
                        if (!(object instanceof TerminalMessage)) continue;
                        ((TerminalMessage)object).writeDetails(this.mDataStream);
                        this.mDataStream.flush();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception exception) {
                TerminalMessage terminalMessage = new TerminalMessage(-1);
                if (this.mRunform == null) break block5;
                this.mRunform.terminalDelivered(terminalMessage);
            }
        }
    }
}

