/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.DataInputStream;
import java.util.Vector;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.Message;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.MessageQueue;
import oracle.forms.test.Test;

public class StreamMessageReader
extends Thread {
    private DataInputStream mDataStream;
    private MessageQueue mQueue;
    private int mCacheId;
    private int mMessagesReceivedCount = 0;
    private Vector mMessageWaitersList = new Vector();
    private Vector mTerminalWaitersList = new Vector();
    private Vector mASyncWaitersList = new Vector();
    private FormsDispatcher mRunform;
    private boolean mKilled = false;
    private boolean mReaderActive = true;
    private static final boolean DEBUG = false;
    private static final boolean TRACE = false;

    public StreamMessageReader(FormsDispatcher formsDispatcher, DataInputStream dataInputStream, int n, int n2) {
        super("Forms-StreamMessageReader");
        this.mRunform = formsDispatcher;
        this.mDataStream = dataInputStream;
        this.mQueue = new MessageQueue();
        this.mCacheId = n2;
    }

    public synchronized Object get() throws InterruptedException {
        if (this.mReaderActive) {
            return this.mQueue.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block15: {
            boolean bl = false;
            try {
                while (!this.mKilled) {
                    Test test = Message.readDetails(this.mCacheId, this.mDataStream);
                    if (test == null) {
                        test = TerminalMessage.readDetails(this.mDataStream);
                        int n = ((TerminalMessage)test).getResponseCode();
                        if (n == 1 || n == 3) {
                            bl = true;
                        }
                        this.mRunform.terminalDelivered((TerminalMessage)test);
                    } else {
                        this.mRunform.messageDelivered((Message)test);
                    }
                    MessageQueue messageQueue = this.mQueue;
                    synchronized (messageQueue) {
                        this.mQueue.add(test);
                        this.mQueue.notifyAll();
                    }
                    ++this.mMessagesReceivedCount;
                    if (!bl) continue;
                    this.wakeupTerminalWaiters();
                    bl = false;
                }
            }
            catch (Exception exception) {
                Object object;
                block14: {
                    try {
                        if (this.mQueue == null) break block14;
                        object = this.mQueue;
                        synchronized (object) {
                            this.mQueue.add(exception);
                            this.mQueue.notifyAll();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                object = new TerminalMessage(-1);
                if (this.mRunform == null) break block15;
                this.mRunform.terminalDelivered((TerminalMessage)object);
            }
        }
        this.cleanupReader();
    }

    public int getMessagesReceivedCount() {
        return this.mMessagesReceivedCount;
    }

    public synchronized void addMessageListener(Object object) {
        if (!this.mReaderActive) {
            return;
        }
        this.mMessageWaitersList.addElement(object);
    }

    public synchronized void removeMessageListener(Object object) {
        if (!this.mReaderActive) {
            return;
        }
        this.mMessageWaitersList.removeElement(object);
    }

    public synchronized void addTerminalListener(Object object) {
        if (!this.mReaderActive) {
            return;
        }
        this.mTerminalWaitersList.addElement(object);
    }

    public synchronized void removeTerminalListener(Object object) {
        if (!this.mReaderActive) {
            return;
        }
        this.mTerminalWaitersList.removeElement(object);
    }

    public synchronized void kill() {
        if (this.mKilled) {
            return;
        }
        this.mKilled = true;
        this.mQueue.destroy();
        Message.destroyMessageCache(this.mCacheId);
        this.cleanupReader();
        this.mQueue = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void wakeupMessageWaiters() {
        if (!this.mReaderActive) {
            return;
        }
        int n = this.mMessageWaitersList.size();
        for (int i = 0; i < n; ++i) {
            Object e;
            Object e2 = e = this.mMessageWaitersList.elementAt(i);
            synchronized (e2) {
                e.notify();
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void wakeupTerminalWaiters() {
        if (!this.mReaderActive) {
            return;
        }
        int n = this.mTerminalWaitersList.size();
        for (int i = 0; i < n; ++i) {
            Object e;
            Object e2 = e = this.mTerminalWaitersList.elementAt(i);
            synchronized (e2) {
                e.notify();
                continue;
            }
        }
    }

    public synchronized MessageQueue getInputMessageQueue() {
        if (!this.mReaderActive) {
            return null;
        }
        return this.mQueue;
    }

    private synchronized void cleanupReader() {
        if (!this.mReaderActive) {
            return;
        }
        this.mRunform.setReaderActive(false);
        this.wakeupMessageWaiters();
        this.wakeupTerminalWaiters();
        this.mMessageWaitersList.removeAllElements();
        this.mMessageWaitersList = null;
        this.mTerminalWaitersList.removeAllElements();
        this.mTerminalWaitersList = null;
        this.mASyncWaitersList.removeAllElements();
        this.mASyncWaitersList = null;
        this.mRunform = null;
        this.mDataStream = null;
        this.mReaderActive = false;
    }
}

