/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Random;
import oracle.forms.engine.DispatcherEnvironment;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.Message;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.Connection;
import oracle.forms.net.EncryptedInputStream;
import oracle.forms.net.EncryptedOutputStream;
import oracle.forms.net.MessageQueue;
import oracle.forms.net.StreamMessageReader;
import oracle.forms.net.StreamMessageWriter;
import oracle.forms.registry.MessageGenerator;

public class SocketConnection
implements Connection {
    private static final int ENCRYPTED_STREAM_BUFSIZE = 4096;
    private Socket mSocket;
    private String mServerHost;
    private int mServerPort;
    private StreamMessageReader mReader;
    private StreamMessageWriter mWriter;
    private int mMessagesSentCount = 0;
    private int mRoundTripsCount = 0;
    private EncryptedOutputStream mEOS;
    private EncryptedInputStream mEIS;
    private boolean mPrintSrvDetails = true;
    private MessageQueue mOutputMessageQueue = new MessageQueue();
    private final FormsDispatcher mDispatcher;
    private final DispatcherEnvironment mEnvironment;
    private final MessageGenerator mEMG;
    public static String NET_DEFAULT_PORT = "9000";
    private static int NEG_SEND = 1195663737;
    private static int NEG_RESPONSE = 1298232421;

    public SocketConnection(FormsDispatcher formsDispatcher, String string, int n, boolean bl) {
        this.mDispatcher = formsDispatcher;
        this.mEnvironment = this.mDispatcher.getDispatcherEnvironment();
        this.mEMG = this.mDispatcher.getErrorMessageGenerator();
        this.mServerHost = string;
        this.mServerPort = n;
        this.mPrintSrvDetails = bl;
    }

    @Override
    public void connect(FormsDispatcher formsDispatcher) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            System.out.println(this.mEMG.getMessage("FRM-92816", "SOCKET"));
            if (this.mPrintSrvDetails) {
                System.out.println(this.mEMG.getMessage("FRM-92818", this.mServerHost, Integer.toString(this.mServerPort)));
            }
            this.mSocket = new Socket(this.mServerHost, this.mServerPort);
            this.mEOS = new EncryptedOutputStream(this.mSocket.getOutputStream(), 4096);
            this.mEIS = new EncryptedInputStream(this.mSocket.getInputStream(), 4096);
            DataOutputStream dataOutputStream = new DataOutputStream(this.mEOS);
            DataInputStream dataInputStream = new DataInputStream(this.mEIS);
            dataOutputStream.writeInt(NEG_SEND);
            n = new Random().nextInt();
            dataOutputStream.writeInt(n);
            dataOutputStream.flush();
            n3 = dataInputStream.readInt();
            n2 = dataInputStream.readInt();
            if (n3 == NEG_RESPONSE) {
                byte[] byArray = new byte[]{(byte)(n >> 8), (byte)(n2 >> 4), -82, (byte)(n >> 16), (byte)(n2 >> 12)};
                this.mEIS.setEncryptKey(byArray);
                this.mEOS.setEncryptKey(byArray);
            }
            if (n3 == NEG_RESPONSE + 1) {
                // empty if block
            }
            this.mReader = new StreamMessageReader(this.mDispatcher, dataInputStream, 100, Message.createMessageCache());
            this.mWriter = new StreamMessageWriter(this.mDispatcher, dataOutputStream, 5, -1);
            this.mReader.start();
            this.mWriter.start();
        }
        catch (IOException iOException) {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
            throw iOException;
        }
    }

    @Override
    public void putMessage(Message message) throws Exception {
        this.mWriter.put(message);
        ++this.mMessagesSentCount;
    }

    @Override
    public void putTerminal(TerminalMessage terminalMessage) throws Exception {
        this.mWriter.put(terminalMessage);
        ++this.mMessagesSentCount;
        ++this.mRoundTripsCount;
    }

    @Override
    public Object get() throws Exception {
        return this.mReader.get();
    }

    @Override
    public void disconnect() throws Exception {
        this.mReader.kill();
        this.mWriter.kill();
        try {
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        catch (Exception exception) {
            System.out.println(this.mEMG.getMessage("FRM-92530", exception.getMessage()));
            exception.printStackTrace(System.out);
        }
        this.mOutputMessageQueue.destroy();
        this.mEOS = null;
        this.mEIS = null;
        this.mReader = null;
        this.mWriter = null;
        this.mSocket = null;
        this.mOutputMessageQueue = null;
    }

    @Override
    public void resetRoundTripsCount() {
        this.mRoundTripsCount = 0;
    }

    @Override
    public int getRoundTripsCount() {
        return this.mRoundTripsCount;
    }

    @Override
    public int getMessagesSentCount() {
        return this.mMessagesSentCount;
    }

    @Override
    public int getMessagesReceivedCount() {
        return this.mReader.getMessagesReceivedCount();
    }

    @Override
    public void resetBytesCount() {
    }

    @Override
    public int getBytesCount() {
        return this.mEIS.getBytesCount() + this.mEOS.getBytesCount();
    }

    @Override
    public int getBytesReceivedCount() {
        return this.mEIS.getBytesCount();
    }

    @Override
    public int getBytesSentCount() {
        return this.mEOS.getBytesCount();
    }

    @Override
    public MessageQueue getInputMessageQueue() {
        return this.mReader.getInputMessageQueue();
    }

    @Override
    public MessageQueue getOutputMessageQueue() {
        return this.mOutputMessageQueue;
    }

    @Override
    public synchronized void addMessageListener(Object object) {
        this.mReader.addMessageListener(object);
    }

    @Override
    public synchronized void removeMessageListener(Object object) {
        this.mReader.removeMessageListener(object);
    }

    @Override
    public synchronized void removeTerminalListener(Object object) {
        this.mReader.removeTerminalListener(object);
    }

    @Override
    public synchronized void addTerminalListener(Object object) {
        this.mReader.addTerminalListener(object);
    }
}

