/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.PrintStream;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.MessageNode;

public class MessageQueue {
    private MessageNode mHead = null;
    private MessageNode mTail = null;
    private int mCount = 0;
    private int mTerminalCount = 0;
    private boolean mDestroyed = false;
    private static final boolean DEBUG = false;

    public synchronized void add(Object object) {
        if (object == null) {
            return;
        }
        this.updateTerminalCount(object, true);
        ++this.mCount;
        if (this.mTail == null) {
            this.mHead = this.mTail = new MessageNode(object);
            return;
        }
        MessageNode messageNode = new MessageNode(object);
        this.mTail.setNext(messageNode);
        this.mTail = messageNode;
    }

    public synchronized void addAt(Object object, int n) throws IndexOutOfBoundsException {
        if (this.mCount == n) {
            this.add(object);
            return;
        }
        MessageNode messageNode = new MessageNode(object);
        if (n == 0) {
            messageNode.setNext(this.mHead);
            this.mHead = messageNode;
        } else {
            MessageNode messageNode2 = this.getNodeAt(n - 1);
            messageNode.setNext(messageNode2.getNext());
            messageNode2.setNext(messageNode);
        }
        ++this.mCount;
        this.updateTerminalCount(object, true);
    }

    public synchronized void destroy() {
        this.notifyAll();
        for (int i = 0; i < this.mCount; ++i) {
            this.removeAt(i);
        }
        this.mDestroyed = true;
        this.mHead = null;
        this.mTail = null;
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    public synchronized Object remove() throws IndexOutOfBoundsException {
        if (this.isDestroyed()) {
            return null;
        }
        if (this.mCount == 0 || this.mHead == null) {
            throw new IndexOutOfBoundsException("Deleting from an empty MessageQueue");
        }
        Object object = this.mHead.getData();
        --this.mCount;
        if (this.mHead == this.mTail) {
            this.mTail = null;
            this.mHead = null;
        } else {
            this.mHead = this.mHead.getNext();
        }
        this.updateTerminalCount(object, false);
        return object;
    }

    public synchronized Object removeAt(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.remove();
        }
        if (this.mCount == 0 || n >= this.mCount || n < 0 || this.mHead == null) {
            throw new IndexOutOfBoundsException(Integer.valueOf(n).toString() + " Index out of bounds in Message Queue");
        }
        MessageNode messageNode = this.getNodeAt(n - 1);
        MessageNode messageNode2 = messageNode.getNext();
        messageNode.setNext(messageNode2.getNext());
        if (messageNode2 == this.mTail) {
            this.mTail = messageNode;
        }
        --this.mCount;
        if (this.mCount == 0) {
            this.mTail = null;
            this.mHead = null;
        }
        this.updateTerminalCount(messageNode2.getData(), false);
        return messageNode2.getData();
    }

    public synchronized Object get() throws IndexOutOfBoundsException {
        return this.getNodeAt(0).getData();
    }

    public synchronized Object getAt(int n) throws IndexOutOfBoundsException {
        return this.getNodeAt(n).getData();
    }

    public synchronized int size() {
        return this.mCount;
    }

    public synchronized boolean hasTerminal() {
        return this.mTerminalCount != 0;
    }

    public synchronized boolean syncCheck(int n) {
        return this.mTerminalCount == n;
    }

    private MessageNode getNodeAt(int n) throws IndexOutOfBoundsException {
        if (this.mCount == 0 || n >= this.mCount || n < 0 || this.mHead == null) {
            throw new IndexOutOfBoundsException(Integer.valueOf(n).toString() + " Index out of bounds in Message Queue");
        }
        MessageNode messageNode = this.mHead;
        for (int i = 0; i < n; ++i) {
            messageNode = messageNode.getNext();
        }
        return messageNode;
    }

    private void updateTerminalCount(Object object, boolean bl) {
        if (object != null && object instanceof TerminalMessage && ((TerminalMessage)object).getResponseCode() != 2) {
            this.mTerminalCount = bl ? ++this.mTerminalCount : --this.mTerminalCount;
        }
    }

    public void listProperties(PrintStream printStream, String string) {
    }
}

