/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import oracle.forms.engine.DispatcherEnvironment;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.net.EncryptedInputStream;
import oracle.forms.net.EncryptedOutputStream;
import oracle.forms.net.HTTPHeaderTool;
import oracle.forms.net.HTTPInputStream;
import oracle.forms.perf.Perf;
import oracle.forms.registry.MessageGenerator;

public class HTTPStream
extends OutputStream {
    private static final int IXH_MAX_DATA_LENGTH = 65520;
    public static final String NULLPOST_STR = "NULLPOST";
    public static final String NULLRESP_STR = "NULLRESP";
    private static final int ENCRYPTED_STREAM_BUFSIZE = 8192;
    protected byte[] mOutBuf;
    protected int mLength = 0;
    private int mLengthPreviousFlush = 0;
    protected byte[] mInBuf = new byte[65520];
    protected EncryptedOutputStream mEout;
    protected EncryptedInputStream mEin;
    protected HTTPInputStream mHis;
    protected InputStream mIn;
    protected boolean mHTTP1_0mode;
    protected boolean mConnectionEstablished;
    protected boolean mTransportClosed;
    protected Socket mSocket;
    protected int mConnectionType;
    protected String mConnectHost;
    protected int mConnectPort;
    protected String mServerHost;
    protected int mServerPort;
    protected int mSessionId;
    protected Perf mPerf = null;
    protected byte[] mencryptKey;
    protected boolean mencryptKeySet;
    protected int[] minSeedBuffer;
    protected int[] moutSeedBuffer;
    protected int[] minIndexBuffer;
    protected int[] moutIndexBuffer;
    protected HTTPHeaderTool mHTTPHeaderTool;
    protected int mHeaderLength;
    private int mHeaderBytes = 0;
    private int mConnectCnt = 0;
    protected final DispatcherEnvironment mEnvironment;
    protected final MessageGenerator mEMG;

    public HTTPStream(FormsDispatcher formsDispatcher, String string, int n, HTTPInputStream hTTPInputStream, String string2, int n2, URL uRL, int n3, boolean bl) {
        this.mOutBuf = new byte[65520];
        this.mHis = hTTPInputStream;
        this.mEnvironment = formsDispatcher.getDispatcherEnvironment();
        this.mEMG = formsDispatcher.getErrorMessageGenerator();
        if (uRL == null) {
            this.mServerHost = string2;
            this.mServerPort = n2;
        } else {
            this.mServerHost = uRL.getHost();
            this.mServerPort = uRL.getPort();
            if (this.mServerPort == -1) {
                this.mServerPort = n3 == 4 ? 443 : 80;
            }
        }
        if (string == null) {
            this.mConnectHost = this.mServerHost;
            this.mConnectPort = this.mServerPort;
        } else {
            this.mConnectHost = string;
            this.mConnectPort = n;
        }
        this.mConnectionType = n3;
        this.mHTTP1_0mode = bl;
        this.mTransportClosed = true;
        this.mConnectionEstablished = false;
        this.mSessionId = -1;
        this.mencryptKey = null;
        this.minSeedBuffer = null;
        this.moutSeedBuffer = null;
        this.minIndexBuffer = null;
        this.moutIndexBuffer = null;
        this.mencryptKeySet = false;
        this.mHTTPHeaderTool = new HTTPHeaderTool(string, n, string2, n2, uRL);
    }

    public void connect() throws IOException {
        int n = 10;
        for (int i = 0; i < n; ++i) {
            try {
                this.mSocket = new Socket(this.mConnectHost, this.mConnectPort);
                if (i > 0) {
                    System.out.println(this.mEMG.getMessage("FRM-92870", i));
                }
                i = n;
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                throw unknownHostException;
            }
            catch (IOException iOException) {
                if (i >= n - 1) {
                    System.out.println(this.mEMG.getMessage("FRM-92572", i + 1));
                    throw iOException;
                }
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.mencryptKeySet) {
            this.minSeedBuffer = this.mEin.getSeedBuffer();
            this.moutSeedBuffer = this.mEout.getSeedBuffer();
            this.minIndexBuffer = this.mEin.getIndexVars();
            this.moutIndexBuffer = this.mEout.getIndexVars();
            this.mEout = new EncryptedOutputStream(this.mSocket.getOutputStream(), 8192);
            this.mEin = new EncryptedInputStream(this.mSocket.getInputStream(), 8192);
            this.mEin.setSeedBuffer(this.minSeedBuffer);
            this.mEout.setSeedBuffer(this.moutSeedBuffer);
            this.mEin.setIndexVars(this.minIndexBuffer);
            this.mEout.setIndexVars(this.moutIndexBuffer);
        } else {
            this.mEout = new EncryptedOutputStream(this.mSocket.getOutputStream(), 8192);
            this.mEin = new EncryptedInputStream(this.mSocket.getInputStream(), 8192);
        }
        this.mIn = this.mSocket.getInputStream();
        this.mTransportClosed = false;
        this.mConnectionEstablished = true;
        ++this.mConnectCnt;
    }

    @Override
    public void close() throws IOException {
        if (this.mConnectionEstablished) {
            if (this.mConnectionType == 3 && (this.mTransportClosed || !this.isSocketOpen())) {
                try {
                    this.connect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.mHis.notifyClose();
            }
            String string = this.mHTTPHeaderTool.makeRequestHeader(0, true);
            this.mHeaderLength = string.length();
            byte[] byArray = string.getBytes();
            this.mEout.write(byArray, 0, this.mHeaderLength);
            this.mEout.eflush(this.mHeaderLength);
            if (this.mSocket != null) {
                this.mSocket.close();
            }
        }
        this.mTransportClosed = true;
        this.mConnectionEstablished = false;
        this.mHis.notifyClose();
    }

    public void setEncryptKey(byte[] byArray) {
        this.mencryptKey = byArray;
        this.mEout.setEncryptKey(this.mencryptKey);
        this.mEin.setEncryptKey(this.mencryptKey);
        this.mencryptKeySet = true;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.mOutBuf[this.mLength++] = (byte)n;
        if (this.mLength == 65520) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 65520 - this.mLength;
        if (n2 >= n3) {
            System.arraycopy(byArray, n, this.mOutBuf, this.mLength, n3);
            this.mLength = 65520;
            this.flush();
            n += n3;
            n2 -= n3;
            while (n2 >= 65520) {
                System.arraycopy(byArray, n, this.mOutBuf, 0, 65520);
                this.mLength = 65520;
                this.flush();
                n += 65520;
                n2 -= 65520;
            }
        }
        System.arraycopy(byArray, n, this.mOutBuf, this.mLength, n2);
        this.mLength += n2;
    }

    protected void doPost(int n, boolean bl) throws IOException {
        String string = this.mHTTPHeaderTool.makeRequestHeader(n, false);
        this.mHeaderLength = string.length();
        byte[] byArray = string.getBytes();
        this.mEout.write(byArray, 0, this.mHeaderLength);
        this.mEout.write(this.mOutBuf, 0, n);
        if (bl) {
            this.mEout.eflush(this.mHeaderLength + NULLPOST_STR.length());
        } else {
            this.mEout.eflush(this.mHeaderLength);
        }
    }

    protected int getResponse() throws IOException {
        String string;
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            this.mHeaderBytes = 0;
            while ((n = this.mHTTPHeaderTool.parseResponseHeader(this.mIn, -1)) < 0) {
            }
            this.mHeaderBytes = n;
        }
        catch (EOFException eOFException) {
            this.mTransportClosed = true;
            return -1;
        }
        n3 = this.mHTTPHeaderTool.getStatus();
        if (n3 > 200) {
            String string2 = this.mHTTPHeaderTool.getHttpStatusMessage();
            throw new IOException(string2);
        }
        this.mHTTP1_0mode = this.mHTTPHeaderTool.isHTTP1dot0();
        this.mTransportClosed = this.mHTTPHeaderTool.getConnectionClosed();
        if (this.mTransportClosed) {
            // empty if block
        }
        n2 = this.mHTTPHeaderTool.getContentLength();
        this.mSessionId = this.mHTTPHeaderTool.getSessionId();
        if (n2 > 0) {
            if (n2 > this.mInBuf.length) {
                this.mInBuf = new byte[n2];
            }
            int n5 = n2;
            while (n5 > 0) {
                n = this.mEin.read(this.mInBuf, n4, n5);
                if (n <= 0) {
                    this.mTransportClosed = true;
                }
                n5 -= n;
                n4 += n;
            }
        }
        if (n2 == 8 && (string = new String(this.mInBuf, 0, 8)).equalsIgnoreCase(NULLRESP_STR)) {
            return n2;
        }
        if (n2 > 0) {
            try {
                this.mHis.filldata(this.mInBuf, n2);
            }
            catch (Exception exception) {
                System.out.println(this.mEMG.getMessage("FRM-92574", exception.toString()));
                exception.printStackTrace(System.out);
            }
        }
        if (this.mHTTP1_0mode || this.mTransportClosed) {
            this.mTransportClosed = true;
            this.mSocket.close();
        }
        return n2;
    }

    @Override
    public synchronized void flush() throws IOException {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        if (this.mLength == 0) {
            if (this.mLengthPreviousFlush < 65520) {
                return;
            }
            this.mLength = NULLPOST_STR.length();
            System.arraycopy(NULLPOST_STR.getBytes(), 0, this.mOutBuf, 0, this.mLength);
            bl = true;
        }
        this.mLengthPreviousFlush = this.mLength;
        try {
            while (true) {
                if (!this.mTransportClosed && this.mConnectionType == 3) {
                    boolean bl2 = this.mTransportClosed = !this.isSocketOpen();
                }
                if (this.mTransportClosed) {
                    this.connect();
                }
                this.doPost(this.mLength, bl);
                n = this.getResponse();
                if (n <= 0) {
                    if (n2 < 1 && this.mConnectionType == 3) {
                        ++n2;
                        continue;
                    }
                    throw new IOException();
                }
                this.mLength = 0;
                n2 = 0;
                bl = false;
                if (n == 65520) {
                    this.mLength = NULLPOST_STR.length();
                    bl = true;
                    System.arraycopy(NULLPOST_STR.getBytes(), 0, this.mOutBuf, 0, this.mLength);
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            this.mEnvironment.showAlert(this.mEMG.getMessage("FRM-92103"), iOException);
            this.mHis.filldata(this.mInBuf, 0);
            throw iOException;
        }
    }

    public int getBytesCount() {
        return this.mEin.getBytesCount() + this.mEout.getBytesCount() + this.mHeaderBytes;
    }

    public int getBytesReceivedCount() {
        return this.mEin.getBytesCount() + this.mHeaderBytes;
    }

    public int getBytesSentCount() {
        return this.mEout.getBytesCount();
    }

    private boolean isSocketOpen() {
        int n = 0;
        boolean bl = false;
        try {
            n = this.mSocket.getSoTimeout();
            if (this.mSocket == null) {
                return false;
            }
            this.mSocket.setSoTimeout(1);
            int n2 = this.mSocket.getInputStream().read();
            if (n2 == -1) {
                bl = false;
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            bl = true;
        }
        catch (SocketException socketException) {
            bl = false;
        }
        catch (Exception exception) {
            bl = false;
        }
        if (bl) {
            try {
                this.mSocket.setSoTimeout(n);
            }
            catch (SocketException socketException) {
                bl = false;
            }
        } else {
            try {
                this.mSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }
}

