/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import oracle.forms.common.Charsets;
import oracle.forms.common.Utils;
import oracle.forms.engine.DispatcherEnvironment;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.Main;
import oracle.forms.net.BrowserCookies;
import oracle.forms.net.ConnectionException;
import oracle.forms.net.EncryptedInputStream;
import oracle.forms.net.EncryptedOutputStream;
import oracle.forms.net.FURLConnection;
import oracle.forms.net.HTTPInputStream;
import oracle.forms.perf.Perf;
import oracle.forms.registry.MessageGenerator;

public class HTTPNStream
extends OutputStream {
    protected static final String LISTENER_SERVLET = "oracle.forms.servlet.ListenerServlet";
    public static final int IXH_MAX_DATA_LENGTH = 65520;
    public static final String NULLPOST_STR = "NULLPOST";
    public static final String NULLRESP_STR = "NULLRESP";
    public static final int DEFAULT_NETWORK_RETRIES = 0;
    public static final int MIGRATION_RETRIES = 5;
    public static final String SESSID_HEADER = "Sessid";
    public static final String PRAGMA_HEADER = "Pragma";
    public static final String ACCEPT_HEADER = "accept";
    public static final String CONTENT_TYPE_HEADER = "Content-type";
    public static final String TRANSFER_ENCODING_HEADER = "Transfer-Encoding";
    public static final String NETWORK_RETRIES_PARAM = "networkRetries";
    public static final String PRINT_HEADER_INFO = "printHeaderInfo";
    public static final String CALLSERVLET_URLMARKER = "ifcfs=";
    private int mSeqNumber = 1;
    private byte[] mInBuf;
    private byte[] mOutBuf;
    private int mLength;
    private int mLengthPreviousFlush;
    private EncryptedOutputStream mEout;
    private EncryptedInputStream mEin;
    private DataInputStream mDis;
    private HTTPInputStream mHis;
    private int mI;
    private int mJ;
    private boolean mConnected;
    private boolean mSetClose = false;
    private boolean mUsingListenerServlet = false;
    private int mConnectionType;
    private int mSessionId;
    private String mSessIdStr;
    private byte[] mEncryptKey;
    private boolean mEncryptKeySet;
    private boolean mKeySetBefore;
    private int[] mInSeedBuffer;
    private int[] mOutSeedBuffer;
    private int[] mInIndexBuffer;
    private int[] mOutIndexBuffer;
    private static int mUnique = 0;
    private FURLConnection mURLConn = null;
    private URL mURL;
    private String mUrlString;
    private Perf mPerf = null;
    private int mNetworkRetries = 0;
    private boolean mIsResponsePending;
    private boolean mPrintHeaderInfo = false;
    private final DispatcherEnvironment mEnvironment;
    private final MessageGenerator mEMG;
    private final Main mApplet;
    private int mConnectCnt = 0;
    private int mSessionBytesReadCount;
    private int mSessionBytesWriteCount;
    private int mSessionRoundTrips;
    private MessageGenerator mTPG;
    private String mMessageEncryption = "TRUE";
    private ConnectionException mConnectionException = null;
    private static final int FRMSERVLET_STARTSESSION = 0;
    private static final int LSERVLET_STATIC_HTML = 1;
    private static final int LSERVLET_SSI_WEBSTART = 2;
    private static final int LSERVLET_OTHER = 3;

    public HTTPNStream(FormsDispatcher formsDispatcher, HTTPInputStream hTTPInputStream, String string, int n, URL uRL, int n2) throws MalformedURLException, IOException {
        String string2;
        String string3;
        ++mUnique;
        this.mConnected = false;
        this.mInBuf = new byte[65520];
        this.mOutBuf = new byte[65520];
        this.mLength = 0;
        this.mLengthPreviousFlush = 0;
        this.mHis = hTTPInputStream;
        this.mConnectionType = n2;
        this.mEnvironment = formsDispatcher.getDispatcherEnvironment();
        this.mEMG = formsDispatcher.getErrorMessageGenerator();
        this.mApplet = this.mEnvironment.getApplet();
        this.mTPG = this.mApplet == null ? null : this.mApplet.getTranslatedPhraseGenerator();
        try {
            string3 = this.mEnvironment.getParameter(NETWORK_RETRIES_PARAM);
            if (string3 != null) {
                this.mNetworkRetries = Integer.parseInt(string3);
            }
            if ((string2 = this.mEnvironment.getParameter(PRINT_HEADER_INFO)) != null && string2.equalsIgnoreCase("true")) {
                this.mPrintHeaderInfo = true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mEncryptKey = null;
        this.mInSeedBuffer = null;
        this.mOutSeedBuffer = null;
        this.mInIndexBuffer = null;
        this.mOutIndexBuffer = null;
        this.mEncryptKeySet = false;
        this.mKeySetBefore = false;
        string3 = "http";
        if (n2 == 3) {
            System.out.println(this.mEMG.getMessage("FRM-92816", "HTTP"));
            string3 = "http";
            this.mSessionId = -1;
        } else if (n2 == 4) {
            System.out.println(this.mEMG.getMessage("FRM-92816", "HTTPS"));
            string3 = "https";
            this.mSessionId = 0;
        }
        this.mSessIdStr = Integer.toString(this.mSessionId);
        if (uRL == null) {
            this.mUsingListenerServlet = false;
            string2 = string;
            int n3 = n;
            this.mUrlString = string3 + "://" + string2 + ":" + n3 + "/webforms/" + mUnique + "/" + (this.mSessionId + 1);
            this.mURL = new URL(this.mUrlString);
        } else {
            this.mUsingListenerServlet = true;
            this.mURL = uRL;
            this.getInfoFromServlet();
        }
        if (this.mPrintHeaderInfo) {
            this.mPerf = new Perf(this.mEnvironment.getSessionID());
            this.mPerf.setLongLapThreshold(1000L);
        }
    }

    public void connect() throws IOException {
        this.mURLConn = FURLConnection.create(this.mURL);
        this.mURLConn.setDoOutput(true);
        this.mURLConn.setAllowUserInteraction(true);
        this.mURLConn.setUseCaches(false);
        int n = this.mSeqNumber;
        if (this.mIsResponsePending) {
            n *= -1;
        }
        String string = this.mEnvironment.getJDKVersion();
        String string2 = this.mEnvironment.getOsName();
        if (string2.toUpperCase().startsWith("MAC") && string.startsWith("1.1")) {
            this.mURLConn.setRequestProperty(ACCEPT_HEADER, "" + n);
        } else {
            this.mURLConn.setRequestProperty(PRAGMA_HEADER, "" + n);
        }
        if (!this.mUsingListenerServlet) {
            this.mURLConn.setRequestProperty(SESSID_HEADER, this.mSessIdStr);
        }
        this.mURLConn.setRequestProperty(CONTENT_TYPE_HEADER, "application/octet-stream");
        if (this.mSetClose) {
            this.mURLConn.setRequestProperty("IFSession", "close");
        }
        if (this.mEncryptKeySet) {
            if (this.mKeySetBefore) {
                this.mInSeedBuffer = this.mEin.getSeedBuffer();
                this.mOutSeedBuffer = this.mEout.getSeedBuffer();
                this.mInIndexBuffer = this.mEin.getIndexVars();
                this.mOutIndexBuffer = this.mEout.getIndexVars();
            }
            OutputStream outputStream = this.mURLConn.getOutputStream();
            this.mEout = new EncryptedOutputStream(outputStream, 65520);
            if (this.mKeySetBefore) {
                this.mEout.setSeedBuffer(this.mOutSeedBuffer);
                this.mEout.setIndexVars(this.mOutIndexBuffer);
            } else {
                this.mEout.setEncryptKey(this.mEncryptKey);
            }
        } else {
            OutputStream outputStream = this.mURLConn.getOutputStream();
            this.mEout = new EncryptedOutputStream(outputStream, 65520);
        }
        this.mConnected = true;
        ++this.mConnectCnt;
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.mConnected && this.mUsingListenerServlet) {
            try {
                this.mSetClose = true;
                this.connect();
                this.doPost(0, true);
                this.getResponse();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mHis.notifyClose();
        if (this.mPrintHeaderInfo) {
            System.out.println("-----------PERFORMANCE SUMMARY----------");
            System.out.println(this.mPerf.getFullStatsMsg());
            System.out.println("Total reconnections: " + (this.mConnectCnt - 1));
            System.out.print("Total bytes");
            if (this.mConnectCnt > 1) {
                System.out.print(" [since last reconnect]");
            }
            System.out.println(": sent " + this.getBytesSentCount() + ", received " + this.getBytesReceivedCount());
            System.out.println("----------------------------------------");
        }
    }

    public void setEncryptKey(byte[] byArray) {
        this.mEncryptKey = byArray;
        this.mEncryptKeySet = true;
    }

    @Override
    public synchronized void write(int n) throws IOException {
        this.mOutBuf[this.mLength++] = (byte)n;
        if (this.mLength == 65520) {
            this.flush();
        }
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 65520 - this.mLength;
        if (n2 >= n3) {
            System.arraycopy(byArray, n, this.mOutBuf, this.mLength, n3);
            this.mLength = 65520;
            this.flush();
            n += n3;
            n2 -= n3;
            while (n2 >= 65520) {
                System.arraycopy(byArray, n, this.mOutBuf, 0, 65520);
                this.mLength = 65520;
                this.flush();
                n += 65520;
                n2 -= 65520;
            }
        }
        System.arraycopy(byArray, n, this.mOutBuf, this.mLength, n2);
        this.mLength += n2;
    }

    protected void doPost(int n, boolean bl) throws IOException {
        if (this.mPrintHeaderInfo) {
            System.out.printf("doPost():      send %6d bytes: %s\n", n, HTTPNStream.dumpVal(this.mOutBuf, n));
        }
        int[] nArray = null;
        int[] nArray2 = null;
        if (this.mEncryptKeySet) {
            nArray = this.mEout.getSeedBufferCopy();
            nArray2 = this.mEout.getIndexVars();
        }
        this.mEout.write(this.mOutBuf, 0, n);
        Arrays.fill(this.mOutBuf, 0, n, (byte)0);
        if (bl) {
            this.mEout.eflush(8);
        } else {
            this.mEout.flush();
        }
        this.mSessionBytesWriteCount += this.mEout.getBytesCount();
        ++this.mSessionRoundTrips;
        if (this.mTPG != null && this.mApplet.isNetStatsVisible()) {
            System.out.println(this.mTPG.getText("RTBSENT", new Object[]{Integer.toString(this.mEout.getBytesCount())}));
        }
        try {
            String string;
            int n2;
            if (this.mURLConn.isHttp() && (n2 = this.mURLConn.getResponseCode()) != 200 && n2 != 204) {
                throw new ConnectionException(0, this.mEMG.getMessage("FRM-92497", n2));
            }
            InputStream inputStream = this.mURLConn.getInputStream();
            String string2 = this.mURLConn.getHeaderField("oraforms-lservlet-url");
            if (string2 != null) {
                this.mURL = new URL(this.mURL, string2);
            }
            if ((string = this.mURLConn.getContentType()) != null && string.toLowerCase(Locale.ROOT).startsWith("text/plain") && (n = this.mURLConn.getContentLength()) > 0) {
                ConnectionException connectionException = ConnectionException.createConnectionException(inputStream, n);
                if (connectionException.isOfType(1)) {
                    throw connectionException;
                }
                this.mConnectionException = connectionException;
            }
            this.mEin = new EncryptedInputStream(inputStream, 65520);
        }
        catch (IOException iOException) {
            if (this.mPrintHeaderInfo) {
                this.printHeaders(this.mURLConn);
            }
            if (this.mEncryptKeySet) {
                this.mEout.setSeedBuffer(nArray);
                this.mEout.setIndexVars(nArray2);
            }
            throw iOException;
        }
        if (this.mEncryptKeySet) {
            if (this.mKeySetBefore) {
                this.mEin.setSeedBuffer(this.mInSeedBuffer);
                this.mEin.setIndexVars(this.mInIndexBuffer);
            } else {
                this.mEin.setEncryptKey(this.mEncryptKey);
                this.mKeySetBefore = true;
            }
        }
    }

    protected int getResponse() throws IOException {
        String string;
        int n;
        Object object;
        Object object2;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        int n5 = 3;
        boolean bl2 = false;
        boolean bl3 = false;
        if (this.mPrintHeaderInfo) {
            this.printHeaders(this.mURLConn);
        }
        if (this.mSessionId == -1 && (object2 = this.mURLConn.getHeaderField(SESSID_HEADER)) != null) {
            this.mSessIdStr = object2;
            object = Integer.valueOf(this.mSessIdStr);
            this.mSessionId = (Integer)object;
            if (this.mPrintHeaderInfo) {
                System.out.println("****Sessid = " + this.mSessionId);
            }
        }
        if ((object2 = this.mConnectionException) != null) {
            this.mConnectionException = null;
            throw object2;
        }
        n3 = this.mURLConn.getContentLength();
        object = null;
        if (n3 <= 0) {
            object = this.mURLConn.getHeaderField(TRANSFER_ENCODING_HEADER);
        }
        if (object != null && "Chunked".equalsIgnoreCase((String)object)) {
            bl3 = true;
        }
        if (n3 > 0) {
            n = n3;
            while (n > 0) {
                n2 = this.mEin.read(this.mInBuf, n4, n);
                if (n2 <= 0) {
                    this.mConnected = false;
                    break;
                }
                n -= n2;
                n4 += n2;
            }
        } else if (bl3) {
            n = 0;
            n3 = 0;
            byte[] byArray = new byte[8192];
            while ((n = this.mEin.read(byArray)) > 0) {
                System.arraycopy(byArray, 0, this.mInBuf, n3, n);
                n3 += n;
            }
        }
        this.mSessionBytesReadCount += this.mEin.getBytesCount();
        if (this.mTPG != null && this.mApplet.isNetStatsVisible()) {
            System.out.println(this.mTPG.getText("RTBRCVD", new Object[]{Integer.toString(this.mEin.getBytesCount())}));
        }
        if (this.mEin != null) {
            this.mEin.close();
        }
        this.mConnected = false;
        if (this.mPrintHeaderInfo) {
            System.out.printf("getResponse(): read %6d bytes: %s\n", n3, HTTPNStream.dumpVal(this.mInBuf, n3));
        }
        if (n3 == 8 && (string = new String(this.mInBuf, 0, 8)).equalsIgnoreCase(NULLRESP_STR)) {
            return n3;
        }
        if (n3 > 0) {
            this.mHis.filldata(this.mInBuf, n3);
            if (this.mPrintHeaderInfo) {
                System.out.println("getResponse() wrote to input stream " + n3 + " bytes");
            }
        }
        return n3;
    }

    @Override
    public synchronized void flush() throws IOException {
        boolean bl = false;
        if (this.mLength == 0) {
            if (this.mLengthPreviousFlush < 65520) {
                return;
            }
            this.mLength = NULLPOST_STR.length();
            System.arraycopy(NULLPOST_STR.getBytes(), 0, this.mOutBuf, 0, this.mLength);
            bl = true;
        }
        this.mLengthPreviousFlush = this.mLength;
        class Retry {
            int num;
            int max;
            String failureMsg;
            String retryMsg;

            Retry() {
            }
        }
        Retry retry = new Retry();
        Retry retry2 = new Retry();
        retry.num = 0;
        retry.max = this.mNetworkRetries;
        retry.failureMsg = this.mNetworkRetries > 0 ? "FRM-92102" : "FRM-92103";
        retry.retryMsg = "FRM-92802";
        retry2.num = 0;
        retry2.max = 5;
        retry2.failureMsg = "FRM-92104";
        retry2.retryMsg = "FRM-92804";
        ++this.mSeqNumber;
        while (true) {
            if (this.mPrintHeaderInfo) {
                System.out.println("Connect try " + retry.num);
            }
            try {
                this.doFlush(bl);
                this.mIsResponsePending = false;
            }
            catch (IOException iOException) {
                Object object;
                String string = "";
                String string2 = "";
                Retry retry3 = retry;
                int n = 1000;
                if (iOException instanceof ConnectionException) {
                    object = (ConnectionException)iOException;
                    if (((ConnectionException)object).isOfType(7)) {
                        retry3 = retry2;
                        try {
                            n = Integer.parseInt(((Throwable)object).getMessage());
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        if (((ConnectionException)object).isOfType(11)) {
                            String[] stringArray = ((Throwable)object).getMessage().split("\\|");
                            if (stringArray.length > 1) {
                                BrowserCookies.launchBrowserWithCookies(this.mURL.toString() + "?" + stringArray[1], true, stringArray[2]);
                            }
                            this.mIsResponsePending = true;
                            int n2 = 0;
                            try {
                                n2 = Integer.parseInt(stringArray[0]);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (this.mPrintHeaderInfo) {
                                System.out.println("Response Pending, Wait Time = " + n2);
                            }
                            try {
                                Thread.sleep(n2);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            this.mConnected = false;
                            ++this.mSeqNumber;
                            continue;
                        }
                        if (((ConnectionException)object).isOfType(1)) {
                            this.mConnected = false;
                            continue;
                        }
                        this.mEnvironment.showAlert(((Throwable)object).getMessage(), "", true);
                        this.mHis.filldata(this.mOutBuf, 0);
                        throw iOException;
                    }
                }
                if (++retry3.num > retry3.max) {
                    string = this.mEMG.getMessage(retry3.failureMsg, retry3.max);
                    this.mEnvironment.showAlert(string, iOException);
                    this.mHis.filldata(this.mOutBuf, 0);
                    throw iOException;
                }
                string = this.mEMG.getMessage(retry3.retryMsg, retry3.num, retry3.max);
                System.out.println(string);
                object = this.mEnvironment.getCurrentStatusBar();
                if (object != null) {
                    string = retry3.num + "/" + retry3.max;
                    object.setStatusBarProperty(12, string);
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mConnected = false;
                continue;
            }
            break;
        }
        this.mLength = 0;
    }

    private void doFlush(boolean bl) throws IOException {
        int n = 0;
        int n2 = this.mLength;
        while (true) {
            if (this.mPrintHeaderInfo) {
                this.mPerf.resetElapsed();
                this.mPerf.startTimer();
            }
            if (!this.mConnected) {
                this.connect();
            }
            if (!this.mIsResponsePending) {
                this.doPost(this.mLength, bl);
                bl = false;
            } else {
                this.doPost(0, false);
                this.mIsResponsePending = false;
            }
            n = this.getResponse();
            if (this.mPrintHeaderInfo) {
                this.mPerf.stopTimer();
                this.mPerf.elapsedMsg(" secs network exchange. Bytes sent " + n2 + ", received " + n + ".");
            }
            if (n <= 0) {
                throw new IOException();
            }
            if (n != 65520) break;
            this.mLength = NULLPOST_STR.length();
            System.arraycopy(NULLPOST_STR.getBytes(), 0, this.mOutBuf, 0, this.mLength);
            bl = true;
            ++this.mSeqNumber;
        }
    }

    public void resetBytesCount() {
        this.mSessionBytesReadCount = 0;
        this.mSessionBytesWriteCount = 0;
    }

    public int getBytesCount() {
        return this.mSessionBytesReadCount + this.mSessionBytesWriteCount;
    }

    public int getBytesReceivedCount() {
        return 0;
    }

    public int getBytesSentCount() {
        return 0;
    }

    public String getMessageEncryption() {
        return this.mMessageEncryption;
    }

    private void getInfoFromServlet() throws ConnectionException, IOException {
        char c;
        int n;
        String string;
        String string2 = "";
        Locale locale = this.mEnvironment.getLocale();
        String string3 = locale.getLanguage();
        String string4 = locale.getCountry();
        if (string3.length() == 2) {
            string2 = "&iflocale=" + string3 + "-" + string4;
            if (!this.mEnvironment.useServerLang()) {
                string2 = string2 + "!";
            }
        }
        int n2 = 3;
        String string5 = string = this.mURL.toString();
        int n3 = string.indexOf(CALLSERVLET_URLMARKER);
        if (n3 >= 0 && (n = string.indexOf("ifsessid=", n3)) >= 0 && ((c = string.charAt(n - 1)) == '?' || c == '&')) {
            this.mURL = new URL(string.substring(0, n3 - 1));
            string5 = string.substring(n3 + CALLSERVLET_URLMARKER.length());
            URL uRL = this.mEnvironment.getDocumentBase();
            uRL = new URL(uRL, string5);
            string5 = uRL.toString();
            String string6 = "ifcmd=startsession";
            if (this.mApplet != null && this.mApplet.isRunningSSOMode()) {
                string6 = "ifcmd=startssosession";
            }
            string5 = Utils.appendQueryString(string5, string6 + string2);
            string2 = "";
            this.getResponseFromServlet(string5, 0);
            string5 = this.mURL.toString();
        } else {
            n = n3 = string.indexOf(63);
            if (n3 >= 0 && (string.substring(n3 + 1).startsWith("ifhash=") || (n = string.indexOf("&ifhash=", n3 + 1)) >= 0)) {
                String string7;
                string5 = string.substring(0, n);
                char c2 = string.charAt(n + 8);
                if (c2 == '1') {
                    this.mApplet.setIsIdcsEnabled(true);
                }
                if (!(string7 = string.substring(n + 9)).isEmpty()) {
                    URI uRI;
                    String string8 = string.substring(0, n3);
                    try {
                        uRI = new URI(string8);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new MalformedURLException();
                    }
                    string7 = Utils.urlDecode(string7);
                    HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>(1);
                    hashMap.put("Set-Cookie", Arrays.asList(string7.split("\n")));
                    CookieHandler.getDefault().put(uRI, hashMap);
                }
                this.mURL = new URL(string5);
                if (this.mApplet != null && this.mApplet.isWebstartRequest()) {
                    n2 = 2;
                }
            } else {
                n2 = 1;
            }
        }
        string5 = Utils.appendQueryString(string5, "ifcmd=getinfo" + string2);
        string5 = HTTPNStream.appendHostIP(string5);
        string5 = this.appendFSALCheckSum(string5);
        this.getResponseFromServlet(string5, n2);
    }

    private void getResponseFromServlet(String string, int n) throws ConnectionException, IOException {
        int n2;
        byte[] byArray = this.doGet(string, n);
        if (byArray == null) {
            return;
        }
        String string2 = new String(byArray, Charsets.UTF_8);
        if (this.mPrintHeaderInfo) {
            System.out.println("Got response: " + string2);
        }
        if (this.mURLConn.getContentType().toLowerCase(Locale.ROOT).startsWith("text/plain") && string2.startsWith("ifError:")) {
            ConnectionException connectionException = new ConnectionException(string2);
            if (connectionException.getMessage().startsWith("FRM-93143")) {
                if (!"false".equalsIgnoreCase(this.mApplet.getParameter("fsalEnableAutoUpdate"))) {
                    throw connectionException;
                }
                System.out.println(this.mEMG.getMessage("FRM-92413"));
            }
            this.mEnvironment.showAlert(connectionException.getMessage(), "", true);
            this.mHis.filldata(this.mOutBuf, 0);
            throw connectionException;
        }
        if (n != 0 && (n2 = string2.indexOf(10)) >= 0) {
            this.mMessageEncryption = string2.substring(0, n2);
            if ((string2 = string2.substring(n2 + 1)).isEmpty()) {
                return;
            }
        }
        this.mURL = new URL(this.mURL, this.mEnvironment.extractSessionID(string2));
    }

    private void printHeaders(FURLConnection fURLConnection) throws IOException {
        System.out.println("Response headers:");
        for (Map.Entry<String, List<String>> entry : fURLConnection.getHeaderFields().entrySet()) {
            String string = entry.getKey();
            for (String string2 : entry.getValue()) {
                System.out.println("\t" + string + ": " + string2);
            }
        }
    }

    private static String appendHostIP(String string) {
        String string2 = null;
        String string3 = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            string3 = inetAddress.getHostName();
            string2 = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
        if (string3 == null || string3.equalsIgnoreCase("localhost")) {
            return string;
        }
        string3 = Utils.urlEncode(string3);
        return Utils.appendQueryString(string, "ifhost=" + string3 + "&ifip=" + string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] doGet(String string, int n) throws IOException {
        int n2;
        URL uRL = new URL(string);
        this.mURLConn = FURLConnection.create(uRL);
        this.mURLConn.setAllowUserInteraction(true);
        this.mURLConn.setUseCaches(false);
        switch (n) {
            case 3: {
                this.mURLConn.setRequestProperty(PRAGMA_HEADER, "0");
                break;
            }
            case 2: {
                this.mURLConn.setRequestProperty(PRAGMA_HEADER, "1");
                break;
            }
        }
        if (this.mURLConn.isHttp() && (n2 = this.mURLConn.getResponseCode()) != 200 && n2 != 204) {
            System.out.println(this.mEMG.getMessage("FRM-92497", n2));
            throw new IOException();
        }
        n2 = this.mURLConn.getContentLength();
        if (this.mPrintHeaderInfo) {
            System.out.println("Got content-length " + n2 + " bytes");
            System.out.println("Got content-type " + this.mURLConn.getContentType());
        }
        if (n2 < 0) {
            System.out.println(this.mEMG.getMessage("FRM-92550", string));
            throw new IOException();
        }
        if (n2 == 0) {
            return null;
        }
        InputStream inputStream = this.mURLConn.getInputStream();
        byte[] byArray = new byte[n2];
        int n3 = n2;
        int n4 = 0;
        int n5 = 0;
        try {
            while (n3 > 0) {
                n5 = inputStream.read(byArray, n4, n3);
                if (this.mPrintHeaderInfo) {
                    System.out.println("Read " + n5 + " bytes");
                }
                if (n5 < 0) {
                    System.out.println(this.mEMG.getMessage("FRM-92551", n5, string));
                    throw new IOException();
                }
                n3 -= n5;
                n4 += n5;
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    private String appendFSALCheckSum(String string) {
        String string2;
        if (this.mApplet != null && this.mApplet.isStandAloneAppRequest() && (string2 = this.mApplet.getFSALCheckSum()) != null) {
            string2 = Utils.urlEncode(string2);
            return Utils.appendQueryString(string, "fsalchecksum=" + string2);
        }
        return string;
    }

    private static String dumpVal(byte[] byArray, int n) {
        if (n <= 0) {
            return "";
        }
        return Utils.bytesToHexString(Arrays.copyOf(byArray, n));
    }
}

