/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.forms.common.Charsets;
import oracle.forms.common.FInputStream;
import oracle.forms.net.HTTPCookie;

public class HTTPHeaderTool {
    protected static final String CONTENT_PREFIX = "CONTENT-LENGTH: ";
    protected static final String CONTENT_LANGUAGE_PREFIX = "CONTENT-LANGUAGE: ";
    protected static final String SESSION_PREFIX = "SESSID: ";
    protected static final String STATUS_PREFIX = "HTTP/1.";
    protected static final String CONN_CLOSE = "CONNECTION: CLOSE";
    public static final int GOOD_STATUS = 200;
    protected static final String DMS_RTI_PREFIX = "DMS-RTI:";
    protected static final byte[] DMS_RTI_PREFIX_BYTES = "DMS-RTI:".getBytes(Charsets.UTF_8);
    protected static final String X_STDOUT_SIZE_PREFIX = "X-STDOUT-SIZE: ";
    protected static final String COLON = ":";
    protected static final String SPACE = " ";
    protected static final String SLASH = "/";
    protected static final String POST = "POST ";
    protected static final String HTTP_PREFIX = "http://";
    protected static final String FORMS_PATH = "/webforms";
    protected static final String HTTP_11 = "HTTP/1.1";
    protected static final String HOST_STR = "Host: ";
    protected static final String PROXY_CONNECTION_KEEPALIVE = "Proxy-Connection: Keep-Alive";
    protected static final String CONNECTION_KEEPALIVE = "Connection: Keep-Alive";
    public static final String CONTENT_TYPE_TEXT = "Content-type: text/html";
    public static final String OCTET_STREAM = "application/octet-stream";
    public static final String CONTENT_TYPE_OCTET_STREAM = "Content-type: application/octet-stream";
    public static final String IXH_HTTP_CONNECTION_CLOSE = "Connection: close\r\n";
    public static final String IXH_HTTP_CONTENT_LENGTH = "Content-length: ";
    public static final String IXH_HTTP_CRLF = "\r\n";
    public static final String IXH_HTTP_SESSION_ID = "Sessid: ";
    public static final String IXH_HTTP_ECID = "ecid: ";
    public static final String CR_LF = "\r\n";
    public static final String HEADER_SUFFIX = " HTTP/1.1\r\n";
    public static final String CONTENT_INFO = "Content-type: application/octet-stream\r\nContent-length: ";
    public static final String IFSESSION_HEADER_NAME = "IFSession";
    public static final String IFSESSION_CLOSE = "close";
    public static final String IFSESSION_CLOSE_INFO = "IFSession: close\r\n";
    public static final String KEEP_ALIVE_INFO = "Proxy-Connection: Keep-Alive\r\nConnection: Keep-Alive\r\n";
    private long mContentLength;
    private int mStdoutSize;
    private String mContentLanguage;
    private int mHttpStatus;
    private int mSessionId = -1;
    private String mHttpVersion;
    private String mHttpStatusMessage;
    private boolean mConnectionClosed;
    private Vector mCookies = new Vector(5, 5);
    private boolean mUseProxy = false;
    private boolean mUseListenerServlet = false;
    private String mHeaderURL = null;
    private String mHeaderHostLine = null;
    private int mHeaderUniqueId = 1;
    private StringBuffer mSbuf;
    private Object mFormsDMS;

    public HTTPHeaderTool() {
    }

    public HTTPHeaderTool(String string, int n, String string2, int n2, URL uRL) {
        int n3;
        String string3;
        this.mSbuf = new StringBuffer();
        if (uRL == null) {
            string3 = string2;
            n3 = n2;
            this.mUseListenerServlet = false;
        } else {
            string3 = uRL.getHost();
            n3 = uRL.getPort();
            if (n3 == -1) {
                n3 = 80;
            }
            this.mUseListenerServlet = true;
        }
        if (string == null) {
            String string4 = string3;
            int n4 = n3;
        } else {
            String string5 = string;
            int n5 = n;
        }
        if (uRL == null) {
            this.mSbuf.setLength(0);
            this.mSbuf.append(HTTP_PREFIX);
            this.mSbuf.append(string3);
            this.mSbuf.append(COLON);
            this.mSbuf.append(n3);
            this.mSbuf.append(FORMS_PATH);
            this.mHeaderURL = this.mSbuf.toString();
        } else {
            this.mHeaderURL = string == null ? uRL.getFile() : uRL.toString();
        }
        this.mSbuf.setLength(0);
        this.mSbuf.append(HOST_STR);
        this.mSbuf.append(string3);
        this.mSbuf.append(COLON);
        this.mSbuf.append(n3);
        this.mSbuf.append("\r\n");
        this.mHeaderHostLine = this.mSbuf.toString();
        if (string != null) {
            this.mUseProxy = true;
        }
    }

    public HTTPHeaderTool(Object object) {
        this.mFormsDMS = object;
    }

    public String makeRequestHeader(int n, boolean bl) throws IOException {
        if (this.mHeaderURL == null || this.mHeaderHostLine == null) {
            throw new IOException("HTTPHeaderTool Internal Error: this instance cannot generate headers");
        }
        this.mSbuf.setLength(0);
        this.mSbuf.append(POST);
        this.mSbuf.append(this.mHeaderURL);
        if (!this.mUseListenerServlet) {
            this.mSbuf.append(SLASH);
            this.mSbuf.append(this.mHeaderUniqueId);
            this.mSbuf.append(this.mHeaderUniqueId);
            this.mSbuf.append(this.mSessionId + 1);
            this.mSbuf.append(SLASH);
        }
        this.mSbuf.append(HEADER_SUFFIX);
        this.mSbuf.append(this.mHeaderHostLine);
        this.mSbuf.append(CONTENT_INFO);
        this.mSbuf.append(n);
        this.mSbuf.append("\r\n");
        this.mSbuf.append(IXH_HTTP_SESSION_ID);
        this.mSbuf.append(this.mSessionId);
        this.mSbuf.append("\r\n");
        String string = HTTPCookie.makeCookieHeader(this.mCookies);
        if (string != null) {
            this.mSbuf.append(string);
        }
        if (bl) {
            this.mSbuf.append(IXH_HTTP_CONNECTION_CLOSE);
            this.mSbuf.append(IFSESSION_CLOSE_INFO);
        } else if (this.mUseProxy) {
            this.mSbuf.append(KEEP_ALIVE_INFO);
        }
        this.mSbuf.append("\r\n");
        return this.mSbuf.toString();
    }

    private void parseRTILine(String string) {
        if (this.mFormsDMS != null && string != null) {
            try {
                Method method = this.mFormsDMS.getClass().getMethod("parseRTILine", String.class);
                method.invoke(this.mFormsDMS, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseDMSResponseHeader(InputStream inputStream) {
        if (inputStream == null || !inputStream.markSupported()) {
            return;
        }
        byte[] byArray = new byte[DMS_RTI_PREFIX_BYTES.length];
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            try {
                while (inputStream.available() > 0) {
                    inputStream.mark(DMS_RTI_PREFIX_BYTES.length);
                    if (inputStream.read(byArray) != DMS_RTI_PREFIX_BYTES.length || !Arrays.equals(byArray, DMS_RTI_PREFIX_BYTES)) {
                        inputStream.reset();
                        break;
                    }
                    byte[] byArray2 = FInputStream.readLine(inputStream, false, -1);
                    String string = new String(byArray2, Charsets.UTF_8);
                    this.parseRTILine(DMS_RTI_PREFIX + string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public int parseResponseHeader(InputStream inputStream, int n) throws IOException {
        byte[] byArray = null;
        String string = null;
        int n2 = 0;
        this.mSessionId = this.mUseListenerServlet ? 0 : -1;
        this.mContentLength = -1L;
        this.mStdoutSize = -1;
        this.mHttpStatus = 0;
        this.mHttpVersion = null;
        this.mConnectionClosed = false;
        while (true) {
            byArray = FInputStream.readLine(inputStream, false, n);
            string = new String(byArray, Charsets.UTF_8);
            n = -1;
            if (string.length() == 0 && this.mHttpStatus >= 200) {
                return n2;
            }
            if (string.startsWith(DMS_RTI_PREFIX)) {
                this.parseRTILine(string);
                return -1;
            }
            n2 += string.length();
            String string2 = string.toUpperCase();
            if (string2.startsWith(STATUS_PREFIX)) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, " /");
                String string3 = stringTokenizer.nextToken();
                this.mHttpVersion = string3 = stringTokenizer.nextToken();
                string3 = stringTokenizer.nextToken();
                this.mHttpStatus = Integer.parseInt(string3);
                this.mHttpStatusMessage = string;
                if (this.mHttpStatus >= 100 && this.mHttpStatus >= 200) continue;
            }
            if (string2.startsWith(CONN_CLOSE)) {
                this.mConnectionClosed = true;
                continue;
            }
            if (string2.startsWith(CONTENT_PREFIX)) {
                this.mContentLength = Long.parseLong(string.substring(CONTENT_PREFIX.length()).trim());
                continue;
            }
            if (string2.startsWith(X_STDOUT_SIZE_PREFIX)) {
                this.mStdoutSize = Integer.parseInt(string.substring(X_STDOUT_SIZE_PREFIX.length()));
                continue;
            }
            if (string2.startsWith(CONTENT_LANGUAGE_PREFIX)) {
                this.mContentLanguage = string.substring(CONTENT_LANGUAGE_PREFIX.length());
                continue;
            }
            if (string2.startsWith(SESSION_PREFIX)) {
                try {
                    int n3;
                    this.mSessionId = n3 = Integer.parseInt(string.substring(SESSION_PREFIX.length()));
                }
                catch (NumberFormatException numberFormatException) {}
                continue;
            }
            if (!string2.startsWith("SET-COOKIE:")) continue;
            HTTPCookie.parseSetCookie(string, this.mCookies);
        }
    }

    public int getContentLength() {
        if (this.mContentLength > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)this.mContentLength;
    }

    public long getContentLengthLong() {
        return this.mContentLength;
    }

    public int getStdoutSize() {
        return this.mStdoutSize;
    }

    public String getContentLanguage() {
        return this.mContentLanguage;
    }

    public int getStatus() {
        return this.mHttpStatus;
    }

    public boolean getConnectionClosed() {
        return this.mConnectionClosed;
    }

    public String getHttpVersion() {
        return this.mHttpVersion;
    }

    public String getHttpStatusMessage() {
        return this.mHttpStatusMessage;
    }

    public boolean isHTTP1dot0() {
        return this.mHttpVersion.equals("1.0");
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public void printParsedHeaderInfo() {
        System.out.println("Parsed header info:\n  HttpStatus=" + this.mHttpStatus + ",\n  HttpVersion=" + this.mHttpVersion + ",\n  contentLengh=" + this.mContentLength + ",\n  sessionId=" + this.mSessionId + ",\n  connectionClosed=" + this.mConnectionClosed + ",\n");
        System.out.println("Cookies:");
        Enumeration enumeration = this.mCookies.elements();
        while (enumeration.hasMoreElements()) {
            HTTPCookie hTTPCookie = (HTTPCookie)enumeration.nextElement();
            System.out.println(hTTPCookie.toString());
        }
    }

    public String makeShortRequestHeader(int n, String string) throws IOException {
        if (this.mHeaderURL == null || this.mHeaderHostLine == null) {
            throw new IOException("HTTPHeaderTool Internal Error: this instance cannot generate headers");
        }
        this.mSbuf.setLength(0);
        this.mSbuf.append(POST);
        this.mSbuf.append(this.mHeaderURL);
        this.mSbuf.append(HEADER_SUFFIX);
        this.mSbuf.append(IXH_HTTP_CONTENT_LENGTH);
        this.mSbuf.append(n);
        this.mSbuf.append("\r\n");
        this.mSbuf.append(IXH_HTTP_SESSION_ID);
        this.mSbuf.append(this.mSessionId);
        this.mSbuf.append("\r\n");
        if (string != null) {
            this.mSbuf.append(IXH_HTTP_ECID);
            this.mSbuf.append(string);
            this.mSbuf.append("\r\n");
        }
        this.mSbuf.append("\r\n");
        return this.mSbuf.toString();
    }
}

