/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.util.StringTokenizer;
import java.util.Vector;

public class HTTPCookie {
    protected static final String SET_COOKIE = "SET-COOKIE";
    protected static final String SET_COOKIE_PREFIX = "SET-COOKIE:";
    protected static final String SET_COOKIE2_PREFIX = "SET-COOKIE2:";
    private static final String PATH = "PATH";
    protected static final String COOKIE_HEADER = "Cookie";
    private static final String COOKIE_HEADER_PREFIX = "Cookie: ";
    private static final String COOKIE_SEPARATOR = ";";
    private static final String EQUALS = "=";
    private String mName;
    private String mValue;
    private String mPath;

    public HTTPCookie(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException();
        }
        this.mName = string;
        this.mValue = string2;
    }

    public static void parseSetCookie(String string, Vector vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        HTTPCookie.parseSetCookieValue(stringTokenizer, vector);
    }

    public static void parseSetCookieValue(String string, Vector vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";= ");
        HTTPCookie.parseSetCookieValue(stringTokenizer, vector);
    }

    private static void parseSetCookieValue(StringTokenizer stringTokenizer, Vector vector) {
        String string = stringTokenizer.nextToken(";= ");
        if (!stringTokenizer.hasMoreTokens()) {
            return;
        }
        HTTPCookie hTTPCookie = new HTTPCookie(string, stringTokenizer.nextToken());
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) break;
            if (!string.equalsIgnoreCase(PATH)) continue;
            hTTPCookie.mPath = stringTokenizer.nextToken();
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < vector.size() && !bl; ++i) {
            HTTPCookie hTTPCookie2 = (HTTPCookie)vector.elementAt(i);
            if (hTTPCookie.mName.equals(hTTPCookie2.mName)) {
                bl2 = true;
                if (hTTPCookie.matches(hTTPCookie2)) {
                    hTTPCookie2.mValue = hTTPCookie.mValue;
                    bl = true;
                    continue;
                }
                if (!hTTPCookie.moreSpecificThan(hTTPCookie2)) continue;
                vector.insertElementAt(hTTPCookie, i);
                bl = true;
                continue;
            }
            if (!bl2) continue;
            vector.insertElementAt(hTTPCookie, i);
            bl = true;
        }
        if (!bl) {
            vector.addElement(hTTPCookie);
        }
    }

    public static String makeCookieHeader(Vector vector) {
        if (vector.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(COOKIE_HEADER_PREFIX);
        HTTPCookie.appendCookieHeaderValue(vector, stringBuffer);
        stringBuffer.append("\r\n");
        return stringBuffer.toString();
    }

    public static String makeCookieHeaderValue(Vector vector) {
        if (vector.size() == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        HTTPCookie.appendCookieHeaderValue(vector, stringBuffer);
        return stringBuffer.toString();
    }

    private static void appendCookieHeaderValue(Vector vector, StringBuffer stringBuffer) {
        for (int i = 0; i < vector.size(); ++i) {
            HTTPCookie hTTPCookie = (HTTPCookie)vector.elementAt(i);
            if (i > 0) {
                stringBuffer.append(COOKIE_SEPARATOR);
            }
            stringBuffer.append(hTTPCookie.mName);
            stringBuffer.append(EQUALS);
            stringBuffer.append(hTTPCookie.mValue);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("Cookie " + this.mName + ":\n       Value = " + this.mValue);
        if (this.mPath != null) {
            stringBuffer.append(",\n       Path  = " + this.mPath);
        }
        return stringBuffer.toString();
    }

    private boolean matches(HTTPCookie hTTPCookie) {
        boolean bl = hTTPCookie.mName.equals(this.mName) ? (hTTPCookie.mPath == null && this.mPath == null ? true : (hTTPCookie.mPath == null || this.mPath == null ? false : hTTPCookie.mPath.equals(this.mPath))) : false;
        return bl;
    }

    private boolean moreSpecificThan(HTTPCookie hTTPCookie) {
        boolean bl = this.mPath == null ? true : (hTTPCookie.mPath == null ? false : this.mPath.startsWith(hTTPCookie.mPath));
        return bl;
    }
}

