/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Random;
import oracle.forms.common.Utils;
import oracle.forms.engine.DispatcherEnvironment;
import oracle.forms.engine.FormsDispatcher;
import oracle.forms.engine.Message;
import oracle.forms.engine.RunformException;
import oracle.forms.engine.TerminalMessage;
import oracle.forms.net.Connection;
import oracle.forms.net.HTTPInputStream;
import oracle.forms.net.HTTPNStream;
import oracle.forms.net.HTTPStream;
import oracle.forms.net.MessageQueue;
import oracle.forms.net.StreamMessageReader;
import oracle.forms.net.StreamMessageWriter;
import oracle.forms.registry.MessageGenerator;

public class HTTPConnection
implements Connection {
    public static String NET_DEFAULT_PORT = "9000";
    private static final String PROXY_PORT_ARG = "proxyPort";
    private static final String PROXY_HOST_ARG = "proxyHost";
    private static final String DROP_CONN_ARG = "dropConnection";
    private static final String MS_CLASS_NAME = "com.ms.util.SystemVersionManager";
    private static final String PLUGIN_PROP = "javaplugin.proxy.settings";
    private static final String USE_URLCONN = "useURLConnection";
    private static int NEG_SEND = 1195663737;
    private static int NEG_RESPONSE = 1298232421;
    private boolean mUseNativeHTTP = false;
    private String mProxyHost = null;
    private String mProxyPortStr = null;
    private int mProxyPort;
    private String mServerHost;
    private int mServerPort;
    private URL mServerURL;
    private int mConnectionType;
    private boolean mDropConn = false;
    private StreamMessageReader mReader;
    private StreamMessageWriter mWriter;
    private int mMessagesSentCount = 0;
    private int mRoundTripsCount = 0;
    private HTTPStream mHs = null;
    private HTTPNStream mHNs = null;
    private MessageQueue mOutputMessageQueue = new MessageQueue();
    private boolean mPrintSrvDetails = true;
    private final FormsDispatcher mDispatcher;
    private final DispatcherEnvironment mEnvironment;
    private final MessageGenerator mEMG;

    public HTTPConnection(FormsDispatcher formsDispatcher, String string, int n, String string2, int n2, boolean bl) throws MalformedURLException, RunformException {
        this.mDispatcher = formsDispatcher;
        this.mEnvironment = this.mDispatcher.getDispatcherEnvironment();
        this.mEMG = this.mDispatcher.getErrorMessageGenerator();
        this.mServerHost = string;
        this.mServerPort = n;
        this.mConnectionType = n2;
        this.mPrintSrvDetails = bl;
        this.mDropConn = false;
        this.mUseNativeHTTP = false;
        if (string2 != null && !string2.equals("")) {
            this.mServerURL = new URL(this.mEnvironment.getCodeBase(), string2);
            this.mConnectionType = this.mServerURL.getProtocol().equalsIgnoreCase("https") ? 4 : 3;
            this.mUseNativeHTTP = true;
        }
        this.getHttpParameters();
        if (this.mPrintSrvDetails) {
            System.out.println(this.mEMG.getMessage("FRM-92818", this.mProxyHost, Integer.toString(this.mProxyPort)));
        }
        this.handleUseURLConnection();
    }

    private void handleUseURLConnection() {
        String string = this.mEnvironment.getParameter(USE_URLCONN);
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes")) {
            this.mUseNativeHTTP = true;
            System.out.println(this.mEMG.getMessage("FRM-92522"));
        } else if (string.equalsIgnoreCase("false") || string.equalsIgnoreCase("no")) {
            this.mUseNativeHTTP = false;
            System.out.println(this.mEMG.getMessage("FRM-92523"));
        }
    }

    private void getHttpParameters() {
        this.mProxyHost = this.mEnvironment.getParameter(PROXY_HOST_ARG);
        if (this.mProxyHost == null || this.mProxyHost.equals("")) {
            this.mProxyHost = null;
        }
        this.mProxyPortStr = this.mEnvironment.getParameter(PROXY_PORT_ARG);
        this.mProxyPort = this.mProxyPortStr == null || this.mProxyPortStr.equals("") ? 0 : Integer.parseInt(this.mProxyPortStr);
    }

    @Override
    public void connect(FormsDispatcher formsDispatcher) throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        try {
            boolean bl;
            DataInputStream dataInputStream;
            DataOutputStream dataOutputStream;
            HTTPInputStream hTTPInputStream = new HTTPInputStream();
            if (this.mUseNativeHTTP) {
                System.out.println(this.mEMG.getMessage("FRM-92820"));
                this.mHNs = new HTTPNStream(this.mDispatcher, hTTPInputStream, this.mServerHost, this.mServerPort, this.mServerURL, this.mConnectionType);
                this.mHNs.connect();
                dataOutputStream = new DataOutputStream(this.mHNs);
                dataInputStream = new DataInputStream(hTTPInputStream);
                boolean bl2 = Utils.getBoolEnvValue(this.mHNs.getMessageEncryption(), this.mConnectionType != 4);
                bl = !bl2;
            } else {
                System.out.println(this.mEMG.getMessage("FRM-92816", "HTTP"));
                this.mHs = new HTTPStream(this.mDispatcher, this.mProxyHost, this.mProxyPort, hTTPInputStream, this.mServerHost, this.mServerPort, this.mServerURL, this.mConnectionType, this.mDropConn);
                this.mHs.connect();
                dataOutputStream = new DataOutputStream(this.mHs);
                dataInputStream = new DataInputStream(hTTPInputStream);
                bl = false;
            }
            if (bl) {
                dataOutputStream.writeInt(NEG_SEND + 1);
            } else {
                dataOutputStream.writeInt(NEG_SEND);
                n = new Random().nextInt();
                dataOutputStream.writeInt(n);
                dataOutputStream.flush();
                n3 = dataInputStream.readInt();
                n2 = dataInputStream.readInt();
                if (n3 == NEG_RESPONSE) {
                    byte[] byArray = new byte[]{(byte)(n >> 8), (byte)(n2 >> 4), -82, (byte)(n >> 16), (byte)(n2 >> 12)};
                    if (this.mUseNativeHTTP) {
                        this.mHNs.setEncryptKey(byArray);
                    } else {
                        this.mHs.setEncryptKey(byArray);
                    }
                } else if (n3 == NEG_RESPONSE + 1) {
                    // empty if block
                }
            }
            this.mReader = new StreamMessageReader(this.mDispatcher, dataInputStream, 512, Message.createMessageCache());
            this.mWriter = new StreamMessageWriter(this.mDispatcher, dataOutputStream, 4, -1);
            this.mReader.start();
            this.mWriter.start();
            this.mReader.setPriority(10);
            this.mWriter.setPriority(1);
        }
        catch (IOException iOException) {
            if (this.mHs != null) {
                this.mHs.close();
            } else if (this.mHNs != null) {
                this.mHNs.close();
            }
            throw iOException;
        }
    }

    @Override
    public void putMessage(Message message) throws Exception {
        this.mWriter.put(message);
        ++this.mMessagesSentCount;
    }

    @Override
    public void putTerminal(TerminalMessage terminalMessage) throws Exception {
        this.mWriter.put(terminalMessage);
        ++this.mMessagesSentCount;
        ++this.mRoundTripsCount;
    }

    @Override
    public Object get() throws Exception {
        return this.mReader.get();
    }

    @Override
    public void disconnect() throws Exception {
        if (this.mReader != null) {
            try {
                this.mReader.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mReader = null;
        }
        if (this.mWriter != null) {
            try {
                this.mWriter.kill();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mWriter = null;
        }
        try {
            if (this.mHs != null) {
                this.mHs.close();
            } else if (this.mHNs != null) {
                this.mHNs.close();
            }
        }
        catch (Exception exception) {
            System.out.println(this.mEMG.getMessage("FRM-92530", exception.getMessage()));
            exception.printStackTrace(System.out);
        }
        if (this.mOutputMessageQueue != null) {
            this.mOutputMessageQueue.destroy();
            this.mOutputMessageQueue = null;
        }
        this.mHs = null;
        this.mHNs = null;
    }

    @Override
    public void resetRoundTripsCount() {
        this.mRoundTripsCount = 0;
    }

    @Override
    public int getRoundTripsCount() {
        return this.mRoundTripsCount;
    }

    @Override
    public int getMessagesSentCount() {
        return this.mMessagesSentCount;
    }

    @Override
    public int getMessagesReceivedCount() {
        return this.mReader.getMessagesReceivedCount();
    }

    @Override
    public void resetBytesCount() {
        if (this.mHs != null) {
            return;
        }
        if (this.mHNs != null) {
            this.mHNs.resetBytesCount();
            return;
        }
    }

    @Override
    public int getBytesCount() {
        if (this.mHs != null) {
            return this.mHs.getBytesCount();
        }
        if (this.mHNs != null) {
            return this.mHNs.getBytesCount();
        }
        return 0;
    }

    @Override
    public int getBytesReceivedCount() {
        return this.mHs.getBytesCount();
    }

    @Override
    public int getBytesSentCount() {
        return this.mHs.getBytesCount();
    }

    @Override
    public MessageQueue getInputMessageQueue() {
        return this.mReader.getInputMessageQueue();
    }

    @Override
    public MessageQueue getOutputMessageQueue() {
        return this.mOutputMessageQueue;
    }

    @Override
    public synchronized void addMessageListener(Object object) {
        this.mReader.addMessageListener(object);
    }

    @Override
    public synchronized void removeMessageListener(Object object) {
        this.mReader.removeMessageListener(object);
    }

    @Override
    public synchronized void removeTerminalListener(Object object) {
        this.mReader.removeTerminalListener(object);
    }

    @Override
    public synchronized void addTerminalListener(Object object) {
        this.mReader.addTerminalListener(object);
    }
}

