/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import oracle.forms.net.F1URLConnection;
import oracle.forms.net2.F2URLConnection;
import sun.security.util.SecurityConstants;

public abstract class FURLConnection {
    protected static final boolean DEBUG = false;
    public static final boolean sJDKSupportsHttpClient = !System.getProperty("java.version").startsWith("1.");
    private static boolean sUseNewNetApi = false;
    private static boolean sUseHttp2 = false;
    protected boolean mIsHttp = true;
    private static boolean sCreateCalled = false;

    public static final boolean setUseNewNetApi(boolean bl) {
        if (sCreateCalled) {
            throw new IllegalStateException("FURLConnection: setUseNewNetApi() called after create()");
        }
        if (sJDKSupportsHttpClient && !(sUseNewNetApi = bl)) {
            sUseHttp2 = false;
        }
        return sUseNewNetApi;
    }

    public static final boolean getUseNewNetApi() {
        return sUseNewNetApi;
    }

    public static final boolean setUseHttp2(boolean bl) {
        if (sCreateCalled) {
            throw new IllegalStateException("FURLConnection: setUseHttp2() called after create()");
        }
        if (sJDKSupportsHttpClient && (sUseHttp2 = bl)) {
            sUseNewNetApi = true;
        }
        return sUseHttp2;
    }

    public static final boolean getUseHttp2() {
        return sUseHttp2;
    }

    public boolean isHttp() {
        return this.mIsHttp;
    }

    protected FURLConnection(URL uRL) throws IOException {
    }

    public static FURLConnection create(URL uRL) throws IOException {
        sCreateCalled = true;
        if (sUseNewNetApi) {
            try {
                return new F2URLConnection(uRL);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return new F1URLConnection(uRL);
    }

    public abstract void applySslContext(SSLContext var1);

    public abstract void setConnectTimeout(int var1);

    public abstract void setReadTimeout(int var1);

    public abstract void setDoOutput(boolean var1);

    public abstract void setAllowUserInteraction(boolean var1);

    public abstract void setUseCaches(boolean var1);

    public abstract void setIfModifiedSince(long var1);

    public abstract void setRequestProperty(String var1, String var2);

    public abstract void addRequestProperty(String var1, String var2);

    public abstract OutputStream getOutputStream() throws IOException;

    public abstract void connect() throws IOException;

    public abstract String getHeaderField(String var1) throws IOException;

    public abstract Map<String, List<String>> getHeaderFields() throws IOException;

    public abstract InputStream getInputStream() throws IOException;

    public abstract void setInstanceFollowRedirects(boolean var1);

    public abstract boolean getInstanceFollowRedirects();

    public abstract void setRequestMethod(String var1) throws ProtocolException;

    public abstract int getResponseCode() throws IOException;

    public long getHeaderFieldDate(String string, long l) throws IOException {
        String string2 = this.getHeaderField(string);
        try {
            return Date.parse(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public long getHeaderFieldLong(String string, long l) throws IOException {
        String string2 = this.getHeaderField(string);
        try {
            return Long.parseLong(string2);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public int getContentLength() throws IOException {
        long l = this.getContentLengthLong();
        if (l > Integer.MAX_VALUE) {
            return -1;
        }
        return (int)l;
    }

    public long getContentLengthLong() throws IOException {
        return this.getHeaderFieldLong("content-length", -1L);
    }

    public String getContentType() throws IOException {
        return this.getHeaderField("content-type");
    }

    public String getContentEncoding() throws IOException {
        return this.getHeaderField("content-encoding");
    }

    public long getExpiration() throws IOException {
        return this.getHeaderFieldDate("expires", 0L);
    }

    public long getDate() throws IOException {
        return this.getHeaderFieldDate("date", 0L);
    }

    public long getLastModified() throws IOException {
        return this.getHeaderFieldDate("last-modified", 0L);
    }

    public Permission getPermission() throws IOException {
        return SecurityConstants.ALL_PERMISSION;
    }
}

