/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import oracle.forms.net.FURLConnection;

public class F1URLConnection
extends FURLConnection {
    private URLConnection mURLConn = null;
    private boolean mConnected = false;

    protected F1URLConnection(URL uRL) throws IOException {
        super(uRL);
        this.mURLConn = uRL.openConnection();
        this.mIsHttp = this.mURLConn instanceof HttpURLConnection;
    }

    private void checkIsHttp() {
        if (!this.mIsHttp) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public void applySslContext(SSLContext sSLContext) {
        if (!(this.mURLConn instanceof HttpsURLConnection)) {
            throw new UnsupportedOperationException();
        }
        if (this.mConnected) {
            throw new IllegalStateException("Already connected");
        }
        ((HttpsURLConnection)this.mURLConn).setSSLSocketFactory(sSLContext.getSocketFactory());
    }

    @Override
    public void setConnectTimeout(int n) {
        this.mURLConn.setConnectTimeout(n);
    }

    @Override
    public void setReadTimeout(int n) {
        this.mURLConn.setReadTimeout(n);
    }

    @Override
    public void setDoOutput(boolean bl) {
        this.mURLConn.setDoOutput(bl);
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
        this.mURLConn.setAllowUserInteraction(bl);
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.mURLConn.setUseCaches(bl);
    }

    @Override
    public void setIfModifiedSince(long l) {
        this.mURLConn.setIfModifiedSince(l);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.mURLConn.setRequestProperty(string, string2);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.mURLConn.addRequestProperty(string, string2);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.mURLConn.getOutputStream();
    }

    @Override
    public void connect() throws IOException {
        this.mURLConn.connect();
        this.mConnected = true;
    }

    @Override
    public String getHeaderField(String string) {
        return this.mURLConn.getHeaderField(string);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.mURLConn.getHeaderFields();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.mURLConn.getInputStream();
    }

    @Override
    public void setInstanceFollowRedirects(boolean bl) {
        this.checkIsHttp();
        ((HttpURLConnection)this.mURLConn).setInstanceFollowRedirects(bl);
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        this.checkIsHttp();
        return ((HttpURLConnection)this.mURLConn).getInstanceFollowRedirects();
    }

    @Override
    public void setRequestMethod(String string) throws ProtocolException {
        this.checkIsHttp();
        ((HttpURLConnection)this.mURLConn).setRequestMethod(string);
    }

    @Override
    public int getResponseCode() throws IOException {
        this.checkIsHttp();
        return ((HttpURLConnection)this.mURLConn).getResponseCode();
    }
}

