/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptedOutputStream
extends FilterOutputStream {
    protected byte[] mBuf;
    protected int mLength;
    protected int[] mSeedBuffer;
    protected int mI;
    protected int mJ;
    protected OutputStream mOstream;
    private int mBytesCount = 0;

    public EncryptedOutputStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.mBuf = new byte[n];
        this.mLength = 0;
        this.mOstream = this.out;
    }

    public int[] getSeedBuffer() {
        return this.mSeedBuffer;
    }

    public int[] getSeedBufferCopy() {
        int n = this.mSeedBuffer.length;
        int[] nArray = new int[n];
        System.arraycopy(this.mSeedBuffer, 0, nArray, 0, n);
        return nArray;
    }

    public void setSeedBuffer(int[] nArray) {
        this.mSeedBuffer = nArray;
    }

    public int[] getIndexVars() {
        return new int[]{this.mI, this.mJ};
    }

    public void setIndexVars(int[] nArray) {
        this.mI = nArray[0];
        this.mJ = nArray[1];
    }

    public synchronized void setEncryptKey(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0 || byArray.length > 256) {
            throw new RuntimeException();
        }
        this.mSeedBuffer = new int[256];
        this.mJ = 0;
        this.mI = 0;
        for (n = 0; n < 256; ++n) {
            this.mSeedBuffer[n] = n;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            n2 = (n2 + (byArray[n3] & 0xFF) + this.mSeedBuffer[n]) % 256;
            int n4 = this.mSeedBuffer[n];
            this.mSeedBuffer[n] = this.mSeedBuffer[n2];
            this.mSeedBuffer[n2] = n4;
            n3 = (n3 + 1) % byArray.length;
        }
    }

    @Override
    public synchronized void write(int n) throws IOException {
        if (this.mLength >= this.mBuf.length) {
            this.flush();
        }
        this.mBuf[this.mLength++] = (byte)n;
    }

    @Override
    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.mLength + n2 > this.mBuf.length) {
            this.flush();
            if (n2 >= this.mBuf.length) {
                this.mBuf = new byte[this.mBuf.length + n2];
            }
        }
        System.arraycopy(byArray, n, this.mBuf, this.mLength, n2);
        this.mLength += n2;
    }

    public synchronized void eflush(int n) throws IOException {
        if (this.mSeedBuffer != null) {
            for (int i = n; i < this.mLength; ++i) {
                this.mI = (this.mI + 1) % 256;
                this.mJ = (this.mSeedBuffer[this.mI] + this.mJ) % 256;
                int n2 = this.mSeedBuffer[this.mI];
                this.mSeedBuffer[this.mI] = this.mSeedBuffer[this.mJ];
                this.mSeedBuffer[this.mJ] = n2;
                n2 = this.mSeedBuffer[(this.mSeedBuffer[this.mI] + this.mSeedBuffer[this.mJ]) % 256];
                this.mBuf[i] = (byte)(this.mBuf[i] ^ n2);
            }
        }
        this.mOstream.write(this.mBuf, 0, this.mLength);
        this.mOstream.flush();
        this.mBytesCount += this.mLength;
        this.mLength = 0;
    }

    @Override
    public synchronized void flush() throws IOException {
        this.eflush(0);
    }

    public int getBytesCount() {
        return this.mBytesCount;
    }
}

