/*
 * Decompiled with CFR 0.152.
 */
package oracle.forms.net;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncryptedInputStream
extends FilterInputStream {
    protected byte[] mBuf;
    protected int mLength;
    protected int mPos;
    protected int[] mSeedBuffer;
    protected int mI;
    protected int mJ;
    protected int mBytesCount;
    protected InputStream mIstream;

    public EncryptedInputStream(InputStream inputStream, int n) {
        super(inputStream);
        this.mBuf = new byte[n];
        this.mPos = 0;
        this.mLength = 0;
        this.mBytesCount = 0;
        this.mIstream = this.in;
    }

    public int[] getSeedBuffer() {
        return this.mSeedBuffer;
    }

    public void setSeedBuffer(int[] nArray) {
        this.mSeedBuffer = nArray;
    }

    public int[] getIndexVars() {
        return new int[]{this.mI, this.mJ};
    }

    public void setIndexVars(int[] nArray) {
        this.mI = nArray[0];
        this.mJ = nArray[1];
    }

    public synchronized void setEncryptKey(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0 || byArray.length > 256) {
            throw new RuntimeException();
        }
        this.mSeedBuffer = new int[256];
        this.mJ = 0;
        this.mI = 0;
        for (n = 0; n < 256; ++n) {
            this.mSeedBuffer[n] = n;
        }
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            n2 = (n2 + (byArray[n3] & 0xFF) + this.mSeedBuffer[n]) % 256;
            int n4 = this.mSeedBuffer[n];
            this.mSeedBuffer[n] = this.mSeedBuffer[n2];
            this.mSeedBuffer[n2] = n4;
            n3 = (n3 + 1) % byArray.length;
        }
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.mPos == this.mLength) {
            this.fill();
            if (this.mPos == this.mLength) {
                return -1;
            }
        }
        return this.mBuf[this.mPos++] & 0xFF;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (this.mPos + n2 > this.mLength) {
            this.fill();
            if (this.mPos >= this.mLength) {
                return -1;
            }
        }
        n3 = (n3 = this.mLength - this.mPos) < n2 ? n3 : n2;
        System.arraycopy(this.mBuf, this.mPos, byArray, n, n3);
        this.mPos += n3;
        return n3;
    }

    @Override
    public synchronized long skip(long l) throws IOException {
        long l2;
        if (l < 0L) {
            return 0L;
        }
        if (this.mPos == this.mLength) {
            this.fill();
        }
        l2 = (l2 = (long)(this.mLength - this.mPos)) < l ? l2 : l;
        this.mPos = (int)((long)this.mPos + l2);
        return l2;
    }

    private void fill() throws IOException {
        int n;
        if (this.mPos == this.mLength) {
            this.mLength = 0;
            n = 0;
        } else {
            this.mLength -= this.mPos;
            System.arraycopy(this.mBuf, this.mPos, this.mBuf, 0, this.mLength);
            n = this.mLength;
        }
        int n2 = this.mIstream.read(this.mBuf, n, this.mBuf.length - n);
        if (n2 > 0) {
            this.mLength += n2;
            this.mBytesCount += n2;
        }
        this.mPos = 0;
        int[] nArray = this.mSeedBuffer;
        if (nArray != null) {
            int n3 = this.mI;
            int n4 = this.mJ;
            int n5 = n;
            while (n5 < this.mLength) {
                n3 = (n3 + 1) % 256;
                n4 = (nArray[n3] + n4) % 256;
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
                int n7 = n5++;
                this.mBuf[n7] = (byte)(this.mBuf[n7] ^ nArray[(nArray[n3] + n6) % 256]);
            }
            this.mI = n3;
            this.mJ = n4;
        }
    }

    public int getBytesCount() {
        return this.mBytesCount;
    }
}

